'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

const NULL = Symbol('null');
const CREATE_ON_EMPTY = Symbol('create on empty');

class Search {
  constructor(name, query, attrs = {}) {
    this.name = name;
    this.query = query;
    this.attrs = attrs;
  }

  getName() {
    return this.name;
  }

  createQuery() {
    return this.query;
  }

  // A null search has insufficient information to construct a canned query, so it should always return no results.
  isNull() {
    return this.attrs[NULL] || false;
  }

  showCreateOnEmpty() {
    return this.attrs[CREATE_ON_EMPTY] || false;
  }

  getWebURL(remote) {
    if (!remote.isGithubRepo()) {
      throw new Error(`Attempt to generate web URL for non-GitHub remote ${remote.getName()}`);
    }

    return `https://${remote.getDomain()}/search?q=${encodeURIComponent(this.createQuery())}`;
  }

  static inRemote(remote, name, query, attrs = {}) {
    if (!remote.isGithubRepo()) {
      return new this(name, '', _extends({}, attrs, { [NULL]: true }));
    }

    return new this(name, `repo:${remote.getOwner()}/${remote.getRepo()} ${query.trim()}`, attrs);
  }
}

exports.default = Search;
const nullSearch = exports.nullSearch = new Search('', '', { [NULL]: true });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlYXJjaC5qcyJdLCJuYW1lcyI6WyJOVUxMIiwiU3ltYm9sIiwiQ1JFQVRFX09OX0VNUFRZIiwiU2VhcmNoIiwiY29uc3RydWN0b3IiLCJuYW1lIiwicXVlcnkiLCJhdHRycyIsImdldE5hbWUiLCJjcmVhdGVRdWVyeSIsImlzTnVsbCIsInNob3dDcmVhdGVPbkVtcHR5IiwiZ2V0V2ViVVJMIiwicmVtb3RlIiwiaXNHaXRodWJSZXBvIiwiRXJyb3IiLCJnZXREb21haW4iLCJlbmNvZGVVUklDb21wb25lbnQiLCJpblJlbW90ZSIsImdldE93bmVyIiwiZ2V0UmVwbyIsInRyaW0iLCJudWxsU2VhcmNoIl0sIm1hcHBpbmdzIjoiOzs7Ozs7OztBQUFBLE1BQU1BLE9BQU9DLE9BQU8sTUFBUCxDQUFiO0FBQ0EsTUFBTUMsa0JBQWtCRCxPQUFPLGlCQUFQLENBQXhCOztBQUVlLE1BQU1FLE1BQU4sQ0FBYTtBQUMxQkMsY0FBWUMsSUFBWixFQUFrQkMsS0FBbEIsRUFBeUJDLFFBQVEsRUFBakMsRUFBcUM7QUFDbkMsU0FBS0YsSUFBTCxHQUFZQSxJQUFaO0FBQ0EsU0FBS0MsS0FBTCxHQUFhQSxLQUFiO0FBQ0EsU0FBS0MsS0FBTCxHQUFhQSxLQUFiO0FBQ0Q7O0FBRURDLFlBQVU7QUFDUixXQUFPLEtBQUtILElBQVo7QUFDRDs7QUFFREksZ0JBQWM7QUFDWixXQUFPLEtBQUtILEtBQVo7QUFDRDs7QUFFRDtBQUNBSSxXQUFTO0FBQ1AsV0FBTyxLQUFLSCxLQUFMLENBQVdQLElBQVgsS0FBb0IsS0FBM0I7QUFDRDs7QUFFRFcsc0JBQW9CO0FBQ2xCLFdBQU8sS0FBS0osS0FBTCxDQUFXTCxlQUFYLEtBQStCLEtBQXRDO0FBQ0Q7O0FBRURVLFlBQVVDLE1BQVYsRUFBa0I7QUFDaEIsUUFBSSxDQUFDQSxPQUFPQyxZQUFQLEVBQUwsRUFBNEI7QUFDMUIsWUFBTSxJQUFJQyxLQUFKLENBQVcscURBQW9ERixPQUFPTCxPQUFQLEVBQWlCLEVBQWhGLENBQU47QUFDRDs7QUFFRCxXQUFRLFdBQVVLLE9BQU9HLFNBQVAsRUFBbUIsYUFBWUMsbUJBQW1CLEtBQUtSLFdBQUwsRUFBbkIsQ0FBdUMsRUFBeEY7QUFDRDs7QUFFRCxTQUFPUyxRQUFQLENBQWdCTCxNQUFoQixFQUF3QlIsSUFBeEIsRUFBOEJDLEtBQTlCLEVBQXFDQyxRQUFRLEVBQTdDLEVBQWlEO0FBQy9DLFFBQUksQ0FBQ00sT0FBT0MsWUFBUCxFQUFMLEVBQTRCO0FBQzFCLGFBQU8sSUFBSSxJQUFKLENBQVNULElBQVQsRUFBZSxFQUFmLGVBQXVCRSxLQUF2QixJQUE4QixDQUFDUCxJQUFELEdBQVEsSUFBdEMsSUFBUDtBQUNEOztBQUVELFdBQU8sSUFBSSxJQUFKLENBQVNLLElBQVQsRUFBZ0IsUUFBT1EsT0FBT00sUUFBUCxFQUFrQixJQUFHTixPQUFPTyxPQUFQLEVBQWlCLElBQUdkLE1BQU1lLElBQU4sRUFBYSxFQUE3RSxFQUFnRmQsS0FBaEYsQ0FBUDtBQUNEO0FBdEN5Qjs7a0JBQVBKLE07QUF5Q2QsTUFBTW1CLGtDQUFhLElBQUluQixNQUFKLENBQVcsRUFBWCxFQUFlLEVBQWYsRUFBbUIsRUFBQyxDQUFDSCxJQUFELEdBQVEsSUFBVCxFQUFuQixDQUFuQiIsImZpbGUiOiJzZWFyY2guanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvbW9kZWxzIiwic291cmNlc0NvbnRlbnQiOlsiY29uc3QgTlVMTCA9IFN5bWJvbCgnbnVsbCcpO1xuY29uc3QgQ1JFQVRFX09OX0VNUFRZID0gU3ltYm9sKCdjcmVhdGUgb24gZW1wdHknKTtcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgU2VhcmNoIHtcbiAgY29uc3RydWN0b3IobmFtZSwgcXVlcnksIGF0dHJzID0ge30pIHtcbiAgICB0aGlzLm5hbWUgPSBuYW1lO1xuICAgIHRoaXMucXVlcnkgPSBxdWVyeTtcbiAgICB0aGlzLmF0dHJzID0gYXR0cnM7XG4gIH1cblxuICBnZXROYW1lKCkge1xuICAgIHJldHVybiB0aGlzLm5hbWU7XG4gIH1cblxuICBjcmVhdGVRdWVyeSgpIHtcbiAgICByZXR1cm4gdGhpcy5xdWVyeTtcbiAgfVxuXG4gIC8vIEEgbnVsbCBzZWFyY2ggaGFzIGluc3VmZmljaWVudCBpbmZvcm1hdGlvbiB0byBjb25zdHJ1Y3QgYSBjYW5uZWQgcXVlcnksIHNvIGl0IHNob3VsZCBhbHdheXMgcmV0dXJuIG5vIHJlc3VsdHMuXG4gIGlzTnVsbCgpIHtcbiAgICByZXR1cm4gdGhpcy5hdHRyc1tOVUxMXSB8fCBmYWxzZTtcbiAgfVxuXG4gIHNob3dDcmVhdGVPbkVtcHR5KCkge1xuICAgIHJldHVybiB0aGlzLmF0dHJzW0NSRUFURV9PTl9FTVBUWV0gfHwgZmFsc2U7XG4gIH1cblxuICBnZXRXZWJVUkwocmVtb3RlKSB7XG4gICAgaWYgKCFyZW1vdGUuaXNHaXRodWJSZXBvKCkpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgQXR0ZW1wdCB0byBnZW5lcmF0ZSB3ZWIgVVJMIGZvciBub24tR2l0SHViIHJlbW90ZSAke3JlbW90ZS5nZXROYW1lKCl9YCk7XG4gICAgfVxuXG4gICAgcmV0dXJuIGBodHRwczovLyR7cmVtb3RlLmdldERvbWFpbigpfS9zZWFyY2g/cT0ke2VuY29kZVVSSUNvbXBvbmVudCh0aGlzLmNyZWF0ZVF1ZXJ5KCkpfWA7XG4gIH1cblxuICBzdGF0aWMgaW5SZW1vdGUocmVtb3RlLCBuYW1lLCBxdWVyeSwgYXR0cnMgPSB7fSkge1xuICAgIGlmICghcmVtb3RlLmlzR2l0aHViUmVwbygpKSB7XG4gICAgICByZXR1cm4gbmV3IHRoaXMobmFtZSwgJycsIHsuLi5hdHRycywgW05VTExdOiB0cnVlfSk7XG4gICAgfVxuXG4gICAgcmV0dXJuIG5ldyB0aGlzKG5hbWUsIGByZXBvOiR7cmVtb3RlLmdldE93bmVyKCl9LyR7cmVtb3RlLmdldFJlcG8oKX0gJHtxdWVyeS50cmltKCl9YCwgYXR0cnMpO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBudWxsU2VhcmNoID0gbmV3IFNlYXJjaCgnJywgJycsIHtbTlVMTF06IHRydWV9KTtcbiJdfQ==