'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _reactRelay = require('react-relay');

var _userMentionTooltipContainer = require('../containers/user-mention-tooltip-container');

var _userMentionTooltipContainer2 = _interopRequireDefault(_userMentionTooltipContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class UserMentionTooltipItem {
  constructor(username, relayEnvironment) {
    this.username = username.substr(1);
    this.relayEnvironment = relayEnvironment;
  }

  getElement() {
    return this.element;
  }

  get element() {
    if (!this._element) {
      this._element = document.createElement('div');
      const rootContainer = _react2.default.createElement(_reactRelay.QueryRenderer, {
        environment: this.relayEnvironment,
        query: _graphql || (_graphql = function () {
          const node = require('./__generated__/userMentionTooltipItemQuery.graphql');

          if (node.hash && node.hash !== 'c0e8b6f6d3028f3f2679ce9e1486981e') {
            console.error('The definition of \'userMentionTooltipItemQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
          }

          return require('./__generated__/userMentionTooltipItemQuery.graphql');
        }),
        variables: {
          username: this.username
        },
        render: ({ error, props, retry }) => {
          if (error) {
            return _react2.default.createElement(
              'div',
              null,
              'Could not load information'
            );
          } else if (props) {
            return _react2.default.createElement(_userMentionTooltipContainer2.default, props);
          } else {
            return _react2.default.createElement(
              'div',
              { className: 'github-Loader' },
              _react2.default.createElement('span', { className: 'github-Spinner' })
            );
          }
        }
      });
      this._component = _reactDom2.default.render(rootContainer, this._element);
    }

    return this._element;
  }

  destroy() {
    if (this._element) {
      _reactDom2.default.unmountComponentAtNode(this._element);
      delete this._element;
    }
  }
}
exports.default = UserMentionTooltipItem;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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