'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _propTypes3 = require('../prop-types');

var _commitDetailContainer = require('../containers/commit-detail-container');

var _commitDetailContainer2 = _interopRequireDefault(_commitDetailContainer);

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class CommitDetailItem extends _react2.default.Component {

  static buildURI(workingDirectory, sha) {
    return `atom-github://commit-detail?workdir=${encodeURIComponent(workingDirectory)}&sha=${encodeURIComponent(sha)}`;
  }

  constructor(props) {
    super(props);

    this.destroy = () => {
      /* istanbul ignore else */
      if (!this.isDestroyed) {
        this.emitter.emit('did-destroy');
        this.isDestroyed = true;
      }
    };

    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.shouldFocus = true;
    this.refInitialFocus = new _refHolder2.default();
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();

    return _react2.default.createElement(_commitDetailContainer2.default, _extends({
      itemType: this.constructor,
      repository: repository
    }, this.props, {
      destroy: this.destroy,
      refInitialFocus: this.refInitialFocus
    }));
  }

  getTitle() {
    return `Commit: ${this.props.sha}`;
  }

  getIconName() {
    return 'git-commit';
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  getSha() {
    return this.props.sha;
  }

  serialize() {
    return {
      deserializer: 'CommitDetailStub',
      uri: CommitDetailItem.buildURI(this.props.workingDirectory, this.props.sha)
    };
  }

  preventFocus() {
    this.shouldFocus = false;
  }

  focus() {
    this.refInitialFocus.getPromise().then(focusable => {
      if (!this.shouldFocus) {
        return;
      }

      focusable.focus();
    });
  }
}
exports.default = CommitDetailItem;
CommitDetailItem.propTypes = {
  workdirContextPool: _propTypes3.WorkdirContextPoolPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  sha: _propTypes2.default.string.isRequired
};
CommitDetailItem.uriPattern = 'atom-github://commit-detail?workdir={workingDirectory}&sha={sha}';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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