'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _electron = require('electron');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _search = require('../models/search');

var _search2 = _interopRequireDefault(_search);

var _issueishSearchContainer = require('../containers/issueish-search-container');

var _issueishSearchContainer2 = _interopRequireDefault(_issueishSearchContainer);

var _currentPullRequestContainer = require('../containers/current-pull-request-container');

var _currentPullRequestContainer2 = _interopRequireDefault(_currentPullRequestContainer);

var _issueishDetailItem = require('../items/issueish-detail-item');

var _issueishDetailItem2 = _interopRequireDefault(_issueishDetailItem);

var _reporterProxy = require('../reporter-proxy');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishSearchesController extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onOpenIssueish', 'onOpenSearch');

    this.state = {};
  }

  static getDerivedStateFromProps(props) {
    return {
      searches: [_search2.default.inRemote(props.remote, 'Open pull requests', 'type:pr state:open')]
    };
  }

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishSearch' },
      _react2.default.createElement(_currentPullRequestContainer2.default, {
        repository: this.props.repository,
        token: this.props.token,
        endpoint: this.props.endpoint,
        remoteOperationObserver: this.props.remoteOperationObserver,
        remote: this.props.remote,
        remotes: this.props.remotes,
        branches: this.props.branches,
        aheadCount: this.props.aheadCount,
        pushInProgress: this.props.pushInProgress,

        onOpenIssueish: this.onOpenIssueish,
        onCreatePr: this.props.onCreatePr
      }),
      this.state.searches.map(search => _react2.default.createElement(_issueishSearchContainer2.default, {
        key: search.getName(),

        token: this.props.token,
        endpoint: this.props.endpoint,
        search: search,
        remoteOperationObserver: this.props.remoteOperationObserver,

        onOpenIssueish: this.onOpenIssueish,
        onOpenSearch: this.onOpenSearch
      }))
    );
  }

  onOpenIssueish(issueish) {
    return this.props.workspace.open(_issueishDetailItem2.default.buildURI(this.props.endpoint.getHost(), this.props.remote.getOwner(), this.props.remote.getRepo(), issueish.getNumber(), this.props.workingDirectory), { pending: true, searchAllPanes: true }).then(() => {
      (0, _reporterProxy.addEvent)('open-issueish-in-pane', { package: 'github', from: 'issueish-list' });
    });
  }

  onOpenSearch(search) {
    const searchURL = search.getWebURL(this.props.remote);

    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(searchURL, {}, err => {
        if (err) {
          reject(err);
        } else {
          resolve();
        }
      });
    });
  }
}
exports.default = IssueishSearchesController;
IssueishSearchesController.propTypes = {
  // Relay payload
  repository: _propTypes2.default.shape({
    id: _propTypes2.default.string.isRequired,
    defaultBranchRef: _propTypes2.default.shape({
      prefix: _propTypes2.default.string.isRequired,
      name: _propTypes2.default.string.isRequired
    })
  }),

  // Connection
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,

  // Repository model attributes
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes2.default.string.isRequired,
  remote: _propTypes3.RemotePropType.isRequired,
  remotes: _propTypes3.RemoteSetPropType.isRequired,
  branches: _propTypes3.BranchSetPropType.isRequired,
  aheadCount: _propTypes2.default.number,
  pushInProgress: _propTypes2.default.bool.isRequired,

  // Actions
  onCreatePr: _propTypes2.default.func.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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