'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _whatTheDiff = require('what-the-diff');

var _propTypes3 = require('../prop-types');

var _multiFilePatchController = require('../controllers/multi-file-patch-controller');

var _multiFilePatchController2 = _interopRequireDefault(_multiFilePatchController);

var _loadingView = require('../views/loading-view');

var _loadingView2 = _interopRequireDefault(_loadingView);

var _errorView = require('../views/error-view');

var _errorView2 = _interopRequireDefault(_errorView);

var _patch = require('../models/patch');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class PullRequestChangedFilesContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    this.state = { isLoading: true, error: null };
    this.fetchDiff();
  }

  componentDidUpdate(prevProps) {
    if (this.props.shouldRefetch && !prevProps.shouldRefetch) {
      this.setState({ isLoading: true, error: null });
      this.fetchDiff();
    }
  }

  // Generate a v3 GitHub API REST URL for the pull request resource.
  // Example: https://api.github.com/repos/atom/github/pulls/1829
  getDiffURL() {
    return this.props.endpoint.getRestURI('repos', this.props.owner, this.props.repo, 'pulls', this.props.number);
  }

  buildPatch(rawDiff) {
    const diffs = (0, _whatTheDiff.parse)(rawDiff).map(diff => {
      // diff coming from API will have the defaul git diff prefixes a/ and b/
      // e.g. a/file1.js and b/file2.js
      // see https://git-scm.com/docs/git-diff#_generating_patches_with_p
      return _extends({}, diff, {
        newPath: diff.newPath ? diff.newPath.replace(/^[a|b]\//, '') : diff.newPath,
        oldPath: diff.oldPath ? diff.oldPath.replace(/^[a|b]\//, '') : diff.oldPath
      });
    });
    return (0, _patch.buildMultiFilePatch)(diffs);
  }

  async fetchDiff() {
    const diffError = (message, err = null) => new Promise(resolve => {
      if (err) {
        // eslint-disable-next-line no-console
        console.error(err);
      }
      this.setState({ isLoading: false, error: message }, resolve);
    });
    const url = this.getDiffURL();

    const response = await fetch(url, {
      headers: {
        Accept: 'application/vnd.github.v3.diff',
        Authorization: `bearer ${this.props.token}`
      }
      // eslint-disable-next-line handle-callback-err
    }).catch(err => {
      diffError(`Network error encountered at fetching ${url}`, err);
    });
    if (this.state.error) {
      return;
    }
    try {
      if (response && response.ok) {
        const rawDiff = await response.text();
        const multiFilePatch = this.buildPatch(rawDiff);
        await new Promise(resolve => this.setState({ isLoading: false, multiFilePatch }, resolve));
      } else {
        diffError(`Unable to fetch diff for this pull request${response ? ': ' + response.statusText : ''}.`);
      }
    } catch (err) {
      diffError('Unable to parse diff for this pull request.', err);
    }
  }

  render() {
    if (this.state.isLoading) {
      return _react2.default.createElement(_loadingView2.default, null);
    }

    if (this.state.error) {
      return _react2.default.createElement(_errorView2.default, { descriptions: [this.state.error] });
    }

    return _react2.default.createElement(_multiFilePatchController2.default, _extends({
      multiFilePatch: this.state.multiFilePatch,
      repository: this.props.localRepository
    }, this.props));
  }
}
exports.default = PullRequestChangedFilesContainer;
PullRequestChangedFilesContainer.propTypes = {
  // Pull request properties
  owner: _propTypes2.default.string.isRequired,
  repo: _propTypes2.default.string.isRequired,
  number: _propTypes2.default.number.isRequired,

  // Connection properties
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Item context
  itemType: _propTypes3.ItemTypePropType.isRequired,

  // action methods
  destroy: _propTypes2.default.func.isRequired,

  // Atom environment
  workspace: _propTypes2.default.object.isRequired,
  commands: _propTypes2.default.object.isRequired,
  keymaps: _propTypes2.default.object.isRequired,
  tooltips: _propTypes2.default.object.isRequired,
  config: _propTypes2.default.object.isRequired,

  // local repo as opposed to pull request repo
  localRepository: _propTypes2.default.object.isRequired,

  // refetch diff on refresh
  shouldRefetch: _propTypes2.default.bool.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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