'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _graphql;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactRelay = require('react-relay');

var _eventKit = require('event-kit');

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _issueishListController = require('../controllers/issueish-list-controller');

var _issueishListController2 = _interopRequireDefault(_issueishListController);

var _relayNetworkLayerManager = require('../relay-network-layer-manager');

var _relayNetworkLayerManager2 = _interopRequireDefault(_relayNetworkLayerManager);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class IssueishSearchContainer extends _react2.default.Component {

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'renderQueryResult');

    this.sub = new _eventKit.Disposable();
  }

  render() {
    const environment = _relayNetworkLayerManager2.default.getEnvironmentForHost(this.props.endpoint, this.props.token);

    if (this.props.search.isNull()) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false
      }, this.controllerProps()));
    }

    const query = _graphql || (_graphql = function () {
      const node = require('./__generated__/issueishSearchContainerQuery.graphql');

      if (node.hash && node.hash !== 'fc553ba742c51417ea1a857b96038345') {
        console.error('The definition of \'issueishSearchContainerQuery\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
      }

      return require('./__generated__/issueishSearchContainerQuery.graphql');
    });
    const variables = {
      query: this.props.search.createQuery(),
      first: this.props.limit
    };

    return _react2.default.createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      variables: variables,
      query: query,
      render: this.renderQueryResult
    });
  }

  renderQueryResult({ error, props, retry }) {
    if (retry) {
      this.sub.dispose();
      this.sub = this.props.remoteOperationObserver.onDidComplete(retry);
    }

    if (error) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: false,
        error: error
      }, this.controllerProps()));
    }

    if (props === null) {
      return _react2.default.createElement(_issueishListController.BareIssueishListController, _extends({
        isLoading: true
      }, this.controllerProps()));
    }

    return _react2.default.createElement(_issueishListController2.default, _extends({
      total: props.search.issueCount,
      results: props.search.nodes,
      isLoading: false
    }, this.controllerProps()));
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  controllerProps() {
    return {
      title: this.props.search.getName(),

      onOpenIssueish: this.props.onOpenIssueish,
      onOpenMore: () => this.props.onOpenSearch(this.props.search)
    };
  }
}
exports.default = IssueishSearchContainer;
IssueishSearchContainer.propTypes = {
  // Connection information
  endpoint: _propTypes3.EndpointPropType.isRequired,
  token: _propTypes2.default.string.isRequired,

  // Search model
  limit: _propTypes2.default.number,
  search: _propTypes3.SearchPropType.isRequired,
  remoteOperationObserver: _propTypes3.OperationStateObserverPropType.isRequired,

  // Action methods
  onOpenIssueish: _propTypes2.default.func.isRequired,
  onOpenSearch: _propTypes2.default.func.isRequired
};
IssueishSearchContainer.defaultProps = {
  limit: 20
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImlzc3VlaXNoLXNlYXJjaC1jb250YWluZXIuanMiXSwibmFtZXMiOlsiSXNzdWVpc2hTZWFyY2hDb250YWluZXIiLCJSZWFjdCIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJzdWIiLCJEaXNwb3NhYmxlIiwicmVuZGVyIiwiZW52aXJvbm1lbnQiLCJSZWxheU5ldHdvcmtMYXllck1hbmFnZXIiLCJnZXRFbnZpcm9ubWVudEZvckhvc3QiLCJlbmRwb2ludCIsInRva2VuIiwic2VhcmNoIiwiaXNOdWxsIiwiY29udHJvbGxlclByb3BzIiwicXVlcnkiLCJ2YXJpYWJsZXMiLCJjcmVhdGVRdWVyeSIsImZpcnN0IiwibGltaXQiLCJyZW5kZXJRdWVyeVJlc3VsdCIsImVycm9yIiwicmV0cnkiLCJkaXNwb3NlIiwicmVtb3RlT3BlcmF0aW9uT2JzZXJ2ZXIiLCJvbkRpZENvbXBsZXRlIiwiaXNzdWVDb3VudCIsIm5vZGVzIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJ0aXRsZSIsImdldE5hbWUiLCJvbk9wZW5Jc3N1ZWlzaCIsIm9uT3Blbk1vcmUiLCJvbk9wZW5TZWFyY2giLCJwcm9wVHlwZXMiLCJFbmRwb2ludFByb3BUeXBlIiwiaXNSZXF1aXJlZCIsIlByb3BUeXBlcyIsInN0cmluZyIsIm51bWJlciIsIlNlYXJjaFByb3BUeXBlIiwiT3BlcmF0aW9uU3RhdGVPYnNlcnZlclByb3BUeXBlIiwiZnVuYyIsImRlZmF1bHRQcm9wcyJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFDQTs7QUFFQTs7QUFDQTs7QUFDQTs7OztBQUNBOzs7Ozs7QUFFZSxNQUFNQSx1QkFBTixTQUFzQ0MsZ0JBQU1DLFNBQTVDLENBQXNEOztBQW9CbkVDLGNBQVlDLEtBQVosRUFBbUI7QUFDakIsVUFBTUEsS0FBTjtBQUNBLDJCQUFTLElBQVQsRUFBZSxtQkFBZjs7QUFFQSxTQUFLQyxHQUFMLEdBQVcsSUFBSUMsb0JBQUosRUFBWDtBQUNEOztBQUVEQyxXQUFTO0FBQ1AsVUFBTUMsY0FBY0MsbUNBQXlCQyxxQkFBekIsQ0FBK0MsS0FBS04sS0FBTCxDQUFXTyxRQUExRCxFQUFvRSxLQUFLUCxLQUFMLENBQVdRLEtBQS9FLENBQXBCOztBQUVBLFFBQUksS0FBS1IsS0FBTCxDQUFXUyxNQUFYLENBQWtCQyxNQUFsQixFQUFKLEVBQWdDO0FBQzlCLGFBQ0UsOEJBQUMsa0RBQUQ7QUFDRSxtQkFBVztBQURiLFNBRU0sS0FBS0MsZUFBTCxFQUZOLEVBREY7QUFNRDs7QUFFRCxVQUFNQztBQUFBOztBQUFBO0FBQUE7QUFBQTs7QUFBQTtBQUFBLE1BQU47QUFVQSxVQUFNQyxZQUFZO0FBQ2hCRCxhQUFPLEtBQUtaLEtBQUwsQ0FBV1MsTUFBWCxDQUFrQkssV0FBbEIsRUFEUztBQUVoQkMsYUFBTyxLQUFLZixLQUFMLENBQVdnQjtBQUZGLEtBQWxCOztBQUtBLFdBQ0UsOEJBQUMseUJBQUQ7QUFDRSxtQkFBYVosV0FEZjtBQUVFLGlCQUFXUyxTQUZiO0FBR0UsYUFBT0QsS0FIVDtBQUlFLGNBQVEsS0FBS0s7QUFKZixNQURGO0FBUUQ7O0FBRURBLG9CQUFrQixFQUFDQyxLQUFELEVBQVFsQixLQUFSLEVBQWVtQixLQUFmLEVBQWxCLEVBQXlDO0FBQ3ZDLFFBQUlBLEtBQUosRUFBVztBQUNULFdBQUtsQixHQUFMLENBQVNtQixPQUFUO0FBQ0EsV0FBS25CLEdBQUwsR0FBVyxLQUFLRCxLQUFMLENBQVdxQix1QkFBWCxDQUFtQ0MsYUFBbkMsQ0FBaURILEtBQWpELENBQVg7QUFDRDs7QUFFRCxRQUFJRCxLQUFKLEVBQVc7QUFDVCxhQUNFLDhCQUFDLGtEQUFEO0FBQ0UsbUJBQVcsS0FEYjtBQUVFLGVBQU9BO0FBRlQsU0FHTSxLQUFLUCxlQUFMLEVBSE4sRUFERjtBQU9EOztBQUVELFFBQUlYLFVBQVUsSUFBZCxFQUFvQjtBQUNsQixhQUNFLDhCQUFDLGtEQUFEO0FBQ0UsbUJBQVc7QUFEYixTQUVNLEtBQUtXLGVBQUwsRUFGTixFQURGO0FBTUQ7O0FBRUQsV0FDRSw4QkFBQyxnQ0FBRDtBQUNFLGFBQU9YLE1BQU1TLE1BQU4sQ0FBYWMsVUFEdEI7QUFFRSxlQUFTdkIsTUFBTVMsTUFBTixDQUFhZSxLQUZ4QjtBQUdFLGlCQUFXO0FBSGIsT0FJTSxLQUFLYixlQUFMLEVBSk4sRUFERjtBQVFEOztBQUVEYyx5QkFBdUI7QUFDckIsU0FBS3hCLEdBQUwsQ0FBU21CLE9BQVQ7QUFDRDs7QUFFRFQsb0JBQWtCO0FBQ2hCLFdBQU87QUFDTGUsYUFBTyxLQUFLMUIsS0FBTCxDQUFXUyxNQUFYLENBQWtCa0IsT0FBbEIsRUFERjs7QUFHTEMsc0JBQWdCLEtBQUs1QixLQUFMLENBQVc0QixjQUh0QjtBQUlMQyxrQkFBWSxNQUFNLEtBQUs3QixLQUFMLENBQVc4QixZQUFYLENBQXdCLEtBQUs5QixLQUFMLENBQVdTLE1BQW5DO0FBSmIsS0FBUDtBQU1EO0FBOUdrRTtrQkFBaERiLHVCO0FBQUFBLHVCLENBQ1ptQyxTLEdBQVk7QUFDakI7QUFDQXhCLFlBQVV5Qiw2QkFBaUJDLFVBRlY7QUFHakJ6QixTQUFPMEIsb0JBQVVDLE1BQVYsQ0FBaUJGLFVBSFA7O0FBS2pCO0FBQ0FqQixTQUFPa0Isb0JBQVVFLE1BTkE7QUFPakIzQixVQUFRNEIsMkJBQWVKLFVBUE47QUFRakJaLDJCQUF5QmlCLDJDQUErQkwsVUFSdkM7O0FBVWpCO0FBQ0FMLGtCQUFnQk0sb0JBQVVLLElBQVYsQ0FBZU4sVUFYZDtBQVlqQkgsZ0JBQWNJLG9CQUFVSyxJQUFWLENBQWVOO0FBWlosQztBQURBckMsdUIsQ0FnQlo0QyxZLEdBQWU7QUFDcEJ4QixTQUFPO0FBRGEsQyIsImZpbGUiOiJpc3N1ZWlzaC1zZWFyY2gtY29udGFpbmVyLmpzIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tLTEuMzUuMS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIvbGliL2NvbnRhaW5lcnMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcbmltcG9ydCB7UXVlcnlSZW5kZXJlciwgZ3JhcGhxbH0gZnJvbSAncmVhY3QtcmVsYXknO1xuaW1wb3J0IHtEaXNwb3NhYmxlfSBmcm9tICdldmVudC1raXQnO1xuXG5pbXBvcnQge2F1dG9iaW5kfSBmcm9tICcuLi9oZWxwZXJzJztcbmltcG9ydCB7U2VhcmNoUHJvcFR5cGUsIE9wZXJhdGlvblN0YXRlT2JzZXJ2ZXJQcm9wVHlwZSwgRW5kcG9pbnRQcm9wVHlwZX0gZnJvbSAnLi4vcHJvcC10eXBlcyc7XG5pbXBvcnQgSXNzdWVpc2hMaXN0Q29udHJvbGxlciwge0JhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyfSBmcm9tICcuLi9jb250cm9sbGVycy9pc3N1ZWlzaC1saXN0LWNvbnRyb2xsZXInO1xuaW1wb3J0IFJlbGF5TmV0d29ya0xheWVyTWFuYWdlciBmcm9tICcuLi9yZWxheS1uZXR3b3JrLWxheWVyLW1hbmFnZXInO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBJc3N1ZWlzaFNlYXJjaENvbnRhaW5lciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgLy8gQ29ubmVjdGlvbiBpbmZvcm1hdGlvblxuICAgIGVuZHBvaW50OiBFbmRwb2ludFByb3BUeXBlLmlzUmVxdWlyZWQsXG4gICAgdG9rZW46IFByb3BUeXBlcy5zdHJpbmcuaXNSZXF1aXJlZCxcblxuICAgIC8vIFNlYXJjaCBtb2RlbFxuICAgIGxpbWl0OiBQcm9wVHlwZXMubnVtYmVyLFxuICAgIHNlYXJjaDogU2VhcmNoUHJvcFR5cGUuaXNSZXF1aXJlZCxcbiAgICByZW1vdGVPcGVyYXRpb25PYnNlcnZlcjogT3BlcmF0aW9uU3RhdGVPYnNlcnZlclByb3BUeXBlLmlzUmVxdWlyZWQsXG5cbiAgICAvLyBBY3Rpb24gbWV0aG9kc1xuICAgIG9uT3Blbklzc3VlaXNoOiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIG9uT3BlblNlYXJjaDogUHJvcFR5cGVzLmZ1bmMuaXNSZXF1aXJlZCxcbiAgfVxuXG4gIHN0YXRpYyBkZWZhdWx0UHJvcHMgPSB7XG4gICAgbGltaXQ6IDIwLFxuICB9XG5cbiAgY29uc3RydWN0b3IocHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgYXV0b2JpbmQodGhpcywgJ3JlbmRlclF1ZXJ5UmVzdWx0Jyk7XG5cbiAgICB0aGlzLnN1YiA9IG5ldyBEaXNwb3NhYmxlKCk7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgY29uc3QgZW52aXJvbm1lbnQgPSBSZWxheU5ldHdvcmtMYXllck1hbmFnZXIuZ2V0RW52aXJvbm1lbnRGb3JIb3N0KHRoaXMucHJvcHMuZW5kcG9pbnQsIHRoaXMucHJvcHMudG9rZW4pO1xuXG4gICAgaWYgKHRoaXMucHJvcHMuc2VhcmNoLmlzTnVsbCgpKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICA8QmFyZUlzc3VlaXNoTGlzdENvbnRyb2xsZXJcbiAgICAgICAgICBpc0xvYWRpbmc9e2ZhbHNlfVxuICAgICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICBjb25zdCBxdWVyeSA9IGdyYXBocWxgXG4gICAgICBxdWVyeSBpc3N1ZWlzaFNlYXJjaENvbnRhaW5lclF1ZXJ5KCRxdWVyeTogU3RyaW5nISwgJGZpcnN0OiBJbnQhKSB7XG4gICAgICAgIHNlYXJjaChmaXJzdDogJGZpcnN0LCBxdWVyeTogJHF1ZXJ5LCB0eXBlOiBJU1NVRSkge1xuICAgICAgICAgIGlzc3VlQ291bnRcbiAgICAgICAgICBub2RlcyB7XG4gICAgICAgICAgICAuLi5pc3N1ZWlzaExpc3RDb250cm9sbGVyX3Jlc3VsdHNcbiAgICAgICAgICB9XG4gICAgICAgIH1cbiAgICAgIH1cbiAgICBgO1xuICAgIGNvbnN0IHZhcmlhYmxlcyA9IHtcbiAgICAgIHF1ZXJ5OiB0aGlzLnByb3BzLnNlYXJjaC5jcmVhdGVRdWVyeSgpLFxuICAgICAgZmlyc3Q6IHRoaXMucHJvcHMubGltaXQsXG4gICAgfTtcblxuICAgIHJldHVybiAoXG4gICAgICA8UXVlcnlSZW5kZXJlclxuICAgICAgICBlbnZpcm9ubWVudD17ZW52aXJvbm1lbnR9XG4gICAgICAgIHZhcmlhYmxlcz17dmFyaWFibGVzfVxuICAgICAgICBxdWVyeT17cXVlcnl9XG4gICAgICAgIHJlbmRlcj17dGhpcy5yZW5kZXJRdWVyeVJlc3VsdH1cbiAgICAgIC8+XG4gICAgKTtcbiAgfVxuXG4gIHJlbmRlclF1ZXJ5UmVzdWx0KHtlcnJvciwgcHJvcHMsIHJldHJ5fSkge1xuICAgIGlmIChyZXRyeSkge1xuICAgICAgdGhpcy5zdWIuZGlzcG9zZSgpO1xuICAgICAgdGhpcy5zdWIgPSB0aGlzLnByb3BzLnJlbW90ZU9wZXJhdGlvbk9ic2VydmVyLm9uRGlkQ29tcGxldGUocmV0cnkpO1xuICAgIH1cblxuICAgIGlmIChlcnJvcikge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPEJhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyXG4gICAgICAgICAgaXNMb2FkaW5nPXtmYWxzZX1cbiAgICAgICAgICBlcnJvcj17ZXJyb3J9XG4gICAgICAgICAgey4uLnRoaXMuY29udHJvbGxlclByb3BzKCl9XG4gICAgICAgIC8+XG4gICAgICApO1xuICAgIH1cblxuICAgIGlmIChwcm9wcyA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuIChcbiAgICAgICAgPEJhcmVJc3N1ZWlzaExpc3RDb250cm9sbGVyXG4gICAgICAgICAgaXNMb2FkaW5nPXt0cnVlfVxuICAgICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgICAvPlxuICAgICAgKTtcbiAgICB9XG5cbiAgICByZXR1cm4gKFxuICAgICAgPElzc3VlaXNoTGlzdENvbnRyb2xsZXJcbiAgICAgICAgdG90YWw9e3Byb3BzLnNlYXJjaC5pc3N1ZUNvdW50fVxuICAgICAgICByZXN1bHRzPXtwcm9wcy5zZWFyY2gubm9kZXN9XG4gICAgICAgIGlzTG9hZGluZz17ZmFsc2V9XG4gICAgICAgIHsuLi50aGlzLmNvbnRyb2xsZXJQcm9wcygpfVxuICAgICAgLz5cbiAgICApO1xuICB9XG5cbiAgY29tcG9uZW50V2lsbFVubW91bnQoKSB7XG4gICAgdGhpcy5zdWIuZGlzcG9zZSgpO1xuICB9XG5cbiAgY29udHJvbGxlclByb3BzKCkge1xuICAgIHJldHVybiB7XG4gICAgICB0aXRsZTogdGhpcy5wcm9wcy5zZWFyY2guZ2V0TmFtZSgpLFxuXG4gICAgICBvbk9wZW5Jc3N1ZWlzaDogdGhpcy5wcm9wcy5vbk9wZW5Jc3N1ZWlzaCxcbiAgICAgIG9uT3Blbk1vcmU6ICgpID0+IHRoaXMucHJvcHMub25PcGVuU2VhcmNoKHRoaXMucHJvcHMuc2VhcmNoKSxcbiAgICB9O1xuICB9XG59XG4iXX0=