'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class SimpleTooltip extends _react2.default.Component {

  componentDidMount() {
    this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
  }

  componentWillUnmount() {
    this.disposable.dispose();
  }

  componentDidUpdate(prevProps) {
    if (prevProps.title !== this.props.title) {
      this.disposable.dispose();
      this.disposable = this.props.tooltips.add(_reactDom2.default.findDOMNode(this.child), { title: () => this.props.title });
    }
  }

  render() {
    const child = _react2.default.Children.only(this.props.children);
    return _react2.default.cloneElement(child, { ref: e => {
        this.child = e;
      } });
  }
}
exports.default = SimpleTooltip;
SimpleTooltip.propTypes = {
  tooltips: _propTypes2.default.object.isRequired,
  children: _propTypes2.default.node.isRequired,
  title: _propTypes2.default.string.isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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