'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _eventKit = require('event-kit');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _helpers = require('../helpers');

var _propTypes3 = require('../prop-types');

var _atomTextEditor = require('./atom-text-editor');

var _marker = require('./marker');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const decorationPropTypes = {
  type: _propTypes2.default.oneOf(['line', 'line-number', 'highlight', 'overlay', 'gutter', 'block']).isRequired,
  className: _propTypes2.default.string,
  style: _propTypes2.default.string,
  onlyHead: _propTypes2.default.bool,
  onlyEmpty: _propTypes2.default.bool,
  onlyNonEmpty: _propTypes2.default.bool,
  omitEmptyLastRow: _propTypes2.default.bool,
  position: _propTypes2.default.oneOf(['head', 'tail', 'before', 'after']),
  avoidOverflow: _propTypes2.default.bool,
  gutterName: _propTypes2.default.string
};

class BareDecoration extends _react2.default.Component {

  constructor(props, context) {
    super(props, context);

    this.observeParents = () => {
      this.decorationHolder.map(decoration => decoration.destroy());

      const editorValid = this.props.editorHolder.map(editor => !editor.isDestroyed()).getOr(false);
      const markableValid = this.props.decorableHolder.map(decorable => !decorable.isDestroyed()).getOr(false);

      // Ensure the Marker or MarkerLayer corresponds to the context's TextEditor
      const markableMatches = this.props.decorableHolder.map(decorable => this.props.editorHolder.map(editor => {
        const layer = decorable.layer || decorable;
        const displayLayer = editor.getMarkerLayer(layer.id);
        if (!displayLayer) {
          return false;
        }
        if (displayLayer !== layer && displayLayer.bufferMarkerLayer !== layer) {
          return false;
        }
        return true;
      }).getOr(false)).getOr(false);

      if (!editorValid || !markableValid || !markableMatches) {
        return;
      }

      this.createDecoration();
    };

    this.decorationHolder = new _refHolder2.default();
    this.editorSub = new _eventKit.Disposable();
    this.decorableSub = new _eventKit.Disposable();

    this.domNode = null;
    this.item = null;
    if (['gutter', 'overlay', 'block'].includes(this.props.type)) {
      this.domNode = document.createElement('div');
      this.domNode.className = (0, _classnames2.default)('react-atom-decoration', this.props.className);
    }
  }

  usesItem() {
    return this.domNode !== null;
  }

  componentDidMount() {
    this.editorSub = this.props.editorHolder.observe(this.observeParents);
    this.decorableSub = this.props.decorableHolder.observe(this.observeParents);
  }

  componentDidUpdate(prevProps) {
    if (this.props.editorHolder !== prevProps.editorHolder) {
      this.editorSub.dispose();
      this.editorSub = this.state.editorHolder.observe(this.observeParents);
    }

    if (this.props.decorableHolder !== prevProps.decorableHolder) {
      this.decorableSub.dispose();
      this.decorableSub = this.state.decorableHolder.observe(this.observeParents);
    }

    if (Object.keys(decorationPropTypes).some(key => this.props[key] !== prevProps[key])) {
      const opts = this.getDecorationOpts(this.props);
      this.decorationHolder.map(decoration => decoration.setProperties(opts));
    }
  }

  render() {
    if (this.usesItem()) {
      return _reactDom2.default.createPortal(this.props.children, this.domNode);
    } else {
      return null;
    }
  }

  createDecoration() {
    if (!this.item) {
      this.item = (0, _helpers.createItem)(this.domNode, this.props.itemHolder);
    }

    const opts = this.getDecorationOpts(this.props);
    const editor = this.props.editorHolder.get();
    const decorable = this.props.decorableHolder.get();

    this.decorationHolder.setter(editor[this.props.decorateMethod](decorable, opts));
  }

  componentWillUnmount() {
    this.decorationHolder.map(decoration => decoration.destroy());
    this.editorSub.dispose();
    this.decorableSub.dispose();
  }

  getDecorationOpts(props) {
    return _extends({}, (0, _helpers.extractProps)(props, decorationPropTypes, { className: 'class' }), {
      item: this.item
    });
  }
}

BareDecoration.propTypes = _extends({
  editorHolder: _propTypes3.RefHolderPropType.isRequired,
  decorableHolder: _propTypes3.RefHolderPropType.isRequired,
  decorateMethod: _propTypes2.default.oneOf(['decorateMarker', 'decorateMarkerLayer']),
  itemHolder: _propTypes3.RefHolderPropType,
  children: _propTypes2.default.node
}, decorationPropTypes);
BareDecoration.defaultProps = {
  decorateMethod: 'decorateMarker'
};
class Decoration extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.state = {
      editorHolder: _refHolder2.default.on(this.props.editor),
      decorableHolder: _refHolder2.default.on(this.props.decorable)
    };
  }

  static getDerivedStateFromProps(props, state) {
    const editorChanged = state.editorHolder.map(editor => editor !== props.editor).getOr(props.editor !== undefined);
    const decorableChanged = state.decorableHolder.map(decorable => decorable !== props.decorable).getOr(props.decorable !== undefined);

    if (!editorChanged && !decorableChanged) {
      return null;
    }

    const nextState = {};
    if (editorChanged) {
      nextState.editorHolder = _refHolder2.default.on(props.editor);
    }
    if (decorableChanged) {
      nextState.decorableHolder = _refHolder2.default.on(props.decorable);
    }
    return nextState;
  }

  render() {
    if (!this.state.editorHolder.isEmpty() && !this.state.decorableHolder.isEmpty()) {
      return _react2.default.createElement(BareDecoration, _extends({}, this.props, {
        editorHolder: this.state.editorHolder,
        decorableHolder: this.state.decorableHolder
      }));
    }

    return _react2.default.createElement(
      _atomTextEditor.TextEditorContext.Consumer,
      null,
      editorHolder => _react2.default.createElement(
        _marker.DecorableContext.Consumer,
        null,
        ({ holder, decorateMethod }) => _react2.default.createElement(BareDecoration, _extends({
          editorHolder: editorHolder,
          decorableHolder: holder,
          decorateMethod: decorateMethod
        }, this.props))
      )
    );
  }
}
exports.default = Decoration;
Decoration.propTypes = {
  editor: _propTypes2.default.object,
  decorable: _propTypes2.default.object
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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