'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextEditorContext = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _atom = require('atom');

var _eventKit = require('event-kit');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _propTypes3 = require('../prop-types');

var _helpers = require('../helpers');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const editorUpdateProps = {
  mini: _propTypes2.default.bool,
  readOnly: _propTypes2.default.bool,
  placeholderText: _propTypes2.default.string,
  lineNumberGutterVisible: _propTypes2.default.bool,
  autoHeight: _propTypes2.default.bool,
  autoWidth: _propTypes2.default.bool,
  softWrapped: _propTypes2.default.bool
};

const editorCreationProps = _extends({
  buffer: _propTypes2.default.object }, editorUpdateProps);

const TextEditorContext = exports.TextEditorContext = _react2.default.createContext();

class AtomTextEditor extends _react2.default.Component {

  constructor(props) {
    super(props);

    this.observeSelections = selection => {
      const selectionSubs = new _eventKit.CompositeDisposable(selection.onDidChangeRange(this.props.didChangeSelectionRange), selection.onDidDestroy(() => {
        selectionSubs.dispose();
        this.subs.remove(selectionSubs);
        this.props.didDestroySelection(selection);
      }));
      this.subs.add(selectionSubs);
      this.props.didAddSelection(selection);
    };

    this.subs = new _eventKit.CompositeDisposable();

    this.refParent = new _refHolder2.default();
    this.refElement = new _refHolder2.default();
    this.refModel = null;
  }

  render() {
    return _react2.default.createElement(
      _react.Fragment,
      null,
      _react2.default.createElement('div', { className: 'github-AtomTextEditor-container', ref: this.refParent.setter }),
      _react2.default.createElement(
        TextEditorContext.Provider,
        { value: this.getRefModel() },
        this.props.children
      )
    );
  }

  componentDidMount() {
    const modelProps = (0, _helpers.extractProps)(this.props, editorCreationProps);

    this.refParent.map(element => {
      const editor = new _atom.TextEditor(modelProps);
      element.appendChild(editor.getElement());
      this.getRefModel().setter(editor);
      this.refElement.setter(editor.getElement());

      this.subs.add(editor.onDidChangeCursorPosition(this.props.didChangeCursorPosition), editor.observeSelections(this.observeSelections));

      return null;
    });
  }

  componentDidUpdate(prevProps) {
    const modelProps = (0, _helpers.extractProps)(this.props, editorUpdateProps);
    this.getRefModel().map(editor => editor.update(modelProps));
  }

  componentWillUnmount() {
    this.getRefModel().map(editor => editor.destroy());
    this.subs.dispose();
  }

  contains(element) {
    return this.refElement.map(e => e.contains(element)).getOr(false);
  }

  focus() {
    this.refElement.map(e => e.focus());
  }

  getRefModel() {
    if (this.props.refModel) {
      return this.props.refModel;
    }

    if (!this.refModel) {
      this.refModel = new _refHolder2.default();
    }

    return this.refModel;
  }

  getModel() {
    return this.getRefModel().getOr(undefined);
  }
}
exports.default = AtomTextEditor;
AtomTextEditor.propTypes = _extends({}, editorCreationProps, {

  workspace: _propTypes2.default.object.isRequired,

  didChangeCursorPosition: _propTypes2.default.func,
  didAddSelection: _propTypes2.default.func,
  didChangeSelectionRange: _propTypes2.default.func,
  didDestroySelection: _propTypes2.default.func,
  observeSelections: _propTypes2.default.func,

  refModel: _propTypes3.RefHolderPropType,

  children: _propTypes2.default.node
});
AtomTextEditor.defaultProps = {
  didChangeCursorPosition: () => {},
  didAddSelection: () => {},
  didChangeSelectionRange: () => {},
  didDestroySelection: () => {}
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImF0b20tdGV4dC1lZGl0b3IuanMiXSwibmFtZXMiOlsiZWRpdG9yVXBkYXRlUHJvcHMiLCJtaW5pIiwiUHJvcFR5cGVzIiwiYm9vbCIsInJlYWRPbmx5IiwicGxhY2Vob2xkZXJUZXh0Iiwic3RyaW5nIiwibGluZU51bWJlckd1dHRlclZpc2libGUiLCJhdXRvSGVpZ2h0IiwiYXV0b1dpZHRoIiwic29mdFdyYXBwZWQiLCJlZGl0b3JDcmVhdGlvblByb3BzIiwiYnVmZmVyIiwib2JqZWN0IiwiVGV4dEVkaXRvckNvbnRleHQiLCJSZWFjdCIsImNyZWF0ZUNvbnRleHQiLCJBdG9tVGV4dEVkaXRvciIsIkNvbXBvbmVudCIsImNvbnN0cnVjdG9yIiwicHJvcHMiLCJvYnNlcnZlU2VsZWN0aW9ucyIsInNlbGVjdGlvbiIsInNlbGVjdGlvblN1YnMiLCJDb21wb3NpdGVEaXNwb3NhYmxlIiwib25EaWRDaGFuZ2VSYW5nZSIsImRpZENoYW5nZVNlbGVjdGlvblJhbmdlIiwib25EaWREZXN0cm95IiwiZGlzcG9zZSIsInN1YnMiLCJyZW1vdmUiLCJkaWREZXN0cm95U2VsZWN0aW9uIiwiYWRkIiwiZGlkQWRkU2VsZWN0aW9uIiwicmVmUGFyZW50IiwiUmVmSG9sZGVyIiwicmVmRWxlbWVudCIsInJlZk1vZGVsIiwicmVuZGVyIiwic2V0dGVyIiwiZ2V0UmVmTW9kZWwiLCJjaGlsZHJlbiIsImNvbXBvbmVudERpZE1vdW50IiwibW9kZWxQcm9wcyIsIm1hcCIsImVsZW1lbnQiLCJlZGl0b3IiLCJUZXh0RWRpdG9yIiwiYXBwZW5kQ2hpbGQiLCJnZXRFbGVtZW50Iiwib25EaWRDaGFuZ2VDdXJzb3JQb3NpdGlvbiIsImRpZENoYW5nZUN1cnNvclBvc2l0aW9uIiwiY29tcG9uZW50RGlkVXBkYXRlIiwicHJldlByb3BzIiwidXBkYXRlIiwiY29tcG9uZW50V2lsbFVubW91bnQiLCJkZXN0cm95IiwiY29udGFpbnMiLCJlIiwiZ2V0T3IiLCJmb2N1cyIsImdldE1vZGVsIiwidW5kZWZpbmVkIiwicHJvcFR5cGVzIiwid29ya3NwYWNlIiwiaXNSZXF1aXJlZCIsImZ1bmMiLCJSZWZIb2xkZXJQcm9wVHlwZSIsIm5vZGUiLCJkZWZhdWx0UHJvcHMiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7OztBQUFBOzs7O0FBQ0E7Ozs7QUFDQTs7QUFDQTs7QUFFQTs7OztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsb0JBQW9CO0FBQ3hCQyxRQUFNQyxvQkFBVUMsSUFEUTtBQUV4QkMsWUFBVUYsb0JBQVVDLElBRkk7QUFHeEJFLG1CQUFpQkgsb0JBQVVJLE1BSEg7QUFJeEJDLDJCQUF5Qkwsb0JBQVVDLElBSlg7QUFLeEJLLGNBQVlOLG9CQUFVQyxJQUxFO0FBTXhCTSxhQUFXUCxvQkFBVUMsSUFORztBQU94Qk8sZUFBYVIsb0JBQVVDO0FBUEMsQ0FBMUI7O0FBVUEsTUFBTVE7QUFDSkMsVUFBUVYsb0JBQVVXLE1BRGQsSUFFRGIsaUJBRkMsQ0FBTjs7QUFLTyxNQUFNYyxnREFBb0JDLGdCQUFNQyxhQUFOLEVBQTFCOztBQUVRLE1BQU1DLGNBQU4sU0FBNkJGLGdCQUFNRyxTQUFuQyxDQUE2Qzs7QUF3QjFEQyxjQUFZQyxLQUFaLEVBQW1CO0FBQ2pCLFVBQU1BLEtBQU47O0FBRGlCLFNBaURuQkMsaUJBakRtQixHQWlEQ0MsYUFBYTtBQUMvQixZQUFNQyxnQkFBZ0IsSUFBSUMsNkJBQUosQ0FDcEJGLFVBQVVHLGdCQUFWLENBQTJCLEtBQUtMLEtBQUwsQ0FBV00sdUJBQXRDLENBRG9CLEVBRXBCSixVQUFVSyxZQUFWLENBQXVCLE1BQU07QUFDM0JKLHNCQUFjSyxPQUFkO0FBQ0EsYUFBS0MsSUFBTCxDQUFVQyxNQUFWLENBQWlCUCxhQUFqQjtBQUNBLGFBQUtILEtBQUwsQ0FBV1csbUJBQVgsQ0FBK0JULFNBQS9CO0FBQ0QsT0FKRCxDQUZvQixDQUF0QjtBQVFBLFdBQUtPLElBQUwsQ0FBVUcsR0FBVixDQUFjVCxhQUFkO0FBQ0EsV0FBS0gsS0FBTCxDQUFXYSxlQUFYLENBQTJCWCxTQUEzQjtBQUNELEtBNURrQjs7QUFHakIsU0FBS08sSUFBTCxHQUFZLElBQUlMLDZCQUFKLEVBQVo7O0FBRUEsU0FBS1UsU0FBTCxHQUFpQixJQUFJQyxtQkFBSixFQUFqQjtBQUNBLFNBQUtDLFVBQUwsR0FBa0IsSUFBSUQsbUJBQUosRUFBbEI7QUFDQSxTQUFLRSxRQUFMLEdBQWdCLElBQWhCO0FBQ0Q7O0FBRURDLFdBQVM7QUFDUCxXQUNFO0FBQUMscUJBQUQ7QUFBQTtBQUNFLDZDQUFLLFdBQVUsaUNBQWYsRUFBaUQsS0FBSyxLQUFLSixTQUFMLENBQWVLLE1BQXJFLEdBREY7QUFFRTtBQUFDLHlCQUFELENBQW1CLFFBQW5CO0FBQUEsVUFBNEIsT0FBTyxLQUFLQyxXQUFMLEVBQW5DO0FBQ0csYUFBS3BCLEtBQUwsQ0FBV3FCO0FBRGQ7QUFGRixLQURGO0FBUUQ7O0FBRURDLHNCQUFvQjtBQUNsQixVQUFNQyxhQUFhLDJCQUFhLEtBQUt2QixLQUFsQixFQUF5QlQsbUJBQXpCLENBQW5COztBQUVBLFNBQUt1QixTQUFMLENBQWVVLEdBQWYsQ0FBbUJDLFdBQVc7QUFDNUIsWUFBTUMsU0FBUyxJQUFJQyxnQkFBSixDQUFlSixVQUFmLENBQWY7QUFDQUUsY0FBUUcsV0FBUixDQUFvQkYsT0FBT0csVUFBUCxFQUFwQjtBQUNBLFdBQUtULFdBQUwsR0FBbUJELE1BQW5CLENBQTBCTyxNQUExQjtBQUNBLFdBQUtWLFVBQUwsQ0FBZ0JHLE1BQWhCLENBQXVCTyxPQUFPRyxVQUFQLEVBQXZCOztBQUVBLFdBQUtwQixJQUFMLENBQVVHLEdBQVYsQ0FDRWMsT0FBT0kseUJBQVAsQ0FBaUMsS0FBSzlCLEtBQUwsQ0FBVytCLHVCQUE1QyxDQURGLEVBRUVMLE9BQU96QixpQkFBUCxDQUF5QixLQUFLQSxpQkFBOUIsQ0FGRjs7QUFLQSxhQUFPLElBQVA7QUFDRCxLQVpEO0FBYUQ7O0FBRUQrQixxQkFBbUJDLFNBQW5CLEVBQThCO0FBQzVCLFVBQU1WLGFBQWEsMkJBQWEsS0FBS3ZCLEtBQWxCLEVBQXlCcEIsaUJBQXpCLENBQW5CO0FBQ0EsU0FBS3dDLFdBQUwsR0FBbUJJLEdBQW5CLENBQXVCRSxVQUFVQSxPQUFPUSxNQUFQLENBQWNYLFVBQWQsQ0FBakM7QUFDRDs7QUFFRFkseUJBQXVCO0FBQ3JCLFNBQUtmLFdBQUwsR0FBbUJJLEdBQW5CLENBQXVCRSxVQUFVQSxPQUFPVSxPQUFQLEVBQWpDO0FBQ0EsU0FBSzNCLElBQUwsQ0FBVUQsT0FBVjtBQUNEOztBQWVENkIsV0FBU1osT0FBVCxFQUFrQjtBQUNoQixXQUFPLEtBQUtULFVBQUwsQ0FBZ0JRLEdBQWhCLENBQW9CYyxLQUFLQSxFQUFFRCxRQUFGLENBQVdaLE9BQVgsQ0FBekIsRUFBOENjLEtBQTlDLENBQW9ELEtBQXBELENBQVA7QUFDRDs7QUFFREMsVUFBUTtBQUNOLFNBQUt4QixVQUFMLENBQWdCUSxHQUFoQixDQUFvQmMsS0FBS0EsRUFBRUUsS0FBRixFQUF6QjtBQUNEOztBQUVEcEIsZ0JBQWM7QUFDWixRQUFJLEtBQUtwQixLQUFMLENBQVdpQixRQUFmLEVBQXlCO0FBQ3ZCLGFBQU8sS0FBS2pCLEtBQUwsQ0FBV2lCLFFBQWxCO0FBQ0Q7O0FBRUQsUUFBSSxDQUFDLEtBQUtBLFFBQVYsRUFBb0I7QUFDbEIsV0FBS0EsUUFBTCxHQUFnQixJQUFJRixtQkFBSixFQUFoQjtBQUNEOztBQUVELFdBQU8sS0FBS0UsUUFBWjtBQUNEOztBQUVEd0IsYUFBVztBQUNULFdBQU8sS0FBS3JCLFdBQUwsR0FBbUJtQixLQUFuQixDQUF5QkcsU0FBekIsQ0FBUDtBQUNEO0FBNUd5RDtrQkFBdkM3QyxjO0FBQUFBLGMsQ0FDWjhDLFMsZ0JBQ0ZwRCxtQjs7QUFFSHFELGFBQVc5RCxvQkFBVVcsTUFBVixDQUFpQm9ELFU7O0FBRTVCZCwyQkFBeUJqRCxvQkFBVWdFLEk7QUFDbkNqQyxtQkFBaUIvQixvQkFBVWdFLEk7QUFDM0J4QywyQkFBeUJ4QixvQkFBVWdFLEk7QUFDbkNuQyx1QkFBcUI3QixvQkFBVWdFLEk7QUFDL0I3QyxxQkFBbUJuQixvQkFBVWdFLEk7O0FBRTdCN0IsWUFBVThCLDZCOztBQUVWMUIsWUFBVXZDLG9CQUFVa0U7O0FBZEhuRCxjLENBaUJab0QsWSxHQUFlO0FBQ3BCbEIsMkJBQXlCLE1BQU0sQ0FBRSxDQURiO0FBRXBCbEIsbUJBQWlCLE1BQU0sQ0FBRSxDQUZMO0FBR3BCUCwyQkFBeUIsTUFBTSxDQUFFLENBSGI7QUFJcEJLLHVCQUFxQixNQUFNLENBQUU7QUFKVCxDIiwiZmlsZSI6ImF0b20tdGV4dC1lZGl0b3IuanMiLCJzb3VyY2VSb290IjoiL2J1aWxkL2F0b20vc3JjL2F0b20tMS4zNS4xL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1Yi9saWIvYXRvbSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBSZWFjdCwge0ZyYWdtZW50fSBmcm9tICdyZWFjdCc7XG5pbXBvcnQgUHJvcFR5cGVzIGZyb20gJ3Byb3AtdHlwZXMnO1xuaW1wb3J0IHtUZXh0RWRpdG9yfSBmcm9tICdhdG9tJztcbmltcG9ydCB7Q29tcG9zaXRlRGlzcG9zYWJsZX0gZnJvbSAnZXZlbnQta2l0JztcblxuaW1wb3J0IFJlZkhvbGRlciBmcm9tICcuLi9tb2RlbHMvcmVmLWhvbGRlcic7XG5pbXBvcnQge1JlZkhvbGRlclByb3BUeXBlfSBmcm9tICcuLi9wcm9wLXR5cGVzJztcbmltcG9ydCB7ZXh0cmFjdFByb3BzfSBmcm9tICcuLi9oZWxwZXJzJztcblxuY29uc3QgZWRpdG9yVXBkYXRlUHJvcHMgPSB7XG4gIG1pbmk6IFByb3BUeXBlcy5ib29sLFxuICByZWFkT25seTogUHJvcFR5cGVzLmJvb2wsXG4gIHBsYWNlaG9sZGVyVGV4dDogUHJvcFR5cGVzLnN0cmluZyxcbiAgbGluZU51bWJlckd1dHRlclZpc2libGU6IFByb3BUeXBlcy5ib29sLFxuICBhdXRvSGVpZ2h0OiBQcm9wVHlwZXMuYm9vbCxcbiAgYXV0b1dpZHRoOiBQcm9wVHlwZXMuYm9vbCxcbiAgc29mdFdyYXBwZWQ6IFByb3BUeXBlcy5ib29sLFxufTtcblxuY29uc3QgZWRpdG9yQ3JlYXRpb25Qcm9wcyA9IHtcbiAgYnVmZmVyOiBQcm9wVHlwZXMub2JqZWN0LCAvLyBGSVhNRSBtYWtlIHByb3B0eXBlIG1vcmUgc3BlY2lmaWNcbiAgLi4uZWRpdG9yVXBkYXRlUHJvcHMsXG59O1xuXG5leHBvcnQgY29uc3QgVGV4dEVkaXRvckNvbnRleHQgPSBSZWFjdC5jcmVhdGVDb250ZXh0KCk7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEF0b21UZXh0RWRpdG9yIGV4dGVuZHMgUmVhY3QuQ29tcG9uZW50IHtcbiAgc3RhdGljIHByb3BUeXBlcyA9IHtcbiAgICAuLi5lZGl0b3JDcmVhdGlvblByb3BzLFxuXG4gICAgd29ya3NwYWNlOiBQcm9wVHlwZXMub2JqZWN0LmlzUmVxdWlyZWQsXG5cbiAgICBkaWRDaGFuZ2VDdXJzb3JQb3NpdGlvbjogUHJvcFR5cGVzLmZ1bmMsXG4gICAgZGlkQWRkU2VsZWN0aW9uOiBQcm9wVHlwZXMuZnVuYyxcbiAgICBkaWRDaGFuZ2VTZWxlY3Rpb25SYW5nZTogUHJvcFR5cGVzLmZ1bmMsXG4gICAgZGlkRGVzdHJveVNlbGVjdGlvbjogUHJvcFR5cGVzLmZ1bmMsXG4gICAgb2JzZXJ2ZVNlbGVjdGlvbnM6IFByb3BUeXBlcy5mdW5jLFxuXG4gICAgcmVmTW9kZWw6IFJlZkhvbGRlclByb3BUeXBlLFxuXG4gICAgY2hpbGRyZW46IFByb3BUeXBlcy5ub2RlLFxuICB9XG5cbiAgc3RhdGljIGRlZmF1bHRQcm9wcyA9IHtcbiAgICBkaWRDaGFuZ2VDdXJzb3JQb3NpdGlvbjogKCkgPT4ge30sXG4gICAgZGlkQWRkU2VsZWN0aW9uOiAoKSA9PiB7fSxcbiAgICBkaWRDaGFuZ2VTZWxlY3Rpb25SYW5nZTogKCkgPT4ge30sXG4gICAgZGlkRGVzdHJveVNlbGVjdGlvbjogKCkgPT4ge30sXG4gIH1cblxuICBjb25zdHJ1Y3Rvcihwcm9wcykge1xuICAgIHN1cGVyKHByb3BzKTtcblxuICAgIHRoaXMuc3VicyA9IG5ldyBDb21wb3NpdGVEaXNwb3NhYmxlKCk7XG5cbiAgICB0aGlzLnJlZlBhcmVudCA9IG5ldyBSZWZIb2xkZXIoKTtcbiAgICB0aGlzLnJlZkVsZW1lbnQgPSBuZXcgUmVmSG9sZGVyKCk7XG4gICAgdGhpcy5yZWZNb2RlbCA9IG51bGw7XG4gIH1cblxuICByZW5kZXIoKSB7XG4gICAgcmV0dXJuIChcbiAgICAgIDxGcmFnbWVudD5cbiAgICAgICAgPGRpdiBjbGFzc05hbWU9XCJnaXRodWItQXRvbVRleHRFZGl0b3ItY29udGFpbmVyXCIgcmVmPXt0aGlzLnJlZlBhcmVudC5zZXR0ZXJ9IC8+XG4gICAgICAgIDxUZXh0RWRpdG9yQ29udGV4dC5Qcm92aWRlciB2YWx1ZT17dGhpcy5nZXRSZWZNb2RlbCgpfT5cbiAgICAgICAgICB7dGhpcy5wcm9wcy5jaGlsZHJlbn1cbiAgICAgICAgPC9UZXh0RWRpdG9yQ29udGV4dC5Qcm92aWRlcj5cbiAgICAgIDwvRnJhZ21lbnQ+XG4gICAgKTtcbiAgfVxuXG4gIGNvbXBvbmVudERpZE1vdW50KCkge1xuICAgIGNvbnN0IG1vZGVsUHJvcHMgPSBleHRyYWN0UHJvcHModGhpcy5wcm9wcywgZWRpdG9yQ3JlYXRpb25Qcm9wcyk7XG5cbiAgICB0aGlzLnJlZlBhcmVudC5tYXAoZWxlbWVudCA9PiB7XG4gICAgICBjb25zdCBlZGl0b3IgPSBuZXcgVGV4dEVkaXRvcihtb2RlbFByb3BzKTtcbiAgICAgIGVsZW1lbnQuYXBwZW5kQ2hpbGQoZWRpdG9yLmdldEVsZW1lbnQoKSk7XG4gICAgICB0aGlzLmdldFJlZk1vZGVsKCkuc2V0dGVyKGVkaXRvcik7XG4gICAgICB0aGlzLnJlZkVsZW1lbnQuc2V0dGVyKGVkaXRvci5nZXRFbGVtZW50KCkpO1xuXG4gICAgICB0aGlzLnN1YnMuYWRkKFxuICAgICAgICBlZGl0b3Iub25EaWRDaGFuZ2VDdXJzb3JQb3NpdGlvbih0aGlzLnByb3BzLmRpZENoYW5nZUN1cnNvclBvc2l0aW9uKSxcbiAgICAgICAgZWRpdG9yLm9ic2VydmVTZWxlY3Rpb25zKHRoaXMub2JzZXJ2ZVNlbGVjdGlvbnMpLFxuICAgICAgKTtcblxuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfSk7XG4gIH1cblxuICBjb21wb25lbnREaWRVcGRhdGUocHJldlByb3BzKSB7XG4gICAgY29uc3QgbW9kZWxQcm9wcyA9IGV4dHJhY3RQcm9wcyh0aGlzLnByb3BzLCBlZGl0b3JVcGRhdGVQcm9wcyk7XG4gICAgdGhpcy5nZXRSZWZNb2RlbCgpLm1hcChlZGl0b3IgPT4gZWRpdG9yLnVwZGF0ZShtb2RlbFByb3BzKSk7XG4gIH1cblxuICBjb21wb25lbnRXaWxsVW5tb3VudCgpIHtcbiAgICB0aGlzLmdldFJlZk1vZGVsKCkubWFwKGVkaXRvciA9PiBlZGl0b3IuZGVzdHJveSgpKTtcbiAgICB0aGlzLnN1YnMuZGlzcG9zZSgpO1xuICB9XG5cbiAgb2JzZXJ2ZVNlbGVjdGlvbnMgPSBzZWxlY3Rpb24gPT4ge1xuICAgIGNvbnN0IHNlbGVjdGlvblN1YnMgPSBuZXcgQ29tcG9zaXRlRGlzcG9zYWJsZShcbiAgICAgIHNlbGVjdGlvbi5vbkRpZENoYW5nZVJhbmdlKHRoaXMucHJvcHMuZGlkQ2hhbmdlU2VsZWN0aW9uUmFuZ2UpLFxuICAgICAgc2VsZWN0aW9uLm9uRGlkRGVzdHJveSgoKSA9PiB7XG4gICAgICAgIHNlbGVjdGlvblN1YnMuZGlzcG9zZSgpO1xuICAgICAgICB0aGlzLnN1YnMucmVtb3ZlKHNlbGVjdGlvblN1YnMpO1xuICAgICAgICB0aGlzLnByb3BzLmRpZERlc3Ryb3lTZWxlY3Rpb24oc2VsZWN0aW9uKTtcbiAgICAgIH0pLFxuICAgICk7XG4gICAgdGhpcy5zdWJzLmFkZChzZWxlY3Rpb25TdWJzKTtcbiAgICB0aGlzLnByb3BzLmRpZEFkZFNlbGVjdGlvbihzZWxlY3Rpb24pO1xuICB9XG5cbiAgY29udGFpbnMoZWxlbWVudCkge1xuICAgIHJldHVybiB0aGlzLnJlZkVsZW1lbnQubWFwKGUgPT4gZS5jb250YWlucyhlbGVtZW50KSkuZ2V0T3IoZmFsc2UpO1xuICB9XG5cbiAgZm9jdXMoKSB7XG4gICAgdGhpcy5yZWZFbGVtZW50Lm1hcChlID0+IGUuZm9jdXMoKSk7XG4gIH1cblxuICBnZXRSZWZNb2RlbCgpIHtcbiAgICBpZiAodGhpcy5wcm9wcy5yZWZNb2RlbCkge1xuICAgICAgcmV0dXJuIHRoaXMucHJvcHMucmVmTW9kZWw7XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLnJlZk1vZGVsKSB7XG4gICAgICB0aGlzLnJlZk1vZGVsID0gbmV3IFJlZkhvbGRlcigpO1xuICAgIH1cblxuICAgIHJldHVybiB0aGlzLnJlZk1vZGVsO1xuICB9XG5cbiAgZ2V0TW9kZWwoKSB7XG4gICAgcmV0dXJuIHRoaXMuZ2V0UmVmTW9kZWwoKS5nZXRPcih1bmRlZmluZWQpO1xuICB9XG59XG4iXX0=