(function() {
  var Emitter, FindOptions, Params, _, escapeRegExp;

  _ = require('underscore-plus');

  Emitter = require('atom').Emitter;

  Params = ['findPattern', 'replacePattern', 'pathsPattern', 'useRegex', 'wholeWord', 'caseSensitive', 'inCurrentSelection', 'leadingContextLineCount', 'trailingContextLineCount'];

  module.exports = FindOptions = (function() {
    function FindOptions(state) {
      var ref, ref1, ref10, ref11, ref12, ref13, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9;
      if (state == null) {
        state = {};
      }
      this.emitter = new Emitter;
      this.findPattern = '';
      this.replacePattern = (ref = state.replacePattern) != null ? ref : '';
      this.pathsPattern = (ref1 = state.pathsPattern) != null ? ref1 : '';
      this.useRegex = (ref2 = (ref3 = state.useRegex) != null ? ref3 : atom.config.get('find-and-replace.useRegex')) != null ? ref2 : false;
      this.caseSensitive = (ref4 = (ref5 = state.caseSensitive) != null ? ref5 : atom.config.get('find-and-replace.caseSensitive')) != null ? ref4 : false;
      this.wholeWord = (ref6 = (ref7 = state.wholeWord) != null ? ref7 : atom.config.get('find-and-replace.wholeWord')) != null ? ref6 : false;
      this.inCurrentSelection = (ref8 = (ref9 = state.inCurrentSelection) != null ? ref9 : atom.config.get('find-and-replace.inCurrentSelection')) != null ? ref8 : false;
      this.leadingContextLineCount = (ref10 = (ref11 = state.leadingContextLineCount) != null ? ref11 : atom.config.get('find-and-replace.leadingContextLineCount')) != null ? ref10 : 0;
      this.trailingContextLineCount = (ref12 = (ref13 = state.trailingContextLineCount) != null ? ref13 : atom.config.get('find-and-replace.trailingContextLineCount')) != null ? ref12 : 0;
    }

    FindOptions.prototype.onDidChange = function(callback) {
      return this.emitter.on('did-change', callback);
    };

    FindOptions.prototype.onDidChangeReplacePattern = function(callback) {
      return this.emitter.on('did-change-replacePattern', callback);
    };

    FindOptions.prototype.serialize = function() {
      var j, len, param, result;
      result = {};
      for (j = 0, len = Params.length; j < len; j++) {
        param = Params[j];
        result[param] = this[param];
      }
      return result;
    };

    FindOptions.prototype.set = function(newParams) {
      var changedParams, j, key, len, param, val;
      if (newParams == null) {
        newParams = {};
      }
      changedParams = {};
      for (j = 0, len = Params.length; j < len; j++) {
        key = Params[j];
        if ((newParams[key] != null) && newParams[key] !== this[key]) {
          if (changedParams == null) {
            changedParams = {};
          }
          this[key] = changedParams[key] = newParams[key];
        }
      }
      if (Object.keys(changedParams).length) {
        for (param in changedParams) {
          val = changedParams[param];
          this.emitter.emit("did-change-" + param);
        }
        this.emitter.emit('did-change', changedParams);
      }
      return changedParams;
    };

    FindOptions.prototype.getFindPatternRegex = function(forceUnicode) {
      var expression, flags, i, j, ref;
      if (forceUnicode == null) {
        forceUnicode = false;
      }
      for (i = j = 0, ref = this.findPattern.length; 0 <= ref ? j <= ref : j >= ref; i = 0 <= ref ? ++j : --j) {
        if (this.findPattern.charCodeAt(i) > 128) {
          forceUnicode = true;
          break;
        }
      }
      flags = 'gm';
      if (!this.caseSensitive) {
        flags += 'i';
      }
      if (forceUnicode) {
        flags += 'u';
      }
      if (this.useRegex) {
        expression = this.findPattern;
      } else {
        expression = escapeRegExp(this.findPattern);
      }
      if (this.wholeWord) {
        expression = "\\b" + expression + "\\b";
      }
      return new RegExp(expression, flags);
    };

    return FindOptions;

  })();

  escapeRegExp = function(string) {
    return string.replace(/[\/\\^$*+?.()|[\]{}]/g, '\\$&');
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
