Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _grim = require('grim');

var _grim2 = _interopRequireDefault(_grim);

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _shell = require('shell');

var _shell2 = _interopRequireDefault(_shell);

var DeprecationCopView = (function () {
  function DeprecationCopView(_ref) {
    var _this = this;

    var uri = _ref.uri;

    _classCallCheck(this, DeprecationCopView);

    this.uri = uri;
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(_grim2['default'].on('updated', function () {
      _etch2['default'].update(_this);
    }));
    // TODO: Remove conditional when the new StyleManager deprecation APIs reach stable.
    if (atom.styles.onDidUpdateDeprecations) {
      this.subscriptions.add(atom.styles.onDidUpdateDeprecations(function () {
        _etch2['default'].update(_this);
      }));
    }
    _etch2['default'].initialize(this);
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(DeprecationCopView, [{
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI(),
        version: 1
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        { className: 'deprecation-cop pane-item native-key-bindings', tabIndex: '-1' },
        _etch2['default'].dom(
          'div',
          { className: 'panel' },
          _etch2['default'].dom(
            'div',
            { className: 'padded deprecation-overview' },
            _etch2['default'].dom(
              'div',
              { className: 'pull-right btn-group' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn btn-primary check-for-update',
                  onclick: function (event) {
                    event.preventDefault();
                    _this2.checkForUpdates();
                  } },
                'Check for Updates'
              )
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated calls'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'list-tree has-collapsable-children' },
            this.renderDeprecatedCalls()
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated selectors'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'selectors list-tree has-collapsable-children' },
            this.renderDeprecatedSelectors()
          )
        )
      );
    }
  }, {
    key: 'renderDeprecatedCalls',
    value: function renderDeprecatedCalls() {
      var _this3 = this;

      var deprecationsByPackageName = this.getDeprecatedCallsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated calls'
        );
      } else {
        return packageNames.sort().map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              { className: 'deprecation-info list-item', onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                } },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName || 'atom core'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' (' + _underscorePlus2['default'].pluralize(deprecationsByPackageName[packageName].length, 'deprecation') + ')'
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this3.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref2) {
                var deprecation = _ref2.deprecation;
                var stack = _ref2.stack;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item deprecation-detail' },
                  _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                  _etch2['default'].dom('div', { className: 'list-item deprecation-message', innerHTML: (0, _marked2['default'])(deprecation.getMessage()) }),
                  _this3.renderIssueURLIfNeeded(packageName, deprecation, _this3.buildIssueURL(packageName, deprecation, stack)),
                  _etch2['default'].dom(
                    'div',
                    { className: 'stack-trace' },
                    stack.map(function (_ref3) {
                      var functionName = _ref3.functionName;
                      var location = _ref3.location;
                      return _etch2['default'].dom(
                        'div',
                        { className: 'stack-line' },
                        _etch2['default'].dom(
                          'span',
                          null,
                          functionName
                        ),
                        _etch2['default'].dom(
                          'span',
                          null,
                          ' - '
                        ),
                        _etch2['default'].dom(
                          'a',
                          {
                            className: 'stack-line-location',
                            href: location,
                            onclick: function (event) {
                              event.preventDefault();
                              _this3.openLocation(location);
                            } },
                          location
                        )
                      );
                    })
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderDeprecatedSelectors',
    value: function renderDeprecatedSelectors() {
      var _this4 = this;

      var deprecationsByPackageName = this.getDeprecatedSelectorsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated selectors'
        );
      } else {
        return packageNames.map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              { className: 'deprecation-info list-item', onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                } },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this4.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref4) {
                var packagePath = _ref4.packagePath;
                var sourcePath = _ref4.sourcePath;
                var deprecation = _ref4.deprecation;

                var relativeSourcePath = _path2['default'].relative(packagePath, sourcePath);
                var issueTitle = 'Deprecated selector in `' + relativeSourcePath + '`';
                var issueBody = 'In `' + relativeSourcePath + '`: \n\n' + deprecation.message;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item source-file' },
                  _etch2['default'].dom(
                    'a',
                    {
                      className: 'source-url',
                      href: sourcePath,
                      onclick: function (event) {
                        event.preventDefault();
                        _this4.openLocation(sourcePath);
                      } },
                    relativeSourcePath
                  ),
                  _etch2['default'].dom(
                    'ul',
                    { className: 'list' },
                    _etch2['default'].dom(
                      'li',
                      { className: 'list-item deprecation-detail' },
                      _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                      _etch2['default'].dom('div', { className: 'list-item deprecation-message', innerHTML: (0, _marked2['default'])(deprecation.message) }),
                      _this4.renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody)
                    )
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderPackageActionsIfNeeded',
    value: function renderPackageActionsIfNeeded(packageName) {
      var _this5 = this;

      if (packageName && atom.packages.getLoadedPackage(packageName)) {
        return _etch2['default'].dom(
          'div',
          { className: 'padded' },
          _etch2['default'].dom(
            'div',
            { className: 'btn-group' },
            _etch2['default'].dom(
              'button',
              {
                className: 'btn check-for-update',
                onclick: function (event) {
                  event.preventDefault();
                  _this5.checkForUpdates();
                } },
              'Check for Update'
            ),
            _etch2['default'].dom(
              'button',
              {
                className: 'btn disable-package',
                'data-package-name': packageName,
                onclick: function (event) {
                  event.preventDefault();
                  _this5.disablePackage(packageName);
                } },
              'Disable Package'
            )
          )
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'encodeURI',
    value: (function (_encodeURI) {
      function encodeURI(_x) {
        return _encodeURI.apply(this, arguments);
      }

      encodeURI.toString = function () {
        return _encodeURI.toString();
      };

      return encodeURI;
    })(function (str) {
      return encodeURI(str).replace(/#/g, '%23').replace(/;/g, '%3B').replace(/%20/g, '+');
    })
  }, {
    key: 'renderSelectorIssueURLIfNeeded',
    value: function renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody) {
      var _this6 = this;

      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var _ret = (function () {
          var issueURL = repoURL + '/issues/new?title=' + _this6.encodeURI(issueTitle) + '&body=' + _this6.encodeURI(issueBody);
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this6.openIssueURL(repoURL, issueURL, issueTitle);
                  } },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIssueURLIfNeeded',
    value: function renderIssueURLIfNeeded(packageName, deprecation, issueURL) {
      var _this7 = this;

      if (packageName && issueURL) {
        var _ret2 = (function () {
          var repoURL = _this7.getRepoURL(packageName);
          var issueTitle = deprecation.getOriginName() + ' is deprecated.';
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this7.openIssueURL(repoURL, issueURL, issueTitle);
                  } },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'buildIssueURL',
    value: function buildIssueURL(packageName, deprecation, stack) {
      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var title = deprecation.getOriginName() + ' is deprecated.';
        var stacktrace = stack.map(function (_ref5) {
          var functionName = _ref5.functionName;
          var location = _ref5.location;
          return functionName + ' (' + location + ')';
        }).join("\n");
        var body = deprecation.getMessage() + '\n```\n' + stacktrace + '\n```';
        return repoURL + '/issues/new?title=' + encodeURI(title) + '&body=' + encodeURI(body);
      } else {
        return null;
      }
    }
  }, {
    key: 'openIssueURL',
    value: _asyncToGenerator(function* (repoURL, issueURL, issueTitle) {
      var issue = yield this.findSimilarIssue(repoURL, issueTitle);
      if (issue) {
        _shell2['default'].openExternal(issue.html_url);
      } else if (process.platform === 'win32') {
        // Windows will not launch URLs greater than ~2000 bytes so we need to shrink it
        _shell2['default'].openExternal((yield this.shortenURL(issueURL)) || issueURL);
      } else {
        _shell2['default'].openExternal(issueURL);
      }
    })
  }, {
    key: 'findSimilarIssue',
    value: _asyncToGenerator(function* (repoURL, issueTitle) {
      var url = 'https://api.github.com/search/issues';
      var repo = repoURL.replace(/http(s)?:\/\/(\d+\.)?github.com\//gi, '');
      var query = issueTitle + ' repo:' + repo;
      var response = yield window.fetch(url + '?q=' + encodeURI(query) + '&sort=created', {
        method: 'GET',
        headers: {
          'Accept': 'application/vnd.github.v3+json',
          'Content-Type': 'application/json'
        }
      });

      if (response.ok) {
        var data = yield response.json();
        if (data.items) {
          var issues = {};
          for (var issue of data.items) {
            if (issue.title.includes(issueTitle) && !issues[issue.state]) {
              issues[issue.state] = issue;
            }
          }

          return issues.open || issues.closed;
        }
      }
    })
  }, {
    key: 'shortenURL',
    value: _asyncToGenerator(function* (url) {
      var encodedUrl = encodeURIComponent(url).substr(0, 5000); // is.gd has 5000 char limit
      var incompletePercentEncoding = encodedUrl.indexOf('%', encodedUrl.length - 2);
      if (incompletePercentEncoding >= 0) {
        // Handle an incomplete % encoding cut-off
        encodedUrl = encodedUrl.substr(0, incompletePercentEncoding);
      }

      var result = yield fetch('https://is.gd/create.php?format=simple', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'url=' + encodedUrl
      });

      return result.text();
    })
  }, {
    key: 'getRepoURL',
    value: function getRepoURL(packageName) {
      var loadedPackage = atom.packages.getLoadedPackage(packageName);
      if (loadedPackage && loadedPackage.metadata && loadedPackage.metadata.repository) {
        var url = loadedPackage.metadata.repository.url || loadedPackage.metadata.repository;
        return url.replace(/\.git$/, '');
      } else {
        return null;
      }
    }
  }, {
    key: 'getDeprecatedCallsByPackageName',
    value: function getDeprecatedCallsByPackageName() {
      var deprecatedCalls = _grim2['default'].getDeprecations();
      deprecatedCalls.sort(function (a, b) {
        return b.getCallCount() - a.getCallCount();
      });
      var deprecatedCallsByPackageName = {};
      for (var deprecation of deprecatedCalls) {
        var stacks = deprecation.getStacks();
        stacks.sort(function (a, b) {
          return b.callCount - a.callCount;
        });
        for (var stack of stacks) {
          var packageName = null;
          if (stack.metadata && stack.metadata.packageName) {
            packageName = stack.metadata.packageName;
          } else {
            packageName = (this.getPackageName(stack) || '').toLowerCase();
          }

          deprecatedCallsByPackageName[packageName] = deprecatedCallsByPackageName[packageName] || [];
          deprecatedCallsByPackageName[packageName].push({ deprecation: deprecation, stack: stack });
        }
      }
      return deprecatedCallsByPackageName;
    }
  }, {
    key: 'getDeprecatedSelectorsByPackageName',
    value: function getDeprecatedSelectorsByPackageName() {
      var deprecatedSelectorsByPackageName = {};
      if (atom.styles.getDeprecations) {
        var deprecatedSelectorsBySourcePath = atom.styles.getDeprecations();
        for (var sourcePath of Object.keys(deprecatedSelectorsBySourcePath)) {
          var deprecation = deprecatedSelectorsBySourcePath[sourcePath];
          var components = sourcePath.split(_path2['default'].sep);
          var packagesComponentIndex = components.indexOf('packages');
          var packageName = null;
          var packagePath = null;
          if (packagesComponentIndex === -1) {
            packageName = 'Other'; // could be Atom Core or the personal style sheet
            packagePath = '';
          } else {
            packageName = components[packagesComponentIndex + 1];
            packagePath = components.slice(0, packagesComponentIndex + 1).join(_path2['default'].sep);
          }

          deprecatedSelectorsByPackageName[packageName] = deprecatedSelectorsByPackageName[packageName] || [];
          deprecatedSelectorsByPackageName[packageName].push({ packagePath: packagePath, sourcePath: sourcePath, deprecation: deprecation });
        }
      }

      return deprecatedSelectorsByPackageName;
    }
  }, {
    key: 'getPackageName',
    value: function getPackageName(stack) {
      var packagePaths = this.getPackagePathsByPackageName();
      for (var _ref63 of packagePaths) {
        var _ref62 = _slicedToArray(_ref63, 2);

        var packageName = _ref62[0];
        var packagePath = _ref62[1];

        if (packagePath.includes('.atom/dev/packages') || packagePath.includes('.atom/packages')) {
          packagePaths.set(packageName, _fsPlus2['default'].absolute(packagePath));
        }
      }

      for (var i = 1; i < stack.length; i++) {
        var fileName = stack[i].fileName;

        // Empty when it was run from the dev console
        if (!fileName) {
          return null;
        }

        // Continue to next stack entry if call is in node_modules
        if (fileName.includes(_path2['default'].sep + 'node_modules' + _path2['default'].sep)) {
          continue;
        }

        for (var _ref73 of packagePaths) {
          var _ref72 = _slicedToArray(_ref73, 2);

          var packageName = _ref72[0];
          var packagePath = _ref72[1];

          var relativePath = _path2['default'].relative(packagePath, fileName);
          if (!/^\.\./.test(relativePath)) {
            return packageName;
          }
        }

        if (atom.getUserInitScriptPath() === fileName) {
          return 'Your local ' + _path2['default'].basename(fileName) + ' file';
        }
      }

      return null;
    }
  }, {
    key: 'getPackagePathsByPackageName',
    value: function getPackagePathsByPackageName() {
      if (this.packagePathsByPackageName) {
        return this.packagePathsByPackageName;
      } else {
        this.packagePathsByPackageName = new Map();
        for (var pack of atom.packages.getLoadedPackages()) {
          this.packagePathsByPackageName.set(pack.name, pack.path);
        }
        return this.packagePathsByPackageName;
      }
    }
  }, {
    key: 'checkForUpdates',
    value: function checkForUpdates() {
      atom.workspace.open('atom://config/updates');
    }
  }, {
    key: 'disablePackage',
    value: function disablePackage(packageName) {
      if (packageName) {
        atom.packages.disablePackage(packageName);
      }
    }
  }, {
    key: 'openLocation',
    value: function openLocation(location) {
      var pathToOpen = location.replace('file://', '');
      if (process.platform === 'win32') {
        pathToOpen = pathToOpen.replace(/^\//, '');
      }
      atom.open({ pathsToOpen: [pathToOpen] });
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Deprecation Cop';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'alert';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return DeprecationCopView;
})();

exports['default'] = DeprecationCopView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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