Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/** @babel */

var _atom = require('atom');

var Bookmarks = (function () {
  _createClass(Bookmarks, null, [{
    key: "deserialize",
    value: function deserialize(editor, state) {
      return new Bookmarks(editor, editor.getMarkerLayer(state.markerLayerId));
    }
  }]);

  function Bookmarks(editor, markerLayer) {
    _classCallCheck(this, Bookmarks);

    this.editor = editor;
    this.markerLayer = markerLayer || this.editor.addMarkerLayer({ persistent: true });
    this.decorationLayer = this.editor.decorateMarkerLayer(this.markerLayer, { type: "line-number", "class": "bookmarked" });
    this.disposables = new _atom.CompositeDisposable();
    this.disposables.add(atom.commands.add(atom.views.getView(this.editor), {
      "bookmarks:toggle-bookmark": this.toggleBookmark.bind(this),
      "bookmarks:jump-to-next-bookmark": this.jumpToNextBookmark.bind(this),
      "bookmarks:jump-to-previous-bookmark": this.jumpToPreviousBookmark.bind(this),
      "bookmarks:select-to-next-bookmark": this.selectToNextBookmark.bind(this),
      "bookmarks:select-to-previous-bookmark": this.selectToPreviousBookmark.bind(this),
      "bookmarks:clear-bookmarks": this.clearBookmarks.bind(this)
    }));
    this.disposables.add(this.editor.onDidDestroy(this.destroy.bind(this)));
  }

  _createClass(Bookmarks, [{
    key: "destroy",
    value: function destroy() {
      this.deactivate();
      this.markerLayer.destroy();
    }
  }, {
    key: "deactivate",
    value: function deactivate() {
      this.decorationLayer.destroy();
      this.disposables.dispose();
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return { markerLayerId: this.markerLayer.id };
    }
  }, {
    key: "toggleBookmark",
    value: function toggleBookmark() {
      var _this = this;

      for (var range of this.editor.getSelectedBufferRanges()) {
        var bookmarks = this.markerLayer.findMarkers({ intersectsRowRange: [range.start.row, range.end.row] });
        if (bookmarks && bookmarks.length > 0) {
          for (var bookmark of bookmarks) {
            bookmark.destroy();
          }
        } else {
          (function () {
            var bookmark = _this.markerLayer.markBufferRange(range, { invalidate: "surround", exclusive: true });
            _this.disposables.add(bookmark.onDidChange(function (_ref) {
              var isValid = _ref.isValid;

              if (!isValid) {
                bookmark.destroy();
              }
            }));
          })();
        }
      }
    }
  }, {
    key: "clearBookmarks",
    value: function clearBookmarks() {
      for (var bookmark of this.markerLayer.getMarkers()) {
        bookmark.destroy();
      }
    }
  }, {
    key: "jumpToNextBookmark",
    value: function jumpToNextBookmark() {
      var _this2 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this2.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this2.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          }) || markers[0];
          _this2.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this2.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "jumpToPreviousBookmark",
    value: function jumpToPreviousBookmark() {
      var _this3 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this3.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this3.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          }) || markers[0];
          _this3.editor.setSelectedBufferRange(bookmarkMarker.getBufferRange(), { autoscroll: false });
          _this3.editor.scrollToCursorPosition();
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToNextBookmark",
    value: function selectToNextBookmark() {
      var _this4 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this4.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this4.markerLayer.getMarkers().sort(function (a, b) {
            return a.compare(b);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row > bufferRow;
          });
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this4.editor.setSelectedBufferRange([bookmarkMarker.getHeadBufferPosition(), _this4.editor.getCursorBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }, {
    key: "selectToPreviousBookmark",
    value: function selectToPreviousBookmark() {
      var _this5 = this;

      if (this.markerLayer.getMarkerCount() > 0) {
        (function () {
          var bufferRow = _this5.editor.getLastCursor().getMarker().getStartBufferPosition().row;
          var markers = _this5.markerLayer.getMarkers().sort(function (a, b) {
            return b.compare(a);
          });
          var bookmarkMarker = markers.find(function (marker) {
            return marker.getBufferRange().start.row < bufferRow;
          });
          if (!bookmarkMarker) {
            atom.beep();
          } else {
            _this5.editor.setSelectedBufferRange([_this5.editor.getCursorBufferPosition(), bookmarkMarker.getHeadBufferPosition()], { autoscroll: false });
          }
        })();
      } else {
        atom.beep();
      }
    }
  }]);

  return Bookmarks;
})();

exports["default"] = Bookmarks;
module.exports = exports["default"];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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