/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.i18n;

import cc.arduino.i18n.ExternalProcessOutputParser;
import java.io.PrintStream;
import java.util.Map;
import processing.app.I18n;
import processing.app.debug.MessageConsumer;

public class I18NAwareMessageConsumer
implements MessageConsumer {
    private final PrintStream out;
    private final PrintStream err;
    private final MessageConsumer parent;
    private final ExternalProcessOutputParser parser;

    public I18NAwareMessageConsumer(PrintStream out) {
        this(out, out, null);
    }

    public I18NAwareMessageConsumer(PrintStream out, MessageConsumer parent) {
        this(out, out, parent);
    }

    public I18NAwareMessageConsumer(PrintStream out, PrintStream err) {
        this(out, err, null);
    }

    public I18NAwareMessageConsumer(PrintStream out, PrintStream err, MessageConsumer parent) {
        this.out = out;
        this.err = err;
        this.parent = parent;
        this.parser = new ExternalProcessOutputParser();
    }

    @Override
    public void message(String s) {
        if (s.startsWith("===")) {
            Map<String, Object> parsedMessage = this.parser.parse(s);
            String translatedMessage = I18n.format(I18n.tr((String)parsedMessage.get("msg")), (Object[])parsedMessage.get("args"));
            if (!parsedMessage.containsKey("level") || "".equals(parsedMessage.get("level")) || "info".equals(parsedMessage.get("level"))) {
                this.out.println(translatedMessage);
            } else {
                this.err.println(translatedMessage);
            }
            return;
        }
        if (this.parent != null) {
            this.parent.message(s);
        } else {
            this.out.println(s);
        }
    }
}

