/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.impl.AbstractContextDescriptor;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContext;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.MimeType;

public class ResultSetPresentationDescriptor
extends AbstractContextDescriptor {
    private static final Log log = Log.getLog(ResultSetPresentationDescriptor.class);
    public static final String EXTENSION_ID = "org.jkiss.dbeaver.resultset.presentation";
    private static final String CONTENT_TYPE = "contentType";
    private final String id;
    private final String label;
    private final String description;
    private final AbstractDescriptor.ObjectType implClass;
    private final DBPImage icon;
    private final int order;
    private final IResultSetPresentation.PresentationType presentationType;
    private final List<MimeType> contentTypes = new ArrayList<MimeType>();
    private boolean supportsRecordMode;

    protected ResultSetPresentationDescriptor(IConfigurationElement config) {
        super(config);
        this.id = config.getAttribute("id");
        this.label = config.getAttribute("label");
        this.description = config.getAttribute("description");
        this.implClass = new AbstractDescriptor.ObjectType((AbstractDescriptor)this, config.getAttribute("class"));
        this.icon = this.iconToImage(config.getAttribute("icon"));
        this.order = CommonUtils.toInt((Object)config.getAttribute("order"));
        this.presentationType = IResultSetPresentation.PresentationType.valueOf(config.getAttribute("type").toUpperCase(Locale.ENGLISH));
        this.supportsRecordMode = CommonUtils.toBoolean((Object)config.getAttribute("supportsRecordMode"));
        IConfigurationElement[] iConfigurationElementArray = config.getChildren(CONTENT_TYPE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement typeCfg = iConfigurationElementArray[n2];
            String type = typeCfg.getAttribute("type");
            try {
                MimeType contentType = new MimeType(type);
                this.contentTypes.add(contentType);
            }
            catch (Throwable e) {
                log.warn((Object)("Invalid content type: " + type), e);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getIcon() {
        return this.icon;
    }

    public int getOrder() {
        return this.order;
    }

    public IResultSetPresentation.PresentationType getPresentationType() {
        return this.presentationType;
    }

    public boolean supportedBy(DBCResultSet resultSet, IResultSetContext context) {
        return this.appliesTo((DBPObject)resultSet, context) || this.matchesContentType(context);
    }

    public IResultSetPresentation createInstance() throws DBException {
        return (IResultSetPresentation)this.implClass.createInstance(IResultSetPresentation.class);
    }

    public boolean matches(Class<? extends IResultSetPresentation> type) {
        return this.implClass.matchesType(type);
    }

    private boolean matchesContentType(IResultSetContext context) {
        String documentType = context.getDocumentContentType();
        if (this.contentTypes.isEmpty() || CommonUtils.isEmpty((String)documentType)) {
            return false;
        }
        for (MimeType mimeType : this.contentTypes) {
            try {
                if (!mimeType.match(documentType)) continue;
                return true;
            }
            catch (Throwable e) {
                log.warn((Object)("Bad document content type: " + documentType), e);
            }
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public boolean supportsRecordMode() {
        return this.supportsRecordMode;
    }
}

