/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.command;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.part.DiagramPart;
import org.jkiss.dbeaver.ext.erd.part.EntityPart;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class EntityAddCommand
extends Command {
    protected DiagramPart diagramPart;
    protected List<ERDEntity> entities;
    protected Point location;

    public EntityAddCommand(DiagramPart diagram, List<ERDEntity> entities, Point location) {
        this.diagramPart = diagram;
        this.entities = entities;
        this.location = location;
    }

    public DiagramPart getDiagram() {
        return this.diagramPart;
    }

    public void execute() {
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        Point curLocation = this.location == null ? null : new Point(this.location);
        for (ERDEntity entity : this.entities) {
            DBNNode tableNode;
            DBSObject selectedObject;
            DBNDatabaseNode dsNode;
            if (entity.getObject() == null && entity.getDataSource() != null && (dsNode = NavigatorUtils.getNodeByObject((DBSObject)((selectedObject = DBUtils.getSelectedObject((DBSObject)entity.getDataSource(), (boolean)true)) != null ? selectedObject : entity.getDataSource().getContainer()))) != null && (tableNode = DBWorkbench.getPlatformUI().selectObject((Object)UIUtils.getActiveWorkbenchShell(), "Select a table", (DBNNode)dsNode, null, new Class[]{DBSTable.class}, new Class[]{DBSTable.class}, null)) instanceof DBNDatabaseNode && ((DBNDatabaseNode)tableNode).getObject() instanceof DBSEntity) {
                entity = ERDUtils.makeEntityFromObject((DBRProgressMonitor)monitor, this.diagramPart.getDiagram(), Collections.emptyList(), (DBSEntity)((DBNDatabaseNode)tableNode).getObject(), null);
                entity.addModelRelations((DBRProgressMonitor)monitor, this.diagramPart.getDiagram(), false, false);
            }
            if (entity.getObject() == null) continue;
            this.diagramPart.getDiagram().addEntity(entity, true);
            if (curLocation != null) {
                for (Object diagramChild : this.diagramPart.getChildren()) {
                    EntityPart entityPart;
                    if (!(diagramChild instanceof EntityPart) || (entityPart = (EntityPart)diagramChild).getEntity() != entity) continue;
                    Rectangle newBounds = new Rectangle();
                    Dimension size = entityPart.getFigure().getPreferredSize();
                    newBounds.x = curLocation.x;
                    newBounds.y = curLocation.y;
                    newBounds.width = size.width;
                    newBounds.height = size.height;
                    entityPart.modifyBounds(newBounds);
                    curLocation.x += size.width + size.width / 2;
                    break;
                }
            }
            this.handleEntityChange(entity, false);
        }
    }

    public void undo() {
        for (ERDEntity entity : this.entities) {
            this.diagramPart.getDiagram().removeEntity(entity, true);
            this.handleEntityChange(entity, true);
        }
    }

    protected void handleEntityChange(ERDEntity entity, boolean remove) {
    }
}

