/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.IEntityEditorContext;
import org.jkiss.utils.CommonUtils;

public class EntityEditorsRegistry {
    private static final String TAG_EDITOR = "editor";
    private static final String TAG_MANAGER = "manager";
    private static EntityEditorsRegistry instance = null;
    private EntityEditorDescriptor defaultEditor;
    private List<EntityEditorDescriptor> entityEditors = new ArrayList<EntityEditorDescriptor>();
    private Map<String, List<EntityEditorDescriptor>> positionsMap = new HashMap<String, List<EntityEditorDescriptor>>();

    public static synchronized EntityEditorsRegistry getInstance() {
        if (instance == null) {
            instance = new EntityEditorsRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public EntityEditorsRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        this.defaultEditor = new EntityEditorDescriptor();
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.databaseEditor");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (TAG_EDITOR.equals(ext.getName())) {
                EntityEditorDescriptor descriptor = new EntityEditorDescriptor(ext);
                this.entityEditors.add(descriptor);
                List<EntityEditorDescriptor> list = this.positionsMap.get(descriptor.getPosition());
                if (list == null) {
                    list = new ArrayList<EntityEditorDescriptor>();
                    this.positionsMap.put(descriptor.getPosition(), list);
                }
                list.add(descriptor);
            }
            ++n2;
        }
    }

    public void dispose() {
        this.entityEditors.clear();
    }

    public EntityEditorDescriptor getMainEntityEditor(DBPObject object, IEntityEditorContext context) {
        for (EntityEditorDescriptor descriptor : this.entityEditors) {
            if (!descriptor.appliesTo(object, context) || !descriptor.isMain() || descriptor.getType() != EntityEditorDescriptor.Type.editor) continue;
            return descriptor;
        }
        return this.defaultEditor;
    }

    public List<EntityEditorDescriptor> getEntityEditors(DBPObject object, IEntityEditorContext context, String position) {
        List<EntityEditorDescriptor> positionList;
        ArrayList<EntityEditorDescriptor> editors = new ArrayList<EntityEditorDescriptor>();
        List<EntityEditorDescriptor> list = positionList = CommonUtils.isEmpty((String)position) ? this.entityEditors : this.positionsMap.get(position);
        if (positionList != null) {
            for (EntityEditorDescriptor descriptor : positionList) {
                if (!descriptor.appliesTo(object, context)) continue;
                editors.add(descriptor);
            }
        }
        return editors;
    }
}

