/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model.plan;

import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSource;
import org.jkiss.dbeaver.ext.oracle.model.plan.OraclePlanNode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;
import org.jkiss.dbeaver.model.impl.plan.AbstractExecutionPlan;
import org.jkiss.utils.IntKeyMap;
import org.jkiss.utils.SecurityUtils;

public class OraclePlanAnalyser
extends AbstractExecutionPlan {
    private static final Log log = Log.getLog(OraclePlanAnalyser.class);
    private OracleDataSource dataSource;
    private JDBCSession session;
    private String query;
    private List<OraclePlanNode> rootNodes;
    private String planStmtId;
    private String planTableName;

    public OraclePlanAnalyser(OracleDataSource dataSource, JDBCSession session, String query) {
        this.dataSource = dataSource;
        this.session = session;
        this.query = query;
    }

    public Object getPlanFeature(String feature) {
        if ("plan.cost".equals(feature) || "plan.duration".equals(feature) || "plan.rows".equals(feature)) {
            return true;
        }
        if ("plan.duration.measure".equals(feature)) {
            return "KC";
        }
        return super.getPlanFeature(feature);
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        if (this.planTableName == null) {
            this.planTableName = this.dataSource.getPlanTableName(this.session);
            if (this.planTableName == null) {
                throw new DBCException("Plan table not found - query can't be explained");
            }
        }
        if (this.planStmtId == null) {
            this.planStmtId = SecurityUtils.generateUniqueId();
        }
        return "EXPLAIN PLAN \nSET STATEMENT_ID = '" + this.planStmtId + "'\n" + "INTO " + this.planTableName + "\n" + "FOR " + this.query;
    }

    public List<? extends DBCPlanNode> getPlanNodes(Map<String, Object> options) {
        return this.rootNodes;
    }

    public void explain() throws DBException {
        String planQuery = this.getPlanQueryString();
        try {
            try (JDBCPreparedStatement dbStat = this.session.prepareStatement("DELETE FROM " + this.planTableName + " WHERE STATEMENT_ID=? ");){
                dbStat.setString(1, this.planStmtId);
                dbStat.execute();
            }
            dbStat = this.session.prepareStatement(planQuery);
            try {
                try {
                    ParameterMetaData parameterMetaData = dbStat.getParameterMetaData();
                    if (parameterMetaData != null && parameterMetaData.getParameterCount() > 0) {
                        int i = 0;
                        while (i < parameterMetaData.getParameterCount()) {
                            dbStat.setNull(i + 1, 12);
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                dbStat.execute();
            }
            finally {
                dbStat.close();
            }
            dbStat = this.session.prepareStatement("SELECT * FROM " + this.planTableName + " WHERE STATEMENT_ID=? ORDER BY ID");
            try {
                dbStat.setString(1, this.planStmtId);
                Throwable e = null;
                Iterator<OraclePlanNode> iterator = null;
                try (JDBCResultSet dbResult = dbStat.executeQuery();){
                    this.rootNodes = new ArrayList<OraclePlanNode>();
                    IntKeyMap allNodes = new IntKeyMap();
                    while (dbResult.next()) {
                        OraclePlanNode node = new OraclePlanNode(this.dataSource, (IntKeyMap<OraclePlanNode>)allNodes, (ResultSet)dbResult);
                        allNodes.put(node.getId(), (Object)node);
                        if (node.getParent() != null) continue;
                        this.rootNodes.add(node);
                    }
                }
                catch (Throwable throwable) {
                    if (e == null) {
                        e = throwable;
                    } else if (e != throwable) {
                        e.addSuppressed(throwable);
                    }
                    throw e;
                }
            }
            finally {
                dbStat.close();
            }
            for (OraclePlanNode node : this.rootNodes) {
                node.updateCosts();
            }
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.session.getDataSource());
        }
    }
}

