/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(name="DeadThread", summary="Thread created but not started", severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DeadThread
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final Matcher<ExpressionTree> NEW_THREAD = MethodMatchers.constructor().forClass("java.lang.Thread");

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!NEW_THREAD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        if (state.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, (Fix)SuggestedFix.postfixWith((Tree)tree, (String)".start()"));
    }
}

