'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const reactionTypeToEmoji = {
  THUMBS_UP: '👍',
  THUMBS_DOWN: '👎',
  LAUGH: '😆',
  HOORAY: '🎉',
  CONFUSED: '😕',
  HEART: '❤️'
};

class EmojiReactionsView extends _react2.default.Component {

  render() {
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishDetailView-reactions' },
      this.props.reactionGroups.map(group => group.users.totalCount > 0 ? _react2.default.createElement(
        'span',
        { className: (0, _classnames2.default)('github-IssueishDetailView-reactionsGroup', group.content.toLowerCase()),
          key: group.content },
        reactionTypeToEmoji[group.content],
        ' \xA0 ',
        group.users.totalCount
      ) : null)
    );
  }
}
exports.default = EmojiReactionsView;
EmojiReactionsView.propTypes = {
  reactionGroups: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    content: _propTypes2.default.string.isRequired,
    users: _propTypes2.default.shape({
      totalCount: _propTypes2.default.number.isRequired
    }).isRequired
  })).isRequired
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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