'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _propTypes3 = require('../prop-types');

var _refHolder = require('../models/ref-holder');

var _refHolder2 = _interopRequireDefault(_refHolder);

var _githubTabContainer = require('../containers/github-tab-container');

var _githubTabContainer2 = _interopRequireDefault(_githubTabContainer);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class GitHubTabItem extends _react2.default.Component {

  static buildURI() {
    return this.uriPattern;
  }

  constructor(props) {
    super(props);

    this.rootHolder = new _refHolder2.default();
  }

  getTitle() {
    return 'GitHub';
  }

  getIconName() {
    return 'octoface';
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  getWorkingDirectory() {
    return this.props.repository.getWorkingDirectoryPath();
  }

  serialize() {
    return {
      deserializer: 'GithubDockItem',
      uri: this.getURI()
    };
  }

  render() {
    return _react2.default.createElement(_githubTabContainer2.default, _extends({}, this.props, { rootHolder: this.rootHolder }));
  }

  hasFocus() {
    return this.rootHolder.map(root => root.contains(this.props.documentActiveElement())).getOr(false);
  }

  restoreFocus() {
    // No-op
  }
}
exports.default = GitHubTabItem;
GitHubTabItem.propTypes = {
  workspace: _propTypes2.default.object.isRequired,
  repository: _propTypes2.default.object,
  loginModel: _propTypes3.GithubLoginModelPropType.isRequired,

  documentActiveElement: _propTypes2.default.func
};
GitHubTabItem.defaultProps = {
  documentActiveElement: /* istanbul ignore next */() => document.activeElement
};
GitHubTabItem.uriPattern = 'atom-github://dock-item/github';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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