'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactRelay = require('react-relay');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _octicon = require('../atom/octicon');

var _octicon2 = _interopRequireDefault(_octicon);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const typeAndStateToIcon = {
  Issue: {
    OPEN: 'issue-opened',
    CLOSED: 'issue-closed'
  },
  PullRequest: {
    OPEN: 'git-pull-request',
    CLOSED: 'git-pull-request',
    MERGED: 'git-merge'
  }
};

class IssueishTooltip extends _react2.default.Component {

  render() {
    const resource = this.props.resource;
    const { repository, state, number, title, author, __typename } = resource;
    const icons = typeAndStateToIcon[__typename] || {};
    const icon = icons[state] || '';
    return _react2.default.createElement(
      'div',
      { className: 'github-IssueishTooltip' },
      _react2.default.createElement(
        'div',
        { className: 'issueish-avatar-and-title' },
        _react2.default.createElement('img', { className: 'author-avatar', src: author.avatarUrl, title: author.login,
          alt: author.login
        }),
        _react2.default.createElement(
          'h3',
          { className: 'issueish-title' },
          title
        )
      ),
      _react2.default.createElement(
        'div',
        { className: 'issueish-badge-and-link' },
        _react2.default.createElement(
          'span',
          { className: (0, _classnames2.default)('issueish-badge', 'badge', state.toLowerCase()) },
          _react2.default.createElement(_octicon2.default, { icon: icon }),
          state.toLowerCase()
        ),
        _react2.default.createElement(
          'span',
          { className: 'issueish-link' },
          repository.owner.login,
          '/',
          repository.name,
          '#',
          number
        )
      )
    );
  }
}

IssueishTooltip.propTypes = {
  resource: _propTypes2.default.shape({
    issue: _propTypes2.default.shape({}),
    pullRequest: _propTypes2.default.shape({})
  }).isRequired
};
exports.default = (0, _reactRelay.createFragmentContainer)(IssueishTooltip, {
  resource: function () {
    const node = require('./__generated__/issueishTooltipContainer_resource.graphql');

    if (node.hash && node.hash !== '8980fc73c7ed3f632f0612ce14f2f0d1') {
      console.error('The definition of \'issueishTooltipContainer_resource\' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.');
    }

    return require('./__generated__/issueishTooltipContainer_resource.graphql');
  }
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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