/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.thread;

import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.lsof.LsofExecutorThread;
import net.sourceforge.glsof.common.lsof.LsofOutputParser;
import net.sourceforge.glsof.queries.thread.Logger;
import net.sourceforge.glsof.queries.thread.QueryRunningAnimation;
import net.sourceforge.glsof.queries.thread.QueryThread;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeItem;

public class QueryObserver
implements Observer {
    public static final int CUSTOM_ENABLE_SIGNAL = 987654321;
    private QueryThread _queryThread;
    private Composite _searchBarContainer;
    private Composite _tablesContainer;
    private TreeItem _queryTreeItem;
    private Logger _logger;
    private LsofExecutorThread _parser;
    private QueryRunningAnimation _queryRunningAnimation;

    public QueryObserver(Composite searchBarContainer, Composite tablesContainer, TreeItem queryTreeItem, Logger logger) {
        this._searchBarContainer = searchBarContainer;
        this._tablesContainer = tablesContainer;
        this._queryTreeItem = queryTreeItem;
        this._logger = logger;
    }

    public TreeItem getQueryTreeItem() {
        return this._queryTreeItem;
    }

    public void setQueryTreeItem(TreeItem queryTreeItem) {
        this._queryTreeItem = queryTreeItem;
    }

    public Map<String, Table> getTables() {
        return this._queryThread == null ? null : this._queryThread.getTables();
    }

    public Table getTableForProcess(String name) {
        return this._queryThread.getTableForProcess(name);
    }

    @Override
    public void update(Observable observed, final Object buffer) {
        if (observed instanceof LsofOutputParser) {
            if (buffer == null) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (Table table : QueryObserver.this._queryThread.getTables().values()) {
                            for (TableColumn column : table.getColumns()) {
                                if (column.getWidth() == 0) continue;
                                column.pack();
                            }
                        }
                        QueryObserver.this._queryRunningAnimation.stop();
                        QueryObserver.this.notifySearchBar(true);
                        QueryObserver.this._logger.logMessage(Messages.NLS("Query") + " <" + QueryObserver.this._queryTreeItem.getText() + ">. " + Messages.NLS("Processes") + ": " + QueryObserver.this._queryTreeItem.getItemCount(), "stop");
                    }
                });
                return;
            }
            this._queryThread.setParsedOutput((String[])buffer);
            Display.getDefault().syncExec(this._queryThread);
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                QueryObserver.this._logger.logMessage(Messages.NLS("Query") + " <" + QueryObserver.this._queryTreeItem.getText() + ">. " + Messages.NLS("Error") + ": " + buffer, "err");
            }
        });
    }

    public void runLsof(String lsofParameters, List<Boolean> columnsViews) {
        if (this._parser == null || !this._parser.isRunning()) {
            this._logger.logMessage(Messages.NLS("Query") + " <" + this._queryTreeItem.getText() + ">. " + Messages.NLS("Parameters") + ": " + lsofParameters, "start");
            this._queryThread = new QueryThread(this._queryTreeItem, this._tablesContainer, columnsViews);
            this._parser = new LsofExecutorThread(this, lsofParameters);
            this._queryRunningAnimation = new QueryRunningAnimation(this._queryTreeItem);
            this.notifySearchBar(false);
            Display.getDefault().asyncExec(this._queryRunningAnimation);
            new Thread(this._parser).start();
        }
    }

    private void notifySearchBar(boolean enable) {
        Event e = new Event();
        e.type = 987654321;
        e.widget = this._searchBarContainer;
        e.data = enable;
        this._searchBarContainer.notifyListeners(987654321, e);
    }

    public void disposeAll() {
        if (this._queryThread != null) {
            this._queryThread.disposeAll();
        }
    }

    public void stop() {
        if (this._parser != null) {
            this._parser.stop();
            this._parser.setRunning(false);
        }
    }

    public boolean isRunning() {
        return this._parser == null ? false : this._parser.isRunning();
    }
}

