/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.stats;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeItem;

class QueryStatistics {
    private int _totalRowsCount = 0;
    private Map<String, Integer> _processes = new HashMap<String, Integer>();
    private Map<String, Integer> _users = new HashMap<String, Integer>();

    QueryStatistics() {
    }

    public void calculate(TreeItem[] items, Map<String, Table> tables) {
        for (TreeItem item : items) {
            String processName = item.getText();
            Table table = tables.get(processName);
            int tableRows = table.getItemCount();
            this._totalRowsCount += tableRows;
            this._processes.put(processName, tableRows);
            this.calculateUsersFor(table);
        }
    }

    private void calculateUsersFor(Table table) {
        for (TableItem item : table.getItems()) {
            String user;
            Integer countForUser = this._users.get(user = item.getText(3));
            this._users.put(user, 1 + (countForUser == null ? 0 : countForUser));
        }
    }

    public int getTotalRowsCount() {
        return this._totalRowsCount;
    }

    public Map<String, Integer> getProcesses() {
        return this._processes;
    }

    public Map<String, Integer> getUsers() {
        return this._users;
    }
}

