/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.search;

import java.util.ArrayList;
import java.util.Map;
import net.sourceforge.glsof.common.search.SearchWholeTable;
import net.sourceforge.glsof.common.search.TextMatcherInfo;
import net.sourceforge.glsof.queries.search.AbstractQuerySearch;
import org.eclipse.swt.widgets.Table;

public class QuerySearchEverywhere
extends AbstractQuerySearch {
    private static final int COLUMNS_NUMBER = 12;
    private final SearchWholeTable _searchWholeTable;
    private boolean _processColumnSearchEnabled = true;

    public QuerySearchEverywhere(TextMatcherInfo textMatcherInfo) {
        super(textMatcherInfo);
        this._searchWholeTable = new SearchWholeTable(textMatcherInfo, 12);
    }

    public void init(String text, boolean caseSensitive) {
        if (this.isRequiredInit(text, caseSensitive)) {
            this.reset();
            this._processColumnSearchEnabled = true;
            this._searchWholeTable.deselect();
            this._searchWholeTable.reset();
        }
    }

    public void restoreReset() {
        this._searchWholeTable.restoreReset();
    }

    @Override
    protected boolean match(Map<String, Table> tables, String text, int queryIndex, int processIndex) {
        int i;
        ArrayList<String> processes = new ArrayList<String>(tables.keySet());
        int n = i = processIndex == -1 ? 0 : processIndex;
        while (i < processes.size()) {
            if (this._processColumnSearchEnabled && this.textMatch(text, processes.get(i))) {
                this.changeStatus(queryIndex, i);
                this._searchWholeTable.deselect();
                this._searchWholeTable.reset();
                return true;
            }
            if (this._searchWholeTable.hasFoundMatch(tables.get(processes.get(i)), text)) {
                this.changeStatus(queryIndex, i);
                return true;
            }
            this._processColumnSearchEnabled = true;
            this._searchWholeTable.reset();
            ++i;
        }
        return false;
    }

    private void changeStatus(int queryIndex, int i) {
        this.setQueryIndex(queryIndex);
        this.setProcessIndex(i);
        this._processColumnSearchEnabled = false;
    }
}

