/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.queries.queries;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.sourceforge.glsof.common.main.AbstractSearchBar;
import net.sourceforge.glsof.common.search.TextMatcherInfo;
import net.sourceforge.glsof.queries.search.QuerySearchEverywhere;
import net.sourceforge.glsof.queries.search.QuerySearchInterface;
import net.sourceforge.glsof.queries.search.QuerySearchProcessColumn;
import net.sourceforge.glsof.queries.search.QuerySearchTablesColumns;
import net.sourceforge.glsof.queries.thread.QueryObserver;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QueriesSearchBar
extends AbstractSearchBar {
    private final QuerySearchProcessColumn _searchProcessColumn;
    private final QuerySearchTablesColumns _searchTablesColumns;
    private final QuerySearchEverywhere _searchEverywhere;
    private Tree _queryTree;
    private Map<String, QueryObserver> _queries;
    private int _lastSelectedColumn;

    public QueriesSearchBar(Composite parent, Tree queryTree, Map<String, QueryObserver> queries) {
        super(parent);
        this._queryTree = queryTree;
        this._queries = queries;
        TextMatcherInfo textMatcherInfo = new TextMatcherInfo();
        this._searchProcessColumn = new QuerySearchProcessColumn(textMatcherInfo);
        this._searchTablesColumns = new QuerySearchTablesColumns(textMatcherInfo);
        this._searchEverywhere = new QuerySearchEverywhere(textMatcherInfo);
        parent.addListener(987654321, new Listener(){
            private int _countSearchBarView = 0;

            @Override
            public void handleEvent(Event event) {
                if (!((Boolean)event.data).booleanValue() && ++this._countSearchBarView == 1) {
                    QueriesSearchBar.this.enableWidgets(false);
                    QueriesSearchBar.this.resetAll();
                } else if (((Boolean)event.data).booleanValue() && --this._countSearchBarView == 0) {
                    QueriesSearchBar.this.enableWidgets(true);
                }
            }
        });
    }

    @Override
    protected void search(Combo comboColumnsList, Combo comboSearch, Button buttonCase) {
        int selectedColumn = comboColumnsList.getSelectionIndex();
        if (selectedColumn != this._lastSelectedColumn) {
            this._lastSelectedColumn = selectedColumn;
            this.resetAll();
        }
        this.search(comboColumnsList, comboSearch, buttonCase, selectedColumn);
    }

    private void resetAll() {
        this._searchProcessColumn.reset();
        this._searchTablesColumns.reset();
        this._searchEverywhere.reset();
    }

    private void search(Combo comboColumnsList, Combo comboSearch, Button buttonCase, int selectedColumn) {
        if (selectedColumn == 0) {
            this.runSearchEverywhere(comboSearch.getText(), buttonCase.getSelection());
        } else if (selectedColumn == 1) {
            this.runSearchProcessColumn(comboSearch.getText(), buttonCase.getSelection());
        } else {
            this.runSearchTablesColumns(comboSearch.getText(), comboColumnsList.getSelectionIndex() - 2, buttonCase.getSelection());
        }
    }

    public void runSearchProcessColumn(String text, boolean caseSensitive) {
        this._searchProcessColumn.init(text, caseSensitive);
        this.runSearch(this._searchProcessColumn, text);
    }

    public void runSearchTablesColumns(String text, int columnIndex, boolean caseSensitive) {
        this._searchTablesColumns.init(text, columnIndex, caseSensitive);
        this.runSearch(this._searchTablesColumns, text);
    }

    public void runSearchEverywhere(String text, boolean caseSensitive) {
        this._searchEverywhere.init(text, caseSensitive);
        this.runSearch(this._searchEverywhere, text);
    }

    private void runSearch(QuerySearchInterface search, String text) {
        if (search.hasFoundMatch(this.retrieveAllTables(), this._queryTree, text)) {
            this.highlightQueryProcess(search.getQueryIndex(), search.getProcessIndex());
        } else if (this.getMessageBox().open() == 64) {
            search.reset();
            this.runSearch(search, text);
        } else if (search instanceof QuerySearchEverywhere) {
            ((QuerySearchEverywhere)search).restoreReset();
        }
    }

    private void highlightQueryProcess(int queryIndex, int processIndex) {
        TreeItem treeItem = this.getQueryTreeItem(queryIndex);
        treeItem.setExpanded(true);
        TreeItem processTreeItem = treeItem.getItems()[processIndex];
        treeItem.getParent().setSelection(processTreeItem);
        Event event = new Event();
        event.item = processTreeItem;
        treeItem.getParent().notifyListeners(13, event);
    }

    private ArrayList<Map<String, Table>> retrieveAllTables() {
        ArrayList<Map<String, Table>> queriesTables = new ArrayList<Map<String, Table>>();
        for (QueryObserver query : this._queries.values()) {
            queriesTables.add(query.getTables() == null ? new HashMap() : query.getTables());
        }
        return queriesTables;
    }

    private TreeItem getQueryTreeItem(int queryIndex) {
        return new LinkedList<QueryObserver>(this._queries.values()).get(queryIndex).getQueryTreeItem();
    }
}

