/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.main;

import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.WidgetsUtils;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;

public abstract class AbstractSearchBar {
    public static final String[] COLUMN_TITLE_TEXT = new String[]{"", Messages.NLS("PROCESS"), "PID", "PGID", "PPID", Messages.NLS("USER"), "FD", Messages.NLS("TYPE"), Messages.NLS("DEVICE"), Messages.NLS("SIZE"), "NLINK", Messages.NLS("NODE"), Messages.NLS("NAME")};
    private static final String SEARCH_BUTTON = "/icons/search.png";
    private Label _label;
    private Combo _comboSearch;
    private Combo _comboColumnsList;
    private Button _buttonCase;
    private Button _buttonFind;
    private MessageBox _messageBox = WidgetsUtils.questionMessage(Messages.NLS("End_of_search_reached"), Messages.NLS("Do_you_want_to_restart_search_at_the_beginning"));

    protected abstract void search(Combo var1, Combo var2, Button var3);

    protected AbstractSearchBar(Composite parent) {
        this._label = new Label(parent, 0);
        this._label.setLayoutData(new GridData(68));
        this._label.setText(Messages.NLS("Search"));
        this._comboSearch = new Combo(parent, 0);
        this._comboSearch.setLayoutData(new GridData(768));
        this._comboColumnsList = new Combo(parent, 520);
        for (String title : COLUMN_TITLE_TEXT) {
            this._comboColumnsList.add(title);
        }
        this._comboColumnsList.select(0);
        this._buttonCase = new Button(parent, 32);
        this._buttonCase.setText(Messages.NLS("Case_sensitive"));
        Image buttonFindImage = new Image((Device)Display.getCurrent(), this.getClass().getResourceAsStream(SEARCH_BUTTON));
        this._buttonFind = new Button(parent, 0);
        this._buttonFind.setText(Messages.NLS("Find"));
        this._buttonFind.setImage(buttonFindImage);
        buttonFindImage.dispose();
        this.comboSearch();
        this.buttonFind();
    }

    protected void highlightRowTable(Table table, int row) {
        table.setTopIndex(row);
        table.setSelection(row);
    }

    private void comboSearch() {
        this._comboSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 13 && AbstractSearchBar.this._comboSearch.getText().length() > 0) {
                    AbstractSearchBar.this.search(AbstractSearchBar.this._comboColumnsList, AbstractSearchBar.this._comboSearch, AbstractSearchBar.this._buttonCase);
                }
            }
        });
    }

    private void buttonFind() {
        this._buttonFind.addListener(13, new Listener(){

            @Override
            public void handleEvent(Event e) {
                if (e.type == 13 && AbstractSearchBar.this._comboSearch.getText().length() > 0) {
                    AbstractSearchBar.this.search(AbstractSearchBar.this._comboColumnsList, AbstractSearchBar.this._comboSearch, AbstractSearchBar.this._buttonCase);
                }
            }
        });
    }

    protected void enableWidgets(boolean enable) {
        this._label.setEnabled(enable);
        this._comboSearch.setEnabled(enable);
        this._comboColumnsList.setEnabled(enable);
        this._buttonCase.setEnabled(enable);
        this._buttonFind.setEnabled(enable);
    }

    protected MessageBox getMessageBox() {
        return this._messageBox;
    }
}

