/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.main;

import java.io.File;
import net.sourceforge.glsof.common.about.AboutDialog;
import net.sourceforge.glsof.common.i18n.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractMainWindow {
    private static final String MENU_EXIT = "/icons/gtk-close.png";
    protected static final String MENU_VIEW_REFRESH = "/icons/view-refresh.png";
    private Display _display = new Display();
    private Shell _shell = new Shell(this._display);
    private Menu _menuBar;

    protected abstract void createMenuItems();

    protected abstract void close();

    protected abstract void createContents(Composite var1);

    protected AbstractMainWindow(String caption) {
        this._shell.setText(caption);
        this._shell.setLayout(new FillLayout());
        this._shell.addListener(21, new Listener(){

            @Override
            public void handleEvent(Event event) {
                AbstractMainWindow.this.close();
            }
        });
        this._menuBar = new Menu(this._shell, 2);
        this.createMenuItems();
        this._shell.setMenuBar(this._menuBar);
        this.createContents(this._shell);
        this._shell.open();
        while (!this._shell.isDisposed()) {
            if (this._display.readAndDispatch()) continue;
            this._display.sleep();
        }
        this._display.dispose();
    }

    protected Menu createMenu(String text) {
        MenuItem menuItem = new MenuItem(this._menuBar, 64);
        menuItem.setText(text);
        Menu menu = new Menu(this._shell, 4);
        menuItem.setMenu(menu);
        return menu;
    }

    protected MenuItem createMenuItem(Menu menuBar, int type, String text, int acc, String imagePath) {
        MenuItem menuItem = new MenuItem(menuBar, type);
        menuItem.setText(text);
        if (acc != -1) {
            menuItem.setAccelerator(acc);
        }
        if (imagePath != null && !imagePath.equals("")) {
            Image image = new Image((Device)this._display, this.getClass().getResourceAsStream(imagePath));
            menuItem.setImage(image);
            image.dispose();
        }
        return menuItem;
    }

    protected void destroyWindow() {
        this._shell.close();
        this._display.dispose();
    }

    protected File createSettingsDir(String path) {
        String userHome = System.getProperty("user.home");
        File dir = new File(userHome, path);
        if (!dir.exists() || dir.isFile()) {
            dir.mkdir();
        }
        return dir;
    }

    protected Point getWindowPosition() {
        return this._shell.getLocation();
    }

    protected Point getWindowSize() {
        return this._shell.getSize();
    }

    protected void createExitItem(Menu menuBar) {
        this.createMenuItem(menuBar, 8, Messages.NLS("Exxit_CtrlQ"), 262225, MENU_EXIT).addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                AbstractMainWindow.this.destroyWindow();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    protected void createAboutItem(Menu menuBar, final String logoPath, final String caption) {
        this.createMenuItem(menuBar, 8, Messages.NLS("About"), -1, MENU_VIEW_REFRESH).addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                new AboutDialog(AbstractMainWindow.this._shell, logoPath, caption).open();
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }

    protected void createFullscreenItem(Menu viewMenu) {
        this.createMenuItem(viewMenu, 32, Messages.NLS("Fuullscreen_F11"), 0x1000014, "").addSelectionListener(new SelectionListener(){

            @Override
            public void widgetSelected(SelectionEvent selectionEvent) {
                Display.getCurrent().getActiveShell().setFullScreen(((MenuItem)selectionEvent.widget).getSelection());
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
                this.widgetSelected(selectionEvent);
            }
        });
    }
}

