/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.components.all.request;

import java.awt.Color;
import java.awt.Component;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextArea;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.httppanel.view.impl.models.http.request.RequestStringHttpPanelViewModel;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextArea;
import org.zaproxy.zap.extension.httppanel.view.syntaxhighlight.HttpPanelSyntaxHighlightTextView;
import org.zaproxy.zap.extension.httppanel.view.util.CaretVisibilityEnforcerOnFocusGain;
import org.zaproxy.zap.extension.httppanel.view.util.HttpTextViewUtils;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.model.DefaultTextHttpMessageLocation;
import org.zaproxy.zap.model.HttpMessageLocation;
import org.zaproxy.zap.model.MessageLocation;
import org.zaproxy.zap.model.TextHttpMessageLocation;
import org.zaproxy.zap.view.messagecontainer.http.SelectableContentHttpMessageContainer;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.MessageLocationHighlightsManager;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListener;
import org.zaproxy.zap.view.messagelocation.MessageLocationProducerFocusListenerAdapter;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlight;
import org.zaproxy.zap.view.messagelocation.TextMessageLocationHighlightsManager;

public class HttpRequestAllPanelSyntaxHighlightTextView
extends HttpPanelSyntaxHighlightTextView
implements SelectableContentHttpMessageContainer {
    public static final String NAME = "HttpRequestSyntaxTextView";
    private MessageLocationProducerFocusListenerAdapter focusListenerAdapter;

    public HttpRequestAllPanelSyntaxHighlightTextView(RequestStringHttpPanelViewModel model) {
        super(model);
        this.getHttpPanelTextArea().setComponentPopupMenu(new HttpPanelSyntaxHighlightTextView.CustomPopupMenu(){
            private static final long serialVersionUID = 377256890518967680L;

            @Override
            public void show(Component invoker, int x, int y) {
                if (!HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().isFocusOwner()) {
                    HttpRequestAllPanelSyntaxHighlightTextView.this.getHttpPanelTextArea().requestFocusInWindow();
                }
                View.getSingleton().getPopupMenu().show(HttpRequestAllPanelSyntaxHighlightTextView.this, x, y);
            }
        });
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea createHttpPanelTextArea() {
        return new HttpRequestAllPanelSyntaxHighlightTextArea();
    }

    @Override
    protected HttpRequestAllPanelSyntaxHighlightTextArea getHttpPanelTextArea() {
        return (HttpRequestAllPanelSyntaxHighlightTextArea)super.getHttpPanelTextArea();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Class<HttpMessage> getMessageClass() {
        return HttpMessage.class;
    }

    @Override
    public Class<? extends MessageLocation> getMessageLocationClass() {
        return TextHttpMessageLocation.class;
    }

    @Override
    public MessageLocation getSelection() {
        return this.getHttpPanelTextArea().getSelection();
    }

    @Override
    public MessageLocationHighlightsManager create() {
        return this.getHttpPanelTextArea().create();
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location) {
        if (!this.supports(location)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, new TextMessageLocationHighlight(Color.LIGHT_GRAY));
    }

    @Override
    public MessageLocationHighlight highlight(MessageLocation location, MessageLocationHighlight highlight) {
        if (!this.supports(location) || !(highlight instanceof TextMessageLocationHighlight)) {
            return null;
        }
        TextHttpMessageLocation textLocation = (TextHttpMessageLocation)location;
        TextMessageLocationHighlight textHighlight = (TextMessageLocationHighlight)highlight;
        return this.getHttpPanelTextArea().highlightImpl(textLocation, textHighlight);
    }

    @Override
    public void removeHighlight(MessageLocation location, MessageLocationHighlight highlightReference) {
        if (!(highlightReference instanceof TextMessageLocationHighlight)) {
            return;
        }
        this.getHttpPanelTextArea().removeHighlight(((TextMessageLocationHighlight)highlightReference).getHighlightReference());
    }

    @Override
    public boolean supports(MessageLocation location) {
        if (!(location instanceof TextHttpMessageLocation)) {
            return false;
        }
        HttpMessageLocation.Location msgLocation = ((TextHttpMessageLocation)location).getLocation();
        return msgLocation == HttpMessageLocation.Location.REQUEST_HEADER || msgLocation == HttpMessageLocation.Location.REQUEST_BODY;
    }

    @Override
    public boolean supports(Class<? extends MessageLocation> classLocation) {
        return TextHttpMessageLocation.class.isAssignableFrom(classLocation);
    }

    @Override
    public void addFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(MessageLocationProducerFocusListener focusListener) {
        this.getFocusListenerAdapter().removeFocusListener(focusListener);
        if (!this.getFocusListenerAdapter().hasFocusListeners()) {
            this.getHttpPanelTextArea().removeFocusListener(this.focusListenerAdapter);
            this.focusListenerAdapter = null;
        }
    }

    @Override
    public HttpMessage getMessage() {
        return this.getHttpPanelTextArea().getMessage();
    }

    @Override
    public Component getComponent() {
        return this.getHttpPanelTextArea();
    }

    @Override
    public boolean isEmpty() {
        return this.getHttpPanelTextArea().getMessage() == null;
    }

    private MessageLocationProducerFocusListenerAdapter getFocusListenerAdapter() {
        if (this.focusListenerAdapter == null) {
            this.focusListenerAdapter = new MessageLocationProducerFocusListenerAdapter(this);
            this.getHttpPanelTextArea().addFocusListener(this.focusListenerAdapter);
        }
        return this.focusListenerAdapter;
    }

    protected static class HttpRequestAllPanelSyntaxHighlightTextArea
    extends HttpPanelSyntaxHighlightTextArea {
        private static final long serialVersionUID = 923466158533211593L;
        private static final Logger log = Logger.getLogger(HttpRequestAllPanelSyntaxHighlightTextArea.class);
        private static RequestAllTokenMakerFactory tokenMakerFactory = null;
        private CaretVisibilityEnforcerOnFocusGain caretVisiblityEnforcer = new CaretVisibilityEnforcerOnFocusGain((JTextComponent)((Object)this));

        @Override
        public HttpMessage getMessage() {
            return (HttpMessage)super.getMessage();
        }

        @Override
        public void setMessage(Message aMessage) {
            super.setMessage(aMessage);
            this.caretVisiblityEnforcer.setEnforceVisibilityOnFocusGain(aMessage != null);
        }

        protected MessageLocation getSelection() {
            String value;
            HttpMessageLocation.Location location;
            String header = this.getMessage().getRequestHeader().toString();
            int[] position = HttpTextViewUtils.getViewToHeaderBodyPosition((JTextArea)((Object)this), header, this.getSelectionStart(), this.getSelectionEnd());
            if (position.length == 0) {
                return new DefaultTextHttpMessageLocation(HttpMessageLocation.Location.REQUEST_HEADER, 0);
            }
            int start = position[0];
            int end = position[1];
            if (position.length == 2) {
                location = HttpMessageLocation.Location.REQUEST_HEADER;
                value = header.substring(start, end);
            } else {
                location = HttpMessageLocation.Location.REQUEST_BODY;
                value = this.getMessage().getRequestBody().toString().substring(start, end);
            }
            return new DefaultTextHttpMessageLocation(location, start, end, value);
        }

        protected MessageLocationHighlightsManager create() {
            return new TextMessageLocationHighlightsManager();
        }

        protected MessageLocationHighlight highlightImpl(TextHttpMessageLocation textLocation, TextMessageLocationHighlight textHighlight) {
            if (this.getMessage() == null) {
                return null;
            }
            int[] pos = HttpMessageLocation.Location.REQUEST_HEADER.equals((Object)textLocation.getLocation()) ? HttpTextViewUtils.getHeaderToViewPosition((JTextArea)((Object)this), this.getMessage().getRequestHeader().toString(), textLocation.getStart(), textLocation.getEnd()) : HttpTextViewUtils.getBodyToViewPosition((JTextArea)((Object)this), this.getMessage().getRequestHeader().toString(), textLocation.getStart(), textLocation.getEnd());
            if (pos.length == 0) {
                return null;
            }
            textHighlight.setHighlightReference(this.highlight(pos[0], pos[1], textHighlight));
            return textHighlight;
        }

        @Override
        public void search(Pattern p, List<SearchMatch> matches) {
            String header = this.getMessage().getRequestHeader().toString();
            Matcher m = p.matcher(this.getText());
            while (m.find()) {
                int[] position = HttpTextViewUtils.getViewToHeaderBodyPosition((JTextArea)((Object)this), header, m.start(), m.end());
                if (position.length == 0) {
                    return;
                }
                SearchMatch.Location location = position.length == 2 ? SearchMatch.Location.REQUEST_HEAD : SearchMatch.Location.REQUEST_BODY;
                matches.add(new SearchMatch(location, position[0], position[1]));
            }
        }

        @Override
        public void highlight(SearchMatch sm) {
            if (!SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation()) && !SearchMatch.Location.REQUEST_BODY.equals((Object)sm.getLocation())) {
                return;
            }
            int[] pos = SearchMatch.Location.REQUEST_HEAD.equals((Object)sm.getLocation()) ? HttpTextViewUtils.getHeaderToViewPosition((JTextArea)((Object)this), sm.getMessage().getRequestHeader().toString(), sm.getStart(), sm.getEnd()) : HttpTextViewUtils.getBodyToViewPosition((JTextArea)((Object)this), sm.getMessage().getRequestHeader().toString(), sm.getStart(), sm.getEnd());
            if (pos.length == 0) {
                return;
            }
            this.highlight(pos[0], pos[1]);
        }

        @Override
        protected synchronized HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory getTokenMakerFactory() {
            if (tokenMakerFactory == null) {
                tokenMakerFactory = new RequestAllTokenMakerFactory();
            }
            return tokenMakerFactory;
        }

        private static class RequestAllTokenMakerFactory
        extends HttpPanelSyntaxHighlightTextArea.CustomTokenMakerFactory {
        }
    }
}

