/*
 * This declarations of the PIC18F24K50 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2016.
 *
 * This file is generated automatically by the cinc2h.pl, 2016-04-13 17:23:27 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC18F24K50_H__
#define __PIC18F24K50_H__

//==============================================================================

//==============================================================================
//
//	Register Definitions
//
//==============================================================================


//==============================================================================
//        SRCON1 Bits

extern __at(0x0F57) __sfr SRCON1;

typedef struct
  {
  unsigned SRRC1E               : 1;
  unsigned SRRC2E               : 1;
  unsigned SRRCKE               : 1;
  unsigned SRRPE                : 1;
  unsigned SRSC1E               : 1;
  unsigned SRSC2E               : 1;
  unsigned SRSCKE               : 1;
  unsigned SRSPE                : 1;
  } __SRCON1bits_t;

extern __at(0x0F57) volatile __SRCON1bits_t SRCON1bits;

#define _SRRC1E                 0x01
#define _SRRC2E                 0x02
#define _SRRCKE                 0x04
#define _SRRPE                  0x08
#define _SRSC1E                 0x10
#define _SRSC2E                 0x20
#define _SRSCKE                 0x40
#define _SRSPE                  0x80

//==============================================================================


//==============================================================================
//        SRCON0 Bits

extern __at(0x0F58) __sfr SRCON0;

typedef union
  {
  struct
    {
    unsigned SRPR               : 1;
    unsigned SRPS               : 1;
    unsigned SRNQEN             : 1;
    unsigned SRQEN              : 1;
    unsigned SRCLK0             : 1;
    unsigned SRCLK1             : 1;
    unsigned SRCLK2             : 1;
    unsigned SRLEN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned SRCLK              : 3;
    unsigned                    : 1;
    };
  } __SRCON0bits_t;

extern __at(0x0F58) volatile __SRCON0bits_t SRCON0bits;

#define _SRPR                   0x01
#define _SRPS                   0x02
#define _SRNQEN                 0x04
#define _SRQEN                  0x08
#define _SRCLK0                 0x10
#define _SRCLK1                 0x20
#define _SRCLK2                 0x40
#define _SRLEN                  0x80

//==============================================================================


//==============================================================================
//        CCPTMRS Bits

extern __at(0x0F59) __sfr CCPTMRS;

typedef struct
  {
  unsigned C1TSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned C2TSEL               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __CCPTMRSbits_t;

extern __at(0x0F59) volatile __CCPTMRSbits_t CCPTMRSbits;

#define _C1TSEL                 0x01
#define _C2TSEL                 0x08

//==============================================================================

extern __at(0x0F5A) __sfr VREGCON;

//==============================================================================
//        ANSELA Bits

extern __at(0x0F5B) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned                      : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x0F5B) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x0F5C) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x0F5C) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================


//==============================================================================
//        ANSELC Bits

extern __at(0x0F5D) __sfr ANSELC;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC2                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned ANSC6                : 1;
  unsigned ANSC7                : 1;
  } __ANSELCbits_t;

extern __at(0x0F5D) volatile __ANSELCbits_t ANSELCbits;

#define _ANSC2                  0x04
#define _ANSC6                  0x40
#define _ANSC7                  0x80

//==============================================================================


//==============================================================================
//        UCON Bits

extern __at(0x0F60) __sfr UCON;

typedef struct
  {
  unsigned                      : 1;
  unsigned SUSPND               : 1;
  unsigned RESUME               : 1;
  unsigned USBEN                : 1;
  unsigned PKTDIS               : 1;
  unsigned SE0                  : 1;
  unsigned PPBRST               : 1;
  unsigned                      : 1;
  } __UCONbits_t;

extern __at(0x0F60) volatile __UCONbits_t UCONbits;

#define _SUSPND                 0x02
#define _RESUME                 0x04
#define _USBEN                  0x08
#define _PKTDIS                 0x10
#define _SE0                    0x20
#define _PPBRST                 0x40

//==============================================================================


//==============================================================================
//        USTAT Bits

extern __at(0x0F61) __sfr USTAT;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned PPBI               : 1;
    unsigned DIR                : 1;
    unsigned ENDP0              : 1;
    unsigned ENDP1              : 1;
    unsigned ENDP2              : 1;
    unsigned ENDP3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ENDP               : 4;
    unsigned                    : 1;
    };
  } __USTATbits_t;

extern __at(0x0F61) volatile __USTATbits_t USTATbits;

#define _PPBI                   0x02
#define _DIR                    0x04
#define _ENDP0                  0x08
#define _ENDP1                  0x10
#define _ENDP2                  0x20
#define _ENDP3                  0x40

//==============================================================================


//==============================================================================
//        UCFG Bits

extern __at(0x0F62) __sfr UCFG;

typedef union
  {
  struct
    {
    unsigned PPB0               : 1;
    unsigned PPB1               : 1;
    unsigned FSEN               : 1;
    unsigned UTRDIS             : 1;
    unsigned UPUEN              : 1;
    unsigned                    : 1;
    unsigned UOEMON             : 1;
    unsigned UTEYE              : 1;
    };

  struct
    {
    unsigned PPB                : 2;
    unsigned                    : 6;
    };
  } __UCFGbits_t;

extern __at(0x0F62) volatile __UCFGbits_t UCFGbits;

#define _PPB0                   0x01
#define _PPB1                   0x02
#define _FSEN                   0x04
#define _UTRDIS                 0x08
#define _UPUEN                  0x10
#define _UOEMON                 0x40
#define _UTEYE                  0x80

//==============================================================================


//==============================================================================
//        UADDR Bits

extern __at(0x0F63) __sfr UADDR;

typedef union
  {
  struct
    {
    unsigned ADDR0              : 1;
    unsigned ADDR1              : 1;
    unsigned ADDR2              : 1;
    unsigned ADDR3              : 1;
    unsigned ADDR4              : 1;
    unsigned ADDR5              : 1;
    unsigned ADDR6              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ADDR               : 7;
    unsigned                    : 1;
    };
  } __UADDRbits_t;

extern __at(0x0F63) volatile __UADDRbits_t UADDRbits;

#define _ADDR0                  0x01
#define _ADDR1                  0x02
#define _ADDR2                  0x04
#define _ADDR3                  0x08
#define _ADDR4                  0x10
#define _ADDR5                  0x20
#define _ADDR6                  0x40

//==============================================================================


//==============================================================================
//        UIE Bits

extern __at(0x0F64) __sfr UIE;

typedef struct
  {
  unsigned URSTIE               : 1;
  unsigned UERRIE               : 1;
  unsigned ACTVIE               : 1;
  unsigned TRNIE                : 1;
  unsigned IDLEIE               : 1;
  unsigned STALLIE              : 1;
  unsigned SOFIE                : 1;
  unsigned                      : 1;
  } __UIEbits_t;

extern __at(0x0F64) volatile __UIEbits_t UIEbits;

#define _URSTIE                 0x01
#define _UERRIE                 0x02
#define _ACTVIE                 0x04
#define _TRNIE                  0x08
#define _IDLEIE                 0x10
#define _STALLIE                0x20
#define _SOFIE                  0x40

//==============================================================================


//==============================================================================
//        UIR Bits

extern __at(0x0F65) __sfr UIR;

typedef struct
  {
  unsigned URSTIF               : 1;
  unsigned UERRIF               : 1;
  unsigned ACTVIF               : 1;
  unsigned TRNIF                : 1;
  unsigned IDLEIF               : 1;
  unsigned STALLIF              : 1;
  unsigned SOFIF                : 1;
  unsigned                      : 1;
  } __UIRbits_t;

extern __at(0x0F65) volatile __UIRbits_t UIRbits;

#define _URSTIF                 0x01
#define _UERRIF                 0x02
#define _ACTVIF                 0x04
#define _TRNIF                  0x08
#define _IDLEIF                 0x10
#define _STALLIF                0x20
#define _SOFIF                  0x40

//==============================================================================


//==============================================================================
//        UEIE Bits

extern __at(0x0F66) __sfr UEIE;

typedef struct
  {
  unsigned PIDEE                : 1;
  unsigned CRC5EE               : 1;
  unsigned CRC16EE              : 1;
  unsigned DFN8EE               : 1;
  unsigned BTOEE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEE                : 1;
  } __UEIEbits_t;

extern __at(0x0F66) volatile __UEIEbits_t UEIEbits;

#define _PIDEE                  0x01
#define _CRC5EE                 0x02
#define _CRC16EE                0x04
#define _DFN8EE                 0x08
#define _BTOEE                  0x10
#define _BTSEE                  0x80

//==============================================================================


//==============================================================================
//        UEIR Bits

extern __at(0x0F67) __sfr UEIR;

typedef struct
  {
  unsigned PIDEF                : 1;
  unsigned CRC5EF               : 1;
  unsigned CRC16EF              : 1;
  unsigned DFN8EF               : 1;
  unsigned BTOEF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BTSEF                : 1;
  } __UEIRbits_t;

extern __at(0x0F67) volatile __UEIRbits_t UEIRbits;

#define _PIDEF                  0x01
#define _CRC5EF                 0x02
#define _CRC16EF                0x04
#define _DFN8EF                 0x08
#define _BTOEF                  0x10
#define _BTSEF                  0x80

//==============================================================================

extern __at(0x0F68) __sfr UFRM;

//==============================================================================
//        UFRML Bits

extern __at(0x0F68) __sfr UFRML;

typedef struct
  {
  unsigned FRM0                 : 1;
  unsigned FRM1                 : 1;
  unsigned FRM2                 : 1;
  unsigned FRM3                 : 1;
  unsigned FRM4                 : 1;
  unsigned FRM5                 : 1;
  unsigned FRM6                 : 1;
  unsigned FRM7                 : 1;
  } __UFRMLbits_t;

extern __at(0x0F68) volatile __UFRMLbits_t UFRMLbits;

#define _FRM0                   0x01
#define _FRM1                   0x02
#define _FRM2                   0x04
#define _FRM3                   0x08
#define _FRM4                   0x10
#define _FRM5                   0x20
#define _FRM6                   0x40
#define _FRM7                   0x80

//==============================================================================


//==============================================================================
//        UFRMH Bits

extern __at(0x0F69) __sfr UFRMH;

typedef struct
  {
  unsigned FRM8                 : 1;
  unsigned FRM9                 : 1;
  unsigned FRM10                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UFRMHbits_t;

extern __at(0x0F69) volatile __UFRMHbits_t UFRMHbits;

#define _FRM8                   0x01
#define _FRM9                   0x02
#define _FRM10                  0x04

//==============================================================================


//==============================================================================
//        UEP0 Bits

extern __at(0x0F6A) __sfr UEP0;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP0bits_t;

extern __at(0x0F6A) volatile __UEP0bits_t UEP0bits;

#define _EPSTALL                0x01
#define _EPINEN                 0x02
#define _EPOUTEN                0x04
#define _EPCONDIS               0x08
#define _EPHSHK                 0x10

//==============================================================================


//==============================================================================
//        UEP1 Bits

extern __at(0x0F6B) __sfr UEP1;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP1bits_t;

extern __at(0x0F6B) volatile __UEP1bits_t UEP1bits;

#define _UEP1_EPSTALL           0x01
#define _UEP1_EPINEN            0x02
#define _UEP1_EPOUTEN           0x04
#define _UEP1_EPCONDIS          0x08
#define _UEP1_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP2 Bits

extern __at(0x0F6C) __sfr UEP2;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP2bits_t;

extern __at(0x0F6C) volatile __UEP2bits_t UEP2bits;

#define _UEP2_EPSTALL           0x01
#define _UEP2_EPINEN            0x02
#define _UEP2_EPOUTEN           0x04
#define _UEP2_EPCONDIS          0x08
#define _UEP2_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP3 Bits

extern __at(0x0F6D) __sfr UEP3;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP3bits_t;

extern __at(0x0F6D) volatile __UEP3bits_t UEP3bits;

#define _UEP3_EPSTALL           0x01
#define _UEP3_EPINEN            0x02
#define _UEP3_EPOUTEN           0x04
#define _UEP3_EPCONDIS          0x08
#define _UEP3_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP4 Bits

extern __at(0x0F6E) __sfr UEP4;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP4bits_t;

extern __at(0x0F6E) volatile __UEP4bits_t UEP4bits;

#define _UEP4_EPSTALL           0x01
#define _UEP4_EPINEN            0x02
#define _UEP4_EPOUTEN           0x04
#define _UEP4_EPCONDIS          0x08
#define _UEP4_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP5 Bits

extern __at(0x0F6F) __sfr UEP5;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP5bits_t;

extern __at(0x0F6F) volatile __UEP5bits_t UEP5bits;

#define _UEP5_EPSTALL           0x01
#define _UEP5_EPINEN            0x02
#define _UEP5_EPOUTEN           0x04
#define _UEP5_EPCONDIS          0x08
#define _UEP5_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP6 Bits

extern __at(0x0F70) __sfr UEP6;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP6bits_t;

extern __at(0x0F70) volatile __UEP6bits_t UEP6bits;

#define _UEP6_EPSTALL           0x01
#define _UEP6_EPINEN            0x02
#define _UEP6_EPOUTEN           0x04
#define _UEP6_EPCONDIS          0x08
#define _UEP6_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP7 Bits

extern __at(0x0F71) __sfr UEP7;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP7bits_t;

extern __at(0x0F71) volatile __UEP7bits_t UEP7bits;

#define _UEP7_EPSTALL           0x01
#define _UEP7_EPINEN            0x02
#define _UEP7_EPOUTEN           0x04
#define _UEP7_EPCONDIS          0x08
#define _UEP7_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP8 Bits

extern __at(0x0F72) __sfr UEP8;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP8bits_t;

extern __at(0x0F72) volatile __UEP8bits_t UEP8bits;

#define _UEP8_EPSTALL           0x01
#define _UEP8_EPINEN            0x02
#define _UEP8_EPOUTEN           0x04
#define _UEP8_EPCONDIS          0x08
#define _UEP8_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP9 Bits

extern __at(0x0F73) __sfr UEP9;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP9bits_t;

extern __at(0x0F73) volatile __UEP9bits_t UEP9bits;

#define _UEP9_EPSTALL           0x01
#define _UEP9_EPINEN            0x02
#define _UEP9_EPOUTEN           0x04
#define _UEP9_EPCONDIS          0x08
#define _UEP9_EPHSHK            0x10

//==============================================================================


//==============================================================================
//        UEP10 Bits

extern __at(0x0F74) __sfr UEP10;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP10bits_t;

extern __at(0x0F74) volatile __UEP10bits_t UEP10bits;

#define _UEP10_EPSTALL          0x01
#define _UEP10_EPINEN           0x02
#define _UEP10_EPOUTEN          0x04
#define _UEP10_EPCONDIS         0x08
#define _UEP10_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP11 Bits

extern __at(0x0F75) __sfr UEP11;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP11bits_t;

extern __at(0x0F75) volatile __UEP11bits_t UEP11bits;

#define _UEP11_EPSTALL          0x01
#define _UEP11_EPINEN           0x02
#define _UEP11_EPOUTEN          0x04
#define _UEP11_EPCONDIS         0x08
#define _UEP11_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP12 Bits

extern __at(0x0F76) __sfr UEP12;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP12bits_t;

extern __at(0x0F76) volatile __UEP12bits_t UEP12bits;

#define _UEP12_EPSTALL          0x01
#define _UEP12_EPINEN           0x02
#define _UEP12_EPOUTEN          0x04
#define _UEP12_EPCONDIS         0x08
#define _UEP12_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP13 Bits

extern __at(0x0F77) __sfr UEP13;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP13bits_t;

extern __at(0x0F77) volatile __UEP13bits_t UEP13bits;

#define _UEP13_EPSTALL          0x01
#define _UEP13_EPINEN           0x02
#define _UEP13_EPOUTEN          0x04
#define _UEP13_EPCONDIS         0x08
#define _UEP13_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP14 Bits

extern __at(0x0F78) __sfr UEP14;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP14bits_t;

extern __at(0x0F78) volatile __UEP14bits_t UEP14bits;

#define _UEP14_EPSTALL          0x01
#define _UEP14_EPINEN           0x02
#define _UEP14_EPOUTEN          0x04
#define _UEP14_EPCONDIS         0x08
#define _UEP14_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        UEP15 Bits

extern __at(0x0F79) __sfr UEP15;

typedef struct
  {
  unsigned EPSTALL              : 1;
  unsigned EPINEN               : 1;
  unsigned EPOUTEN              : 1;
  unsigned EPCONDIS             : 1;
  unsigned EPHSHK               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __UEP15bits_t;

extern __at(0x0F79) volatile __UEP15bits_t UEP15bits;

#define _UEP15_EPSTALL          0x01
#define _UEP15_EPINEN           0x02
#define _UEP15_EPOUTEN          0x04
#define _UEP15_EPCONDIS         0x08
#define _UEP15_EPHSHK           0x10

//==============================================================================


//==============================================================================
//        SLRCON Bits

extern __at(0x0F7A) __sfr SLRCON;

typedef struct
  {
  unsigned SLRA                 : 1;
  unsigned SLRB                 : 1;
  unsigned SLRC                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __SLRCONbits_t;

extern __at(0x0F7A) volatile __SLRCONbits_t SLRCONbits;

#define _SLRA                   0x01
#define _SLRB                   0x02
#define _SLRC                   0x04

//==============================================================================


//==============================================================================
//        VREFCON2 Bits

extern __at(0x0F7B) __sfr VREFCON2;

typedef union
  {
  struct
    {
    unsigned DACR0              : 1;
    unsigned DACR1              : 1;
    unsigned DACR2              : 1;
    unsigned DACR3              : 1;
    unsigned DACR4              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned DACR               : 5;
    unsigned                    : 3;
    };
  } __VREFCON2bits_t;

extern __at(0x0F7B) volatile __VREFCON2bits_t VREFCON2bits;

#define _DACR0                  0x01
#define _DACR1                  0x02
#define _DACR2                  0x04
#define _DACR3                  0x08
#define _DACR4                  0x10

//==============================================================================


//==============================================================================
//        VREFCON1 Bits

extern __at(0x0F7C) __sfr VREFCON1;

typedef union
  {
  struct
    {
    unsigned DACNSS             : 1;
    unsigned                    : 1;
    unsigned DACPSS0            : 1;
    unsigned DACPSS1            : 1;
    unsigned                    : 1;
    unsigned DACOE              : 1;
    unsigned DACLPS             : 1;
    unsigned DACEN              : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned DACPSS             : 2;
    unsigned                    : 4;
    };
  } __VREFCON1bits_t;

extern __at(0x0F7C) volatile __VREFCON1bits_t VREFCON1bits;

#define _DACNSS                 0x01
#define _DACPSS0                0x04
#define _DACPSS1                0x08
#define _DACOE                  0x20
#define _DACLPS                 0x40
#define _DACEN                  0x80

//==============================================================================


//==============================================================================
//        VREFCON0 Bits

extern __at(0x0F7D) __sfr VREFCON0;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRS0              : 1;
    unsigned FVRS1              : 1;
    unsigned FVRST              : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned FVRS               : 2;
    unsigned                    : 2;
    };
  } __VREFCON0bits_t;

extern __at(0x0F7D) volatile __VREFCON0bits_t VREFCON0bits;

#define _TSRNG                  0x04
#define _TSEN                   0x08
#define _FVRS0                  0x10
#define _FVRS1                  0x20
#define _FVRST                  0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        PMD0 Bits

extern __at(0x0F7E) __sfr PMD0;

typedef union
  {
  struct
    {
    unsigned TMR1MD             : 1;
    unsigned TMR2MD             : 1;
    unsigned TMR3MD             : 1;
    unsigned                    : 1;
    unsigned ACTMD              : 1;
    unsigned USBMD              : 1;
    unsigned UARTMD             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STMD               : 1;
    unsigned                    : 1;
    unsigned UART1MD            : 1;
    unsigned                    : 1;
    };
  } __PMD0bits_t;

extern __at(0x0F7E) volatile __PMD0bits_t PMD0bits;

#define _TMR1MD                 0x01
#define _TMR2MD                 0x02
#define _TMR3MD                 0x04
#define _ACTMD                  0x10
#define _STMD                   0x10
#define _USBMD                  0x20
#define _UARTMD                 0x40
#define _UART1MD                0x40

//==============================================================================


//==============================================================================
//        PMD1 Bits

extern __at(0x0F7F) __sfr PMD1;

typedef union
  {
  struct
    {
    unsigned CCP1MD             : 1;
    unsigned CCP2MD             : 1;
    unsigned ADCMD              : 1;
    unsigned CMP1MD             : 1;
    unsigned CMP2MD             : 1;
    unsigned CTMUMD             : 1;
    unsigned MSSPMD             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1MD             : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned MSSP1MD            : 1;
    unsigned                    : 1;
    };
  } __PMD1bits_t;

extern __at(0x0F7F) volatile __PMD1bits_t PMD1bits;

#define _CCP1MD                 0x01
#define _CCP2MD                 0x02
#define _ADCMD                  0x04
#define _CMP1MD                 0x08
#define _CMP2MD                 0x10
#define _CTMUMD                 0x20
#define _MSSPMD                 0x40
#define _SSP1MD                 0x40
#define _MSSP1MD                0x40

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x0F80) __sfr PORTA;

typedef union
  {
  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };

  struct
    {
    unsigned AN0                : 1;
    unsigned AN1                : 1;
    unsigned AN2                : 1;
    unsigned AN3                : 1;
    unsigned T0CKI              : 1;
    unsigned AN4                : 1;
    unsigned OSC2               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned VREFM              : 1;
    unsigned VREFP              : 1;
    unsigned                    : 1;
    unsigned LVDIN              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned HLVDIN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PORTAbits_t;

extern __at(0x0F80) volatile __PORTAbits_t PORTAbits;

#define _PORTA_RA0              0x01
#define _PORTA_AN0              0x01
#define _PORTA_RA1              0x02
#define _PORTA_AN1              0x02
#define _PORTA_RA2              0x04
#define _PORTA_AN2              0x04
#define _PORTA_VREFM            0x04
#define _PORTA_RA3              0x08
#define _PORTA_AN3              0x08
#define _PORTA_VREFP            0x08
#define _PORTA_RA4              0x10
#define _PORTA_T0CKI            0x10
#define _PORTA_RA5              0x20
#define _PORTA_AN4              0x20
#define _PORTA_LVDIN            0x20
#define _PORTA_HLVDIN           0x20
#define _PORTA_RA6              0x40
#define _PORTA_OSC2             0x40
#define _PORTA_RA7              0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x0F81) __sfr PORTB;

typedef union
  {
  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };

  struct
    {
    unsigned INT0               : 1;
    unsigned INT1               : 1;
    unsigned INT2               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PGM                : 1;
    unsigned PGC                : 1;
    unsigned PGD                : 1;
    };

  struct
    {
    unsigned INT                : 3;
    unsigned                    : 5;
    };
  } __PORTBbits_t;

extern __at(0x0F81) volatile __PORTBbits_t PORTBbits;

#define _PORTB_RB0              0x01
#define _PORTB_INT0             0x01
#define _PORTB_RB1              0x02
#define _PORTB_INT1             0x02
#define _PORTB_RB2              0x04
#define _PORTB_INT2             0x04
#define _PORTB_RB3              0x08
#define _PORTB_RB4              0x10
#define _PORTB_RB5              0x20
#define _PORTB_PGM              0x20
#define _PORTB_RB6              0x40
#define _PORTB_PGC              0x40
#define _PORTB_RB7              0x80
#define _PORTB_PGD              0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x0F82) __sfr PORTC;

typedef union
  {
  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned RC4                : 1;
    unsigned RC5                : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };

  struct
    {
    unsigned T1OSO              : 1;
    unsigned T1OSI              : 1;
    unsigned CCP1               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TX                 : 1;
    unsigned RX                 : 1;
    };

  struct
    {
    unsigned T13CKI             : 1;
    unsigned                    : 1;
    unsigned P1A                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CK                 : 1;
    unsigned                    : 1;
    };
  } __PORTCbits_t;

extern __at(0x0F82) volatile __PORTCbits_t PORTCbits;

#define _PORTC_RC0              0x01
#define _PORTC_T1OSO            0x01
#define _PORTC_T13CKI           0x01
#define _PORTC_RC1              0x02
#define _PORTC_T1OSI            0x02
#define _PORTC_RC2              0x04
#define _PORTC_CCP1             0x04
#define _PORTC_P1A              0x04
#define _PORTC_RC4              0x10
#define _PORTC_RC5              0x20
#define _PORTC_RC6              0x40
#define _PORTC_TX               0x40
#define _PORTC_CK               0x40
#define _PORTC_RC7              0x80
#define _PORTC_RX               0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0F84) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0F84) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x0F85) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x0F85) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        IOCB Bits

extern __at(0x0F86) __sfr IOCB;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned IOCB4                : 1;
  unsigned IOCB5                : 1;
  unsigned IOCB6                : 1;
  unsigned IOCB7                : 1;
  } __IOCBbits_t;

extern __at(0x0F86) volatile __IOCBbits_t IOCBbits;

#define _IOCB4                  0x10
#define _IOCB5                  0x20
#define _IOCB6                  0x40
#define _IOCB7                  0x80

//==============================================================================


//==============================================================================
//        IOCC Bits

extern __at(0x0F87) __sfr IOCC;

typedef struct
  {
  unsigned IOCC0                : 1;
  unsigned IOCC1                : 1;
  unsigned IOCC2                : 1;
  unsigned                      : 1;
  unsigned IOCC4                : 1;
  unsigned IOCC5                : 1;
  unsigned IOCC6                : 1;
  unsigned IOCC7                : 1;
  } __IOCCbits_t;

extern __at(0x0F87) volatile __IOCCbits_t IOCCbits;

#define _IOCC0                  0x01
#define _IOCC1                  0x02
#define _IOCC2                  0x04
#define _IOCC4                  0x10
#define _IOCC5                  0x20
#define _IOCC6                  0x40
#define _IOCC7                  0x80

//==============================================================================


//==============================================================================
//        CTMUICON Bits

extern __at(0x0F88) __sfr CTMUICON;

typedef union
  {
  struct
    {
    unsigned IRNG0              : 1;
    unsigned IRNG1              : 1;
    unsigned ITRIM0             : 1;
    unsigned ITRIM1             : 1;
    unsigned ITRIM2             : 1;
    unsigned ITRIM3             : 1;
    unsigned ITRIM4             : 1;
    unsigned ITRIM5             : 1;
    };

  struct
    {
    unsigned IRNG               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned ITRIM              : 6;
    };
  } __CTMUICONbits_t;

extern __at(0x0F88) volatile __CTMUICONbits_t CTMUICONbits;

#define _IRNG0                  0x01
#define _IRNG1                  0x02
#define _ITRIM0                 0x04
#define _ITRIM1                 0x08
#define _ITRIM2                 0x10
#define _ITRIM3                 0x20
#define _ITRIM4                 0x40
#define _ITRIM5                 0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x0F89) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x0F89) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x0F8A) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x0F8A) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x0F8B) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned                      : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x0F8B) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        CTMUCON1 Bits

extern __at(0x0F8E) __sfr CTMUCON1;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCON1bits_t;

extern __at(0x0F8E) volatile __CTMUCON1bits_t CTMUCON1bits;

#define _EDG1STAT               0x01
#define _EDG2STAT               0x02
#define _EDG1SEL0               0x04
#define _EDG1SEL1               0x08
#define _EDG1POL                0x10
#define _EDG2SEL0               0x20
#define _EDG2SEL1               0x40
#define _EDG2POL                0x80

//==============================================================================


//==============================================================================
//        CTMUCONL Bits

extern __at(0x0F8E) __sfr CTMUCONL;

typedef union
  {
  struct
    {
    unsigned EDG1STAT           : 1;
    unsigned EDG2STAT           : 1;
    unsigned EDG1SEL0           : 1;
    unsigned EDG1SEL1           : 1;
    unsigned EDG1POL            : 1;
    unsigned EDG2SEL0           : 1;
    unsigned EDG2SEL1           : 1;
    unsigned EDG2POL            : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned EDG1SEL            : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 5;
    unsigned EDG2SEL            : 2;
    unsigned                    : 1;
    };
  } __CTMUCONLbits_t;

extern __at(0x0F8E) volatile __CTMUCONLbits_t CTMUCONLbits;

#define _CTMUCONL_EDG1STAT      0x01
#define _CTMUCONL_EDG2STAT      0x02
#define _CTMUCONL_EDG1SEL0      0x04
#define _CTMUCONL_EDG1SEL1      0x08
#define _CTMUCONL_EDG1POL       0x10
#define _CTMUCONL_EDG2SEL0      0x20
#define _CTMUCONL_EDG2SEL1      0x40
#define _CTMUCONL_EDG2POL       0x80

//==============================================================================


//==============================================================================
//        CTMUCON0 Bits

extern __at(0x0F8F) __sfr CTMUCON0;

typedef union
  {
  struct
    {
    unsigned CTTRIG             : 1;
    unsigned IDISSEN            : 1;
    unsigned EDGSEQEN           : 1;
    unsigned EDGEN              : 1;
    unsigned TGEN               : 1;
    unsigned CTMUSIDL           : 1;
    unsigned                    : 1;
    unsigned CTMUEN             : 1;
    };

  struct
    {
    unsigned TRIGEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SIDL               : 1;
    unsigned                    : 1;
    unsigned ON                 : 1;
    };
  } __CTMUCON0bits_t;

extern __at(0x0F8F) volatile __CTMUCON0bits_t CTMUCON0bits;

#define _CTTRIG                 0x01
#define _TRIGEN                 0x01
#define _IDISSEN                0x02
#define _EDGSEQEN               0x04
#define _EDGEN                  0x08
#define _TGEN                   0x10
#define _CTMUSIDL               0x20
#define _SIDL                   0x20
#define _CTMUEN                 0x80
#define _ON                     0x80

//==============================================================================


//==============================================================================
//        CTMUCONH Bits

extern __at(0x0F8F) __sfr CTMUCONH;

typedef union
  {
  struct
    {
    unsigned CTTRIG             : 1;
    unsigned IDISSEN            : 1;
    unsigned EDGSEQEN           : 1;
    unsigned EDGEN              : 1;
    unsigned TGEN               : 1;
    unsigned CTMUSIDL           : 1;
    unsigned                    : 1;
    unsigned CTMUEN             : 1;
    };

  struct
    {
    unsigned TRIGEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SIDL               : 1;
    unsigned                    : 1;
    unsigned ON                 : 1;
    };
  } __CTMUCONHbits_t;

extern __at(0x0F8F) volatile __CTMUCONHbits_t CTMUCONHbits;

#define _CTMUCONH_CTTRIG        0x01
#define _CTMUCONH_TRIGEN        0x01
#define _CTMUCONH_IDISSEN       0x02
#define _CTMUCONH_EDGSEQEN      0x04
#define _CTMUCONH_EDGEN         0x08
#define _CTMUCONH_TGEN          0x10
#define _CTMUCONH_CTMUSIDL      0x20
#define _CTMUCONH_SIDL          0x20
#define _CTMUCONH_CTMUEN        0x80
#define _CTMUCONH_ON            0x80

//==============================================================================

extern __at(0x0F90) __sfr CCPR2;
extern __at(0x0F90) __sfr CCPR2L;
extern __at(0x0F91) __sfr CCPR2H;

//==============================================================================
//        DDRA Bits

extern __at(0x0F92) __sfr DDRA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __DDRAbits_t;

extern __at(0x0F92) volatile __DDRAbits_t DDRAbits;

#define _TRISA0                 0x01
#define _RA0                    0x01
#define _TRISA1                 0x02
#define _RA1                    0x02
#define _TRISA2                 0x04
#define _RA2                    0x04
#define _TRISA3                 0x08
#define _RA3                    0x08
#define _TRISA4                 0x10
#define _RA4                    0x10
#define _TRISA5                 0x20
#define _RA5                    0x20
#define _TRISA6                 0x40
#define _RA6                    0x40
#define _TRISA7                 0x80
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x0F92) __sfr TRISA;

typedef union
  {
  struct
    {
    unsigned TRISA0             : 1;
    unsigned TRISA1             : 1;
    unsigned TRISA2             : 1;
    unsigned TRISA3             : 1;
    unsigned TRISA4             : 1;
    unsigned TRISA5             : 1;
    unsigned TRISA6             : 1;
    unsigned TRISA7             : 1;
    };

  struct
    {
    unsigned RA0                : 1;
    unsigned RA1                : 1;
    unsigned RA2                : 1;
    unsigned RA3                : 1;
    unsigned RA4                : 1;
    unsigned RA5                : 1;
    unsigned RA6                : 1;
    unsigned RA7                : 1;
    };
  } __TRISAbits_t;

extern __at(0x0F92) volatile __TRISAbits_t TRISAbits;

#define _TRISA_TRISA0           0x01
#define _TRISA_RA0              0x01
#define _TRISA_TRISA1           0x02
#define _TRISA_RA1              0x02
#define _TRISA_TRISA2           0x04
#define _TRISA_RA2              0x04
#define _TRISA_TRISA3           0x08
#define _TRISA_RA3              0x08
#define _TRISA_TRISA4           0x10
#define _TRISA_RA4              0x10
#define _TRISA_TRISA5           0x20
#define _TRISA_RA5              0x20
#define _TRISA_TRISA6           0x40
#define _TRISA_RA6              0x40
#define _TRISA_TRISA7           0x80
#define _TRISA_RA7              0x80

//==============================================================================


//==============================================================================
//        DDRB Bits

extern __at(0x0F93) __sfr DDRB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __DDRBbits_t;

extern __at(0x0F93) volatile __DDRBbits_t DDRBbits;

#define _TRISB0                 0x01
#define _RB0                    0x01
#define _TRISB1                 0x02
#define _RB1                    0x02
#define _TRISB2                 0x04
#define _RB2                    0x04
#define _TRISB3                 0x08
#define _RB3                    0x08
#define _TRISB4                 0x10
#define _RB4                    0x10
#define _TRISB5                 0x20
#define _RB5                    0x20
#define _TRISB6                 0x40
#define _RB6                    0x40
#define _TRISB7                 0x80
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x0F93) __sfr TRISB;

typedef union
  {
  struct
    {
    unsigned TRISB0             : 1;
    unsigned TRISB1             : 1;
    unsigned TRISB2             : 1;
    unsigned TRISB3             : 1;
    unsigned TRISB4             : 1;
    unsigned TRISB5             : 1;
    unsigned TRISB6             : 1;
    unsigned TRISB7             : 1;
    };

  struct
    {
    unsigned RB0                : 1;
    unsigned RB1                : 1;
    unsigned RB2                : 1;
    unsigned RB3                : 1;
    unsigned RB4                : 1;
    unsigned RB5                : 1;
    unsigned RB6                : 1;
    unsigned RB7                : 1;
    };
  } __TRISBbits_t;

extern __at(0x0F93) volatile __TRISBbits_t TRISBbits;

#define _TRISB_TRISB0           0x01
#define _TRISB_RB0              0x01
#define _TRISB_TRISB1           0x02
#define _TRISB_RB1              0x02
#define _TRISB_TRISB2           0x04
#define _TRISB_RB2              0x04
#define _TRISB_TRISB3           0x08
#define _TRISB_RB3              0x08
#define _TRISB_TRISB4           0x10
#define _TRISB_RB4              0x10
#define _TRISB_TRISB5           0x20
#define _TRISB_RB5              0x20
#define _TRISB_TRISB6           0x40
#define _TRISB_RB6              0x40
#define _TRISB_TRISB7           0x80
#define _TRISB_RB7              0x80

//==============================================================================


//==============================================================================
//        DDRC Bits

extern __at(0x0F94) __sfr DDRC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned                    : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __DDRCbits_t;

extern __at(0x0F94) volatile __DDRCbits_t DDRCbits;

#define _TRISC0                 0x01
#define _RC0                    0x01
#define _TRISC1                 0x02
#define _RC1                    0x02
#define _TRISC2                 0x04
#define _RC2                    0x04
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _RC6                    0x40
#define _TRISC7                 0x80
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x0F94) __sfr TRISC;

typedef union
  {
  struct
    {
    unsigned TRISC0             : 1;
    unsigned TRISC1             : 1;
    unsigned TRISC2             : 1;
    unsigned                    : 1;
    unsigned TRISC4             : 1;
    unsigned TRISC5             : 1;
    unsigned TRISC6             : 1;
    unsigned TRISC7             : 1;
    };

  struct
    {
    unsigned RC0                : 1;
    unsigned RC1                : 1;
    unsigned RC2                : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RC6                : 1;
    unsigned RC7                : 1;
    };
  } __TRISCbits_t;

extern __at(0x0F94) volatile __TRISCbits_t TRISCbits;

#define _TRISC_TRISC0           0x01
#define _TRISC_RC0              0x01
#define _TRISC_TRISC1           0x02
#define _TRISC_RC1              0x02
#define _TRISC_TRISC2           0x04
#define _TRISC_RC2              0x04
#define _TRISC_TRISC4           0x10
#define _TRISC_TRISC5           0x20
#define _TRISC_TRISC6           0x40
#define _TRISC_RC6              0x40
#define _TRISC_TRISC7           0x80
#define _TRISC_RC7              0x80

//==============================================================================


//==============================================================================
//        CCP2CON Bits

extern __at(0x0F97) __sfr CCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __CCP2CONbits_t;

extern __at(0x0F97) volatile __CCP2CONbits_t CCP2CONbits;

#define _CCP2M0                 0x01
#define _CCP2M1                 0x02
#define _CCP2M2                 0x04
#define _CCP2M3                 0x08
#define _DC2B0                  0x10
#define _CCP2Y                  0x10
#define _DC2B1                  0x20
#define _CCP2X                  0x20

//==============================================================================


//==============================================================================
//        ECCP2CON Bits

extern __at(0x0F97) __sfr ECCP2CON;

typedef union
  {
  struct
    {
    unsigned CCP2M0             : 1;
    unsigned CCP2M1             : 1;
    unsigned CCP2M2             : 1;
    unsigned CCP2M3             : 1;
    unsigned DC2B0              : 1;
    unsigned DC2B1              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP2Y              : 1;
    unsigned CCP2X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP2M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC2B               : 2;
    unsigned                    : 2;
    };
  } __ECCP2CONbits_t;

extern __at(0x0F97) volatile __ECCP2CONbits_t ECCP2CONbits;

#define _ECCP2CON_CCP2M0        0x01
#define _ECCP2CON_CCP2M1        0x02
#define _ECCP2CON_CCP2M2        0x04
#define _ECCP2CON_CCP2M3        0x08
#define _ECCP2CON_DC2B0         0x10
#define _ECCP2CON_CCP2Y         0x10
#define _ECCP2CON_DC2B1         0x20
#define _ECCP2CON_CCP2X         0x20

//==============================================================================


//==============================================================================
//        CM1CON0 Bits

extern __at(0x0F98) __sfr CM1CON0;

typedef union
  {
  struct
    {
    unsigned C1CH0              : 1;
    unsigned C1CH1              : 1;
    unsigned C1R                : 1;
    unsigned C1SP               : 1;
    unsigned C1POL              : 1;
    unsigned C1OE               : 1;
    unsigned C1OUT              : 1;
    unsigned C1ON               : 1;
    };

  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned                    : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned COUT1              : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned C1CH               : 2;
    unsigned                    : 6;
    };
  } __CM1CON0bits_t;

extern __at(0x0F98) volatile __CM1CON0bits_t CM1CON0bits;

#define _C1CH0                  0x01
#define _CCH0                   0x01
#define _C1CH1                  0x02
#define _CCH1                   0x02
#define _C1R                    0x04
#define _CREF                   0x04
#define _C1SP                   0x08
#define _C1POL                  0x10
#define _CPOL                   0x10
#define _C1OE                   0x20
#define _COE                    0x20
#define _C1OUT                  0x40
#define _COUT1                  0x40
#define _C1ON                   0x80
#define _CON                    0x80

//==============================================================================


//==============================================================================
//        CM2CON0 Bits

extern __at(0x0F99) __sfr CM2CON0;

typedef union
  {
  struct
    {
    unsigned C2CH0              : 1;
    unsigned C2CH1              : 1;
    unsigned C2R                : 1;
    unsigned C2SP               : 1;
    unsigned C2POL              : 1;
    unsigned C2OE               : 1;
    unsigned C2OUT              : 1;
    unsigned C2ON               : 1;
    };

  struct
    {
    unsigned CCH0               : 1;
    unsigned CCH1               : 1;
    unsigned CREF               : 1;
    unsigned                    : 1;
    unsigned CPOL               : 1;
    unsigned COE                : 1;
    unsigned COUT2              : 1;
    unsigned CON                : 1;
    };

  struct
    {
    unsigned CCH                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned C2CH               : 2;
    unsigned                    : 6;
    };
  } __CM2CON0bits_t;

extern __at(0x0F99) volatile __CM2CON0bits_t CM2CON0bits;

#define _CM2CON0_C2CH0          0x01
#define _CM2CON0_CCH0           0x01
#define _CM2CON0_C2CH1          0x02
#define _CM2CON0_CCH1           0x02
#define _CM2CON0_C2R            0x04
#define _CM2CON0_CREF           0x04
#define _CM2CON0_C2SP           0x08
#define _CM2CON0_C2POL          0x10
#define _CM2CON0_CPOL           0x10
#define _CM2CON0_C2OE           0x20
#define _CM2CON0_COE            0x20
#define _CM2CON0_C2OUT          0x40
#define _CM2CON0_COUT2          0x40
#define _CM2CON0_C2ON           0x80
#define _CM2CON0_CON            0x80

//==============================================================================


//==============================================================================
//        CM2CON1 Bits

extern __at(0x0F9A) __sfr CM2CON1;

typedef struct
  {
  unsigned C2SYNC               : 1;
  unsigned C1SYNC               : 1;
  unsigned C2HYS                : 1;
  unsigned C1HYS                : 1;
  unsigned C2RSEL               : 1;
  unsigned C1RSEL               : 1;
  unsigned MC2OUT               : 1;
  unsigned MC1OUT               : 1;
  } __CM2CON1bits_t;

extern __at(0x0F9A) volatile __CM2CON1bits_t CM2CON1bits;

#define _C2SYNC                 0x01
#define _C1SYNC                 0x02
#define _C2HYS                  0x04
#define _C1HYS                  0x08
#define _C2RSEL                 0x10
#define _C1RSEL                 0x20
#define _MC2OUT                 0x40
#define _MC1OUT                 0x80

//==============================================================================


//==============================================================================
//        OSCTUNE Bits

extern __at(0x0F9B) __sfr OSCTUNE;

typedef union
  {
  struct
    {
    unsigned TUN0               : 1;
    unsigned TUN1               : 1;
    unsigned TUN2               : 1;
    unsigned TUN3               : 1;
    unsigned TUN4               : 1;
    unsigned TUN5               : 1;
    unsigned TUN6               : 1;
    unsigned SPLLMULT           : 1;
    };

  struct
    {
    unsigned TUN                : 7;
    unsigned                    : 1;
    };
  } __OSCTUNEbits_t;

extern __at(0x0F9B) volatile __OSCTUNEbits_t OSCTUNEbits;

#define _TUN0                   0x01
#define _TUN1                   0x02
#define _TUN2                   0x04
#define _TUN3                   0x08
#define _TUN4                   0x10
#define _TUN5                   0x20
#define _TUN6                   0x40
#define _SPLLMULT               0x80

//==============================================================================


//==============================================================================
//        HLVDCON Bits

extern __at(0x0F9C) __sfr HLVDCON;

typedef union
  {
  struct
    {
    unsigned HLVDL0             : 1;
    unsigned HLVDL1             : 1;
    unsigned HLVDL2             : 1;
    unsigned HLVDL3             : 1;
    unsigned HLVDEN             : 1;
    unsigned IRVST              : 1;
    unsigned BGVST              : 1;
    unsigned VDIRMAG            : 1;
    };

  struct
    {
    unsigned HLVDL              : 4;
    unsigned                    : 4;
    };
  } __HLVDCONbits_t;

extern __at(0x0F9C) volatile __HLVDCONbits_t HLVDCONbits;

#define _HLVDL0                 0x01
#define _HLVDL1                 0x02
#define _HLVDL2                 0x04
#define _HLVDL3                 0x08
#define _HLVDEN                 0x10
#define _IRVST                  0x20
#define _BGVST                  0x40
#define _VDIRMAG                0x80

//==============================================================================


//==============================================================================
//        PIE1 Bits

extern __at(0x0F9D) __sfr PIE1;

typedef union
  {
  struct
    {
    unsigned TMR1IE             : 1;
    unsigned TMR2IE             : 1;
    unsigned CCP1IE             : 1;
    unsigned SSPIE              : 1;
    unsigned TXIE               : 1;
    unsigned RCIE               : 1;
    unsigned ADIE               : 1;
    unsigned ACTIE              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1IE             : 1;
    unsigned TX1IE              : 1;
    unsigned RC1IE              : 1;
    unsigned                    : 1;
    unsigned STIE               : 1;
    };
  } __PIE1bits_t;

extern __at(0x0F9D) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TMR2IE                 0x02
#define _CCP1IE                 0x04
#define _SSPIE                  0x08
#define _SSP1IE                 0x08
#define _TXIE                   0x10
#define _TX1IE                  0x10
#define _RCIE                   0x20
#define _RC1IE                  0x20
#define _ADIE                   0x40
#define _ACTIE                  0x80
#define _STIE                   0x80

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0F9E) __sfr PIR1;

typedef union
  {
  struct
    {
    unsigned TMR1IF             : 1;
    unsigned TMR2IF             : 1;
    unsigned CCP1IF             : 1;
    unsigned SSPIF              : 1;
    unsigned TXIF               : 1;
    unsigned RCIF               : 1;
    unsigned ADIF               : 1;
    unsigned ACTIF              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1IF             : 1;
    unsigned TX1IF              : 1;
    unsigned RC1IF              : 1;
    unsigned                    : 1;
    unsigned STIF               : 1;
    };
  } __PIR1bits_t;

extern __at(0x0F9E) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TMR2IF                 0x02
#define _CCP1IF                 0x04
#define _SSPIF                  0x08
#define _SSP1IF                 0x08
#define _TXIF                   0x10
#define _TX1IF                  0x10
#define _RCIF                   0x20
#define _RC1IF                  0x20
#define _ADIF                   0x40
#define _ACTIF                  0x80
#define _STIF                   0x80

//==============================================================================


//==============================================================================
//        IPR1 Bits

extern __at(0x0F9F) __sfr IPR1;

typedef union
  {
  struct
    {
    unsigned TMR1IP             : 1;
    unsigned TMR2IP             : 1;
    unsigned CCP1IP             : 1;
    unsigned SSPIP              : 1;
    unsigned TXIP               : 1;
    unsigned RCIP               : 1;
    unsigned ADIP               : 1;
    unsigned ACTIP              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SSP1IP             : 1;
    unsigned TX1IP              : 1;
    unsigned RC1IP              : 1;
    unsigned                    : 1;
    unsigned STIP               : 1;
    };
  } __IPR1bits_t;

extern __at(0x0F9F) volatile __IPR1bits_t IPR1bits;

#define _TMR1IP                 0x01
#define _TMR2IP                 0x02
#define _CCP1IP                 0x04
#define _SSPIP                  0x08
#define _SSP1IP                 0x08
#define _TXIP                   0x10
#define _TX1IP                  0x10
#define _RCIP                   0x20
#define _RC1IP                  0x20
#define _ADIP                   0x40
#define _ACTIP                  0x80
#define _STIP                   0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0FA0) __sfr PIE2;

typedef union
  {
  struct
    {
    unsigned CCP2IE             : 1;
    unsigned TMR3IE             : 1;
    unsigned HLVDIE             : 1;
    unsigned BCLIE              : 1;
    unsigned EEIE               : 1;
    unsigned C2IE               : 1;
    unsigned C1IE               : 1;
    unsigned OSCFIE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIE              : 1;
    unsigned BCL1IE             : 1;
    unsigned                    : 1;
    unsigned CM2IE              : 1;
    unsigned CM1IE              : 1;
    unsigned                    : 1;
    };
  } __PIE2bits_t;

extern __at(0x0FA0) volatile __PIE2bits_t PIE2bits;

#define _CCP2IE                 0x01
#define _TMR3IE                 0x02
#define _HLVDIE                 0x04
#define _LVDIE                  0x04
#define _BCLIE                  0x08
#define _BCL1IE                 0x08
#define _EEIE                   0x10
#define _C2IE                   0x20
#define _CM2IE                  0x20
#define _C1IE                   0x40
#define _CM1IE                  0x40
#define _OSCFIE                 0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0FA1) __sfr PIR2;

typedef union
  {
  struct
    {
    unsigned CCP2IF             : 1;
    unsigned TMR3IF             : 1;
    unsigned HLVDIF             : 1;
    unsigned BCLIF              : 1;
    unsigned EEIF               : 1;
    unsigned C2IF               : 1;
    unsigned C1IF               : 1;
    unsigned OSCFIF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIF              : 1;
    unsigned BCL1IF             : 1;
    unsigned                    : 1;
    unsigned CM2IF              : 1;
    unsigned CM1IF              : 1;
    unsigned                    : 1;
    };
  } __PIR2bits_t;

extern __at(0x0FA1) volatile __PIR2bits_t PIR2bits;

#define _CCP2IF                 0x01
#define _TMR3IF                 0x02
#define _HLVDIF                 0x04
#define _LVDIF                  0x04
#define _BCLIF                  0x08
#define _BCL1IF                 0x08
#define _EEIF                   0x10
#define _C2IF                   0x20
#define _CM2IF                  0x20
#define _C1IF                   0x40
#define _CM1IF                  0x40
#define _OSCFIF                 0x80

//==============================================================================


//==============================================================================
//        IPR2 Bits

extern __at(0x0FA2) __sfr IPR2;

typedef union
  {
  struct
    {
    unsigned CCP2IP             : 1;
    unsigned TMR3IP             : 1;
    unsigned HLVDIP             : 1;
    unsigned BCLIP              : 1;
    unsigned EEIP               : 1;
    unsigned C2IP               : 1;
    unsigned C1IP               : 1;
    unsigned OSCFIP             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned LVDIP              : 1;
    unsigned BCL1IP             : 1;
    unsigned                    : 1;
    unsigned CM2IP              : 1;
    unsigned CM1IP              : 1;
    unsigned                    : 1;
    };
  } __IPR2bits_t;

extern __at(0x0FA2) volatile __IPR2bits_t IPR2bits;

#define _CCP2IP                 0x01
#define _TMR3IP                 0x02
#define _HLVDIP                 0x04
#define _LVDIP                  0x04
#define _BCLIP                  0x08
#define _BCL1IP                 0x08
#define _EEIP                   0x10
#define _C2IP                   0x20
#define _CM2IP                  0x20
#define _C1IP                   0x40
#define _CM1IP                  0x40
#define _OSCFIP                 0x80

//==============================================================================


//==============================================================================
//        PIE3 Bits

extern __at(0x0FA3) __sfr PIE3;

typedef struct
  {
  unsigned TMR1GIE              : 1;
  unsigned TMR3GIE              : 1;
  unsigned USBIE                : 1;
  unsigned CTMUIE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE3bits_t;

extern __at(0x0FA3) volatile __PIE3bits_t PIE3bits;

#define _TMR1GIE                0x01
#define _TMR3GIE                0x02
#define _USBIE                  0x04
#define _CTMUIE                 0x08

//==============================================================================


//==============================================================================
//        PIR3 Bits

extern __at(0x0FA4) __sfr PIR3;

typedef struct
  {
  unsigned TMR1GIF              : 1;
  unsigned TMR3GIF              : 1;
  unsigned USBIF                : 1;
  unsigned CTMUIF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR3bits_t;

extern __at(0x0FA4) volatile __PIR3bits_t PIR3bits;

#define _TMR1GIF                0x01
#define _TMR3GIF                0x02
#define _USBIF                  0x04
#define _CTMUIF                 0x08

//==============================================================================


//==============================================================================
//        IPR3 Bits

extern __at(0x0FA5) __sfr IPR3;

typedef struct
  {
  unsigned TMR1GIP              : 1;
  unsigned TMR3GIP              : 1;
  unsigned USBIP                : 1;
  unsigned CTMUIP               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __IPR3bits_t;

extern __at(0x0FA5) volatile __IPR3bits_t IPR3bits;

#define _TMR1GIP                0x01
#define _TMR3GIP                0x02
#define _USBIP                  0x04
#define _CTMUIP                 0x08

//==============================================================================


//==============================================================================
//        EECON1 Bits

extern __at(0x0FA6) __sfr EECON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned                      : 1;
  unsigned CFGS                 : 1;
  unsigned EEPGD                : 1;
  } __EECON1bits_t;

extern __at(0x0FA6) volatile __EECON1bits_t EECON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _CFGS                   0x40
#define _EEPGD                  0x80

//==============================================================================

extern __at(0x0FA7) __sfr EECON2;
extern __at(0x0FA8) __sfr EEDATA;
extern __at(0x0FA9) __sfr EEADR;

//==============================================================================
//        RCSTA Bits

extern __at(0x0FAB) __sfr RCSTA;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTAbits_t;

extern __at(0x0FAB) volatile __RCSTAbits_t RCSTAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _ADEN                   0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x0FAB) __sfr RCSTA1;

typedef union
  {
  struct
    {
    unsigned RX9D               : 1;
    unsigned OERR               : 1;
    unsigned FERR               : 1;
    unsigned ADDEN              : 1;
    unsigned CREN               : 1;
    unsigned SREN               : 1;
    unsigned RX9                : 1;
    unsigned SPEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADEN               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCSTA1bits_t;

extern __at(0x0FAB) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_ADEN            0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x0FAC) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x0FAC) volatile __TXSTAbits_t TXSTAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x0FAC) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x0FAC) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================

extern __at(0x0FAD) __sfr TXREG;
extern __at(0x0FAD) __sfr TXREG1;
extern __at(0x0FAE) __sfr RCREG;
extern __at(0x0FAE) __sfr RCREG1;

//==============================================================================
//        SPBRG Bits

extern __at(0x0FAF) __sfr SPBRG;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRGbits_t;

extern __at(0x0FAF) volatile __SPBRGbits_t SPBRGbits;

#define _BRG0                   0x01
#define _BRG1                   0x02
#define _BRG2                   0x04
#define _BRG3                   0x08
#define _BRG4                   0x10
#define _BRG5                   0x20
#define _BRG6                   0x40
#define _BRG7                   0x80

//==============================================================================


//==============================================================================
//        SPBRG1 Bits

extern __at(0x0FAF) __sfr SPBRG1;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRG1bits_t;

extern __at(0x0FAF) volatile __SPBRG1bits_t SPBRG1bits;

#define _SPBRG1_BRG0            0x01
#define _SPBRG1_BRG1            0x02
#define _SPBRG1_BRG2            0x04
#define _SPBRG1_BRG3            0x08
#define _SPBRG1_BRG4            0x10
#define _SPBRG1_BRG5            0x20
#define _SPBRG1_BRG6            0x40
#define _SPBRG1_BRG7            0x80

//==============================================================================


//==============================================================================
//        SPBRGH Bits

extern __at(0x0FB0) __sfr SPBRGH;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SPBRGHbits_t;

extern __at(0x0FB0) volatile __SPBRGHbits_t SPBRGHbits;

#define _BRG8                   0x01
#define _BRG9                   0x02
#define _BRG10                  0x04
#define _BRG11                  0x08
#define _BRG12                  0x10
#define _BRG13                  0x20
#define _BRG14                  0x40
#define _BRG15                  0x80

//==============================================================================


//==============================================================================
//        SPBRGH1 Bits

extern __at(0x0FB0) __sfr SPBRGH1;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SPBRGH1bits_t;

extern __at(0x0FB0) volatile __SPBRGH1bits_t SPBRGH1bits;

#define _SPBRGH1_BRG8           0x01
#define _SPBRGH1_BRG9           0x02
#define _SPBRGH1_BRG10          0x04
#define _SPBRGH1_BRG11          0x08
#define _SPBRGH1_BRG12          0x10
#define _SPBRGH1_BRG13          0x20
#define _SPBRGH1_BRG14          0x40
#define _SPBRGH1_BRG15          0x80

//==============================================================================


//==============================================================================
//        T3CON Bits

extern __at(0x0FB1) __sfr T3CON;

typedef union
  {
  struct
    {
    unsigned TMR3ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T3SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T3CKPS0            : 1;
    unsigned T3CKPS1            : 1;
    unsigned TMR3CS0            : 1;
    unsigned TMR3CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned T3RD16             : 1;
    unsigned T3SYNC             : 1;
    unsigned T3SOSCEN           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T3CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR3CS             : 2;
    };
  } __T3CONbits_t;

extern __at(0x0FB1) volatile __T3CONbits_t T3CONbits;

#define _T3CON_TMR3ON           0x01
#define _T3CON_RD16             0x02
#define _T3CON_T3RD16           0x02
#define _T3CON_NOT_T3SYNC       0x04
#define _T3CON_T3SYNC           0x04
#define _T3CON_SOSCEN           0x08
#define _T3CON_T3SOSCEN         0x08
#define _T3CON_T3OSCEN          0x08
#define _T3CON_T3CKPS0          0x10
#define _T3CON_T3CKPS1          0x20
#define _T3CON_TMR3CS0          0x40
#define _T3CON_TMR3CS1          0x80

//==============================================================================

extern __at(0x0FB2) __sfr TMR3;
extern __at(0x0FB2) __sfr TMR3L;
extern __at(0x0FB3) __sfr TMR3H;

//==============================================================================
//        T3GCON Bits

extern __at(0x0FB4) __sfr T3GCON;

typedef union
  {
  struct
    {
    unsigned T3GSS0             : 1;
    unsigned T3GSS1             : 1;
    unsigned T3GVAL             : 1;
    unsigned T3GGO_NOT_T3DONE   : 1;
    unsigned T3GSPM             : 1;
    unsigned T3GTM              : 1;
    unsigned T3GPOL             : 1;
    unsigned TMR3GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T3DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3DONE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T3GGO_NOT_DONE     : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T3GSS              : 2;
    unsigned                    : 6;
    };
  } __T3GCONbits_t;

extern __at(0x0FB4) volatile __T3GCONbits_t T3GCONbits;

#define _T3GSS0                 0x01
#define _T3GSS1                 0x02
#define _T3GVAL                 0x04
#define _T3GGO_NOT_T3DONE       0x08
#define _T3GGO                  0x08
#define _NOT_T3DONE             0x08
#define _T3DONE                 0x08
#define _T3GGO_NOT_DONE         0x08
#define _T3GSPM                 0x10
#define _T3GTM                  0x20
#define _T3GPOL                 0x40
#define _TMR3GE                 0x80

//==============================================================================


//==============================================================================
//        ACTCON Bits

extern __at(0x0FB5) __sfr ACTCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ACTORS             : 1;
    unsigned                    : 1;
    unsigned ACTLOCK            : 1;
    unsigned ACTSRC             : 1;
    unsigned                    : 1;
    unsigned ACTUD              : 1;
    unsigned ACTEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned STOR               : 1;
    unsigned                    : 1;
    unsigned STLOCK             : 1;
    unsigned STSRC              : 1;
    unsigned                    : 1;
    unsigned STUD               : 1;
    unsigned STEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ACTOR              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ACTD               : 1;
    unsigned ACTSEL             : 1;
    };
  } __ACTCONbits_t;

extern __at(0x0FB5) volatile __ACTCONbits_t ACTCONbits;

#define _ACTORS                 0x02
#define _STOR                   0x02
#define _ACTOR                  0x02
#define _ACTLOCK                0x08
#define _STLOCK                 0x08
#define _ACTSRC                 0x10
#define _STSRC                  0x10
#define _ACTUD                  0x40
#define _STUD                   0x40
#define _ACTD                   0x40
#define _ACTEN                  0x80
#define _STEN                   0x80
#define _ACTSEL                 0x80

//==============================================================================


//==============================================================================
//        STCON Bits

extern __at(0x0FB5) __sfr STCON;

typedef union
  {
  struct
    {
    unsigned                    : 1;
    unsigned ACTORS             : 1;
    unsigned                    : 1;
    unsigned ACTLOCK            : 1;
    unsigned ACTSRC             : 1;
    unsigned                    : 1;
    unsigned ACTUD              : 1;
    unsigned ACTEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned STOR               : 1;
    unsigned                    : 1;
    unsigned STLOCK             : 1;
    unsigned STSRC              : 1;
    unsigned                    : 1;
    unsigned STUD               : 1;
    unsigned STEN               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ACTOR              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ACTD               : 1;
    unsigned ACTSEL             : 1;
    };
  } __STCONbits_t;

extern __at(0x0FB5) volatile __STCONbits_t STCONbits;

#define _STCON_ACTORS           0x02
#define _STCON_STOR             0x02
#define _STCON_ACTOR            0x02
#define _STCON_ACTLOCK          0x08
#define _STCON_STLOCK           0x08
#define _STCON_ACTSRC           0x10
#define _STCON_STSRC            0x10
#define _STCON_ACTUD            0x40
#define _STCON_STUD             0x40
#define _STCON_ACTD             0x40
#define _STCON_ACTEN            0x80
#define _STCON_STEN             0x80
#define _STCON_ACTSEL           0x80

//==============================================================================


//==============================================================================
//        ECCP1AS Bits

extern __at(0x0FB6) __sfr ECCP1AS;

typedef union
  {
  struct
    {
    unsigned PSS1BD0            : 1;
    unsigned PSS1BD1            : 1;
    unsigned PSS1AC0            : 1;
    unsigned PSS1AC1            : 1;
    unsigned ECCP1AS0           : 1;
    unsigned ECCP1AS1           : 1;
    unsigned ECCP1AS2           : 1;
    unsigned ECCP1ASE           : 1;
    };

  struct
    {
    unsigned PSSBD0             : 1;
    unsigned PSSBD1             : 1;
    unsigned PSSAC0             : 1;
    unsigned PSSAC1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1ASE            : 1;
    };

  struct
    {
    unsigned PSS1BD             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned PSSBD              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSSAC              : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PSS1AC             : 2;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ECCP1AS            : 3;
    unsigned                    : 1;
    };
  } __ECCP1ASbits_t;

extern __at(0x0FB6) volatile __ECCP1ASbits_t ECCP1ASbits;

#define _PSS1BD0                0x01
#define _PSSBD0                 0x01
#define _PSS1BD1                0x02
#define _PSSBD1                 0x02
#define _PSS1AC0                0x04
#define _PSSAC0                 0x04
#define _PSS1AC1                0x08
#define _PSSAC1                 0x08
#define _ECCP1AS0               0x10
#define _ECCP1AS1               0x20
#define _ECCP1AS2               0x40
#define _ECCP1ASE               0x80
#define _CCP1ASE                0x80

//==============================================================================


//==============================================================================
//        ECCP1DEL Bits

extern __at(0x0FB7) __sfr ECCP1DEL;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PR1SEN             : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __ECCP1DELbits_t;

extern __at(0x0FB7) volatile __ECCP1DELbits_t ECCP1DELbits;

#define _PDC0                   0x01
#define _PDC1                   0x02
#define _PDC2                   0x04
#define _PDC3                   0x08
#define _PDC4                   0x10
#define _PDC5                   0x20
#define _PDC6                   0x40
#define _P1RSEN                 0x80
#define _PR1SEN                 0x80

//==============================================================================


//==============================================================================
//        PWM1CON Bits

extern __at(0x0FB7) __sfr PWM1CON;

typedef union
  {
  struct
    {
    unsigned PDC0               : 1;
    unsigned PDC1               : 1;
    unsigned PDC2               : 1;
    unsigned PDC3               : 1;
    unsigned PDC4               : 1;
    unsigned PDC5               : 1;
    unsigned PDC6               : 1;
    unsigned P1RSEN             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned PR1SEN             : 1;
    };

  struct
    {
    unsigned PDC                : 7;
    unsigned                    : 1;
    };
  } __PWM1CONbits_t;

extern __at(0x0FB7) volatile __PWM1CONbits_t PWM1CONbits;

#define _PWM1CON_PDC0           0x01
#define _PWM1CON_PDC1           0x02
#define _PWM1CON_PDC2           0x04
#define _PWM1CON_PDC3           0x08
#define _PWM1CON_PDC4           0x10
#define _PWM1CON_PDC5           0x20
#define _PWM1CON_PDC6           0x40
#define _PWM1CON_P1RSEN         0x80
#define _PWM1CON_PR1SEN         0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x0FB8) __sfr BAUDCON;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCONbits_t;

extern __at(0x0FB8) volatile __BAUDCONbits_t BAUDCONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _TXCKP                  0x10
#define _CKTXP                  0x10
#define _SCKP                   0x10
#define _RXDTP                  0x20
#define _DTRXP                  0x20
#define _RCIDL                  0x40
#define _RCMT                   0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x0FB8) __sfr BAUDCON1;

typedef union
  {
  struct
    {
    unsigned ABDEN              : 1;
    unsigned WUE                : 1;
    unsigned                    : 1;
    unsigned BRG16              : 1;
    unsigned TXCKP              : 1;
    unsigned RXDTP              : 1;
    unsigned RCIDL              : 1;
    unsigned ABDOVF             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CKTXP              : 1;
    unsigned DTRXP              : 1;
    unsigned RCMT               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned SCKP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __BAUDCON1bits_t;

extern __at(0x0FB8) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_TXCKP         0x10
#define _BAUDCON1_CKTXP         0x10
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RXDTP         0x20
#define _BAUDCON1_DTRXP         0x20
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_RCMT          0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        PSTR1CON Bits

extern __at(0x0FB9) __sfr PSTR1CON;

typedef union
  {
  struct
    {
    unsigned STRA               : 1;
    unsigned STRB               : 1;
    unsigned STRC               : 1;
    unsigned STRD               : 1;
    unsigned STRSYNC            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned STR1A              : 1;
    unsigned STR1B              : 1;
    unsigned STR1C              : 1;
    unsigned STR1D              : 1;
    unsigned STR1SYNC           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __PSTR1CONbits_t;

extern __at(0x0FB9) volatile __PSTR1CONbits_t PSTR1CONbits;

#define _STRA                   0x01
#define _STR1A                  0x01
#define _STRB                   0x02
#define _STR1B                  0x02
#define _STRC                   0x04
#define _STR1C                  0x04
#define _STRD                   0x08
#define _STR1D                  0x08
#define _STRSYNC                0x10
#define _STR1SYNC               0x10

//==============================================================================


//==============================================================================
//        T2CON Bits

extern __at(0x0FBA) __sfr T2CON;

typedef union
  {
  struct
    {
    unsigned T2CKPS0            : 1;
    unsigned T2CKPS1            : 1;
    unsigned TMR2ON             : 1;
    unsigned T2OUTPS0           : 1;
    unsigned T2OUTPS1           : 1;
    unsigned T2OUTPS2           : 1;
    unsigned T2OUTPS3           : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T2CKPS             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned T2OUTPS            : 4;
    unsigned                    : 1;
    };
  } __T2CONbits_t;

extern __at(0x0FBA) volatile __T2CONbits_t T2CONbits;

#define _T2CKPS0                0x01
#define _T2CKPS1                0x02
#define _TMR2ON                 0x04
#define _T2OUTPS0               0x08
#define _T2OUTPS1               0x10
#define _T2OUTPS2               0x20
#define _T2OUTPS3               0x40

//==============================================================================

extern __at(0x0FBB) __sfr PR2;
extern __at(0x0FBC) __sfr TMR2;

//==============================================================================
//        CCP1CON Bits

extern __at(0x0FBD) __sfr CCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __CCP1CONbits_t;

extern __at(0x0FBD) volatile __CCP1CONbits_t CCP1CONbits;

#define _CCP1M0                 0x01
#define _CCP1M1                 0x02
#define _CCP1M2                 0x04
#define _CCP1M3                 0x08
#define _DC1B0                  0x10
#define _CCP1Y                  0x10
#define _DC1B1                  0x20
#define _CCP1X                  0x20
#define _P1M0                   0x40
#define _P1M1                   0x80

//==============================================================================


//==============================================================================
//        ECCP1CON Bits

extern __at(0x0FBD) __sfr ECCP1CON;

typedef union
  {
  struct
    {
    unsigned CCP1M0             : 1;
    unsigned CCP1M1             : 1;
    unsigned CCP1M2             : 1;
    unsigned CCP1M3             : 1;
    unsigned DC1B0              : 1;
    unsigned DC1B1              : 1;
    unsigned P1M0               : 1;
    unsigned P1M1               : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned CCP1Y              : 1;
    unsigned CCP1X              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned CCP1M              : 4;
    unsigned                    : 4;
    };

  struct
    {
    unsigned                    : 4;
    unsigned DC1B               : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned P1M                : 2;
    };
  } __ECCP1CONbits_t;

extern __at(0x0FBD) volatile __ECCP1CONbits_t ECCP1CONbits;

#define _ECCP1CON_CCP1M0        0x01
#define _ECCP1CON_CCP1M1        0x02
#define _ECCP1CON_CCP1M2        0x04
#define _ECCP1CON_CCP1M3        0x08
#define _ECCP1CON_DC1B0         0x10
#define _ECCP1CON_CCP1Y         0x10
#define _ECCP1CON_DC1B1         0x20
#define _ECCP1CON_CCP1X         0x20
#define _ECCP1CON_P1M0          0x40
#define _ECCP1CON_P1M1          0x80

//==============================================================================

extern __at(0x0FBE) __sfr CCPR1;
extern __at(0x0FBE) __sfr CCPR1L;
extern __at(0x0FBF) __sfr CCPR1H;

//==============================================================================
//        ADCON2 Bits

extern __at(0x0FC0) __sfr ADCON2;

typedef union
  {
  struct
    {
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ACQT0              : 1;
    unsigned ACQT1              : 1;
    unsigned ACQT2              : 1;
    unsigned                    : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADCS               : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 3;
    unsigned ACQT               : 3;
    unsigned                    : 2;
    };
  } __ADCON2bits_t;

extern __at(0x0FC0) volatile __ADCON2bits_t ADCON2bits;

#define _ADCS0                  0x01
#define _ADCS1                  0x02
#define _ADCS2                  0x04
#define _ACQT0                  0x08
#define _ACQT1                  0x10
#define _ACQT2                  0x20
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x0FC1) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned NVCFG0             : 1;
    unsigned NVCFG1             : 1;
    unsigned PVCFG0             : 1;
    unsigned PVCFG1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TRIGSEL            : 1;
    };

  struct
    {
    unsigned NVCFG              : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned PVCFG              : 2;
    unsigned                    : 4;
    };
  } __ADCON1bits_t;

extern __at(0x0FC1) volatile __ADCON1bits_t ADCON1bits;

#define _NVCFG0                 0x01
#define _NVCFG1                 0x02
#define _PVCFG0                 0x04
#define _PVCFG1                 0x08
#define _TRIGSEL                0x80

//==============================================================================


//==============================================================================
//        ADCON0 Bits

extern __at(0x0FC2) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned DONE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x0FC2) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _DONE                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02

//==============================================================================

extern __at(0x0FC3) __sfr ADRESL;
extern __at(0x0FC4) __sfr ADRESH;

//==============================================================================
//        SSP1CON2 Bits

extern __at(0x0FC5) __sfr SSP1CON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSP1CON2bits_t;

extern __at(0x0FC5) volatile __SSP1CON2bits_t SSP1CON2bits;

#define _SEN                    0x01
#define _RSEN                   0x02
#define _PEN                    0x04
#define _RCEN                   0x08
#define _ACKEN                  0x10
#define _ACKDT                  0x20
#define _ACKSTAT                0x40
#define _GCEN                   0x80

//==============================================================================


//==============================================================================
//        SSPCON2 Bits

extern __at(0x0FC5) __sfr SSPCON2;

typedef struct
  {
  unsigned SEN                  : 1;
  unsigned RSEN                 : 1;
  unsigned PEN                  : 1;
  unsigned RCEN                 : 1;
  unsigned ACKEN                : 1;
  unsigned ACKDT                : 1;
  unsigned ACKSTAT              : 1;
  unsigned GCEN                 : 1;
  } __SSPCON2bits_t;

extern __at(0x0FC5) volatile __SSPCON2bits_t SSPCON2bits;

#define _SSPCON2_SEN            0x01
#define _SSPCON2_RSEN           0x02
#define _SSPCON2_PEN            0x04
#define _SSPCON2_RCEN           0x08
#define _SSPCON2_ACKEN          0x10
#define _SSPCON2_ACKDT          0x20
#define _SSPCON2_ACKSTAT        0x40
#define _SSPCON2_GCEN           0x80

//==============================================================================


//==============================================================================
//        SSP1CON1 Bits

extern __at(0x0FC6) __sfr SSP1CON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSP1CON1bits_t;

extern __at(0x0FC6) volatile __SSP1CON1bits_t SSP1CON1bits;

#define _SSPM0                  0x01
#define _SSPM1                  0x02
#define _SSPM2                  0x04
#define _SSPM3                  0x08
#define _CKP                    0x10
#define _SSPEN                  0x20
#define _SSPOV                  0x40
#define _WCOL                   0x80

//==============================================================================


//==============================================================================
//        SSPCON Bits

extern __at(0x0FC6) __sfr SSPCON;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCONbits_t;

extern __at(0x0FC6) volatile __SSPCONbits_t SSPCONbits;

#define _SSPCON_SSPM0           0x01
#define _SSPCON_SSPM1           0x02
#define _SSPCON_SSPM2           0x04
#define _SSPCON_SSPM3           0x08
#define _SSPCON_CKP             0x10
#define _SSPCON_SSPEN           0x20
#define _SSPCON_SSPOV           0x40
#define _SSPCON_WCOL            0x80

//==============================================================================


//==============================================================================
//        SSPCON1 Bits

extern __at(0x0FC6) __sfr SSPCON1;

typedef union
  {
  struct
    {
    unsigned SSPM0              : 1;
    unsigned SSPM1              : 1;
    unsigned SSPM2              : 1;
    unsigned SSPM3              : 1;
    unsigned CKP                : 1;
    unsigned SSPEN              : 1;
    unsigned SSPOV              : 1;
    unsigned WCOL               : 1;
    };

  struct
    {
    unsigned SSPM               : 4;
    unsigned                    : 4;
    };
  } __SSPCON1bits_t;

extern __at(0x0FC6) volatile __SSPCON1bits_t SSPCON1bits;

#define _SSPCON1_SSPM0          0x01
#define _SSPCON1_SSPM1          0x02
#define _SSPCON1_SSPM2          0x04
#define _SSPCON1_SSPM3          0x08
#define _SSPCON1_CKP            0x10
#define _SSPCON1_SSPEN          0x20
#define _SSPCON1_SSPOV          0x40
#define _SSPCON1_WCOL           0x80

//==============================================================================


//==============================================================================
//        SSP1STAT Bits

extern __at(0x0FC7) __sfr SSP1STAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSP1STATbits_t;

extern __at(0x0FC7) volatile __SSP1STATbits_t SSP1STATbits;

#define _BF                     0x01
#define _UA                     0x02
#define _R_NOT_W                0x04
#define _S                      0x08
#define _P                      0x10
#define _D_NOT_A                0x20
#define _CKE                    0x40
#define _SMP                    0x80

//==============================================================================


//==============================================================================
//        SSPSTAT Bits

extern __at(0x0FC7) __sfr SSPSTAT;

typedef struct
  {
  unsigned BF                   : 1;
  unsigned UA                   : 1;
  unsigned R_NOT_W              : 1;
  unsigned S                    : 1;
  unsigned P                    : 1;
  unsigned D_NOT_A              : 1;
  unsigned CKE                  : 1;
  unsigned SMP                  : 1;
  } __SSPSTATbits_t;

extern __at(0x0FC7) volatile __SSPSTATbits_t SSPSTATbits;

#define _SSPSTAT_BF             0x01
#define _SSPSTAT_UA             0x02
#define _SSPSTAT_R_NOT_W        0x04
#define _SSPSTAT_S              0x08
#define _SSPSTAT_P              0x10
#define _SSPSTAT_D_NOT_A        0x20
#define _SSPSTAT_CKE            0x40
#define _SSPSTAT_SMP            0x80

//==============================================================================


//==============================================================================
//        SSP1ADD Bits

extern __at(0x0FC8) __sfr SSP1ADD;

typedef struct
  {
  unsigned SSP1ADD0             : 1;
  unsigned SSP1ADD1             : 1;
  unsigned SSP1ADD2             : 1;
  unsigned SSP1ADD3             : 1;
  unsigned SSP1ADD4             : 1;
  unsigned SSP1ADD5             : 1;
  unsigned SSP1ADD6             : 1;
  unsigned SSP1ADD7             : 1;
  } __SSP1ADDbits_t;

extern __at(0x0FC8) volatile __SSP1ADDbits_t SSP1ADDbits;

#define _SSP1ADD0               0x01
#define _SSP1ADD1               0x02
#define _SSP1ADD2               0x04
#define _SSP1ADD3               0x08
#define _SSP1ADD4               0x10
#define _SSP1ADD5               0x20
#define _SSP1ADD6               0x40
#define _SSP1ADD7               0x80

//==============================================================================


//==============================================================================
//        SSPADD Bits

extern __at(0x0FC8) __sfr SSPADD;

typedef struct
  {
  unsigned SSP1ADD0             : 1;
  unsigned SSP1ADD1             : 1;
  unsigned SSP1ADD2             : 1;
  unsigned SSP1ADD3             : 1;
  unsigned SSP1ADD4             : 1;
  unsigned SSP1ADD5             : 1;
  unsigned SSP1ADD6             : 1;
  unsigned SSP1ADD7             : 1;
  } __SSPADDbits_t;

extern __at(0x0FC8) volatile __SSPADDbits_t SSPADDbits;

#define _SSPADD_SSP1ADD0        0x01
#define _SSPADD_SSP1ADD1        0x02
#define _SSPADD_SSP1ADD2        0x04
#define _SSPADD_SSP1ADD3        0x08
#define _SSPADD_SSP1ADD4        0x10
#define _SSPADD_SSP1ADD5        0x20
#define _SSPADD_SSP1ADD6        0x40
#define _SSPADD_SSP1ADD7        0x80

//==============================================================================

extern __at(0x0FC9) __sfr SSP1BUF;
extern __at(0x0FC9) __sfr SSPBUF;

//==============================================================================
//        SSP1MSK Bits

extern __at(0x0FCA) __sfr SSP1MSK;

typedef struct
  {
  unsigned SSP1MSK0             : 1;
  unsigned SSP1MSK1             : 1;
  unsigned SSP1MSK2             : 1;
  unsigned SSP1MSK3             : 1;
  unsigned SSP1MSK4             : 1;
  unsigned SSP1MSK5             : 1;
  unsigned SSP1MSK6             : 1;
  unsigned SSP1MSK7             : 1;
  } __SSP1MSKbits_t;

extern __at(0x0FCA) volatile __SSP1MSKbits_t SSP1MSKbits;

#define _SSP1MSK0               0x01
#define _SSP1MSK1               0x02
#define _SSP1MSK2               0x04
#define _SSP1MSK3               0x08
#define _SSP1MSK4               0x10
#define _SSP1MSK5               0x20
#define _SSP1MSK6               0x40
#define _SSP1MSK7               0x80

//==============================================================================


//==============================================================================
//        SSPMSK Bits

extern __at(0x0FCA) __sfr SSPMSK;

typedef struct
  {
  unsigned SSP1MSK0             : 1;
  unsigned SSP1MSK1             : 1;
  unsigned SSP1MSK2             : 1;
  unsigned SSP1MSK3             : 1;
  unsigned SSP1MSK4             : 1;
  unsigned SSP1MSK5             : 1;
  unsigned SSP1MSK6             : 1;
  unsigned SSP1MSK7             : 1;
  } __SSPMSKbits_t;

extern __at(0x0FCA) volatile __SSPMSKbits_t SSPMSKbits;

#define _SSPMSK_SSP1MSK0        0x01
#define _SSPMSK_SSP1MSK1        0x02
#define _SSPMSK_SSP1MSK2        0x04
#define _SSPMSK_SSP1MSK3        0x08
#define _SSPMSK_SSP1MSK4        0x10
#define _SSPMSK_SSP1MSK5        0x20
#define _SSPMSK_SSP1MSK6        0x40
#define _SSPMSK_SSP1MSK7        0x80

//==============================================================================


//==============================================================================
//        SSP1CON3 Bits

extern __at(0x0FCB) __sfr SSP1CON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSP1CON3bits_t;

extern __at(0x0FCB) volatile __SSP1CON3bits_t SSP1CON3bits;

#define _DHEN                   0x01
#define _AHEN                   0x02
#define _SBCDE                  0x04
#define _SDAHT                  0x08
#define _BOEN                   0x10
#define _SCIE                   0x20
#define _PCIE                   0x40
#define _ACKTIM                 0x80

//==============================================================================


//==============================================================================
//        SSPCON3 Bits

extern __at(0x0FCB) __sfr SSPCON3;

typedef struct
  {
  unsigned DHEN                 : 1;
  unsigned AHEN                 : 1;
  unsigned SBCDE                : 1;
  unsigned SDAHT                : 1;
  unsigned BOEN                 : 1;
  unsigned SCIE                 : 1;
  unsigned PCIE                 : 1;
  unsigned ACKTIM               : 1;
  } __SSPCON3bits_t;

extern __at(0x0FCB) volatile __SSPCON3bits_t SSPCON3bits;

#define _SSPCON3_DHEN           0x01
#define _SSPCON3_AHEN           0x02
#define _SSPCON3_SBCDE          0x04
#define _SSPCON3_SDAHT          0x08
#define _SSPCON3_BOEN           0x10
#define _SSPCON3_SCIE           0x20
#define _SSPCON3_PCIE           0x40
#define _SSPCON3_ACKTIM         0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0FCC) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_T1DONE   : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned NOT_T1DONE         : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1DONE             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0FCC) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_T1DONE       0x08
#define _T1GGO                  0x08
#define _NOT_T1DONE             0x08
#define _T1DONE                 0x08
#define _T1GGO_NOT_DONE         0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        T1CON Bits

extern __at(0x0FCD) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned RD16               : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned SOSCEN             : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned T1RD16             : 1;
    unsigned T1SYNC             : 1;
    unsigned T1SOSCEN           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1OSCEN            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0FCD) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _RD16                   0x02
#define _T1RD16                 0x02
#define _NOT_T1SYNC             0x04
#define _T1SYNC                 0x04
#define _SOSCEN                 0x08
#define _T1SOSCEN               0x08
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================

extern __at(0x0FCE) __sfr TMR1;
extern __at(0x0FCE) __sfr TMR1L;
extern __at(0x0FCF) __sfr TMR1H;

//==============================================================================
//        RCON Bits

extern __at(0x0FD0) __sfr RCON;

typedef union
  {
  struct
    {
    unsigned NOT_BOR            : 1;
    unsigned NOT_POR            : 1;
    unsigned NOT_PD             : 1;
    unsigned NOT_TO             : 1;
    unsigned NOT_RI             : 1;
    unsigned                    : 1;
    unsigned SBOREN             : 1;
    unsigned IPEN               : 1;
    };

  struct
    {
    unsigned BOR                : 1;
    unsigned POR                : 1;
    unsigned PD                 : 1;
    unsigned TO                 : 1;
    unsigned RI                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __RCONbits_t;

extern __at(0x0FD0) volatile __RCONbits_t RCONbits;

#define _NOT_BOR                0x01
#define _BOR                    0x01
#define _NOT_POR                0x02
#define _POR                    0x02
#define _NOT_PD                 0x04
#define _PD                     0x04
#define _NOT_TO                 0x08
#define _TO                     0x08
#define _NOT_RI                 0x10
#define _RI                     0x10
#define _SBOREN                 0x40
#define _IPEN                   0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0FD1) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SWDTE              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __WDTCONbits_t;

extern __at(0x0FD1) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _SWDTE                  0x01

//==============================================================================


//==============================================================================
//        OSCCON2 Bits

extern __at(0x0FD2) __sfr OSCCON2;

typedef struct
  {
  unsigned LFIOFS               : 1;
  unsigned HFIOFR               : 1;
  unsigned PRISD                : 1;
  unsigned SOSCGO               : 1;
  unsigned PLLEN                : 1;
  unsigned INTSRC               : 1;
  unsigned SOSCRUN              : 1;
  unsigned PLLRDY               : 1;
  } __OSCCON2bits_t;

extern __at(0x0FD2) volatile __OSCCON2bits_t OSCCON2bits;

#define _LFIOFS                 0x01
#define _HFIOFR                 0x02
#define _PRISD                  0x04
#define _SOSCGO                 0x08
#define _PLLEN                  0x10
#define _INTSRC                 0x20
#define _SOSCRUN                0x40
#define _PLLRDY                 0x80

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0FD3) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned HFIOFS             : 1;
    unsigned OSTS               : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IDLEN              : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned FLTS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned IRCF               : 3;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0FD3) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _HFIOFS                 0x04
#define _FLTS                   0x04
#define _OSTS                   0x08
#define _IRCF0                  0x10
#define _IRCF1                  0x20
#define _IRCF2                  0x40
#define _IDLEN                  0x80

//==============================================================================


//==============================================================================
//        T0CON Bits

extern __at(0x0FD5) __sfr T0CON;

typedef union
  {
  struct
    {
    unsigned T0PS0              : 1;
    unsigned T0PS1              : 1;
    unsigned T0PS2              : 1;
    unsigned PSA                : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned T08BIT             : 1;
    unsigned TMR0ON             : 1;
    };

  struct
    {
    unsigned T0PS               : 3;
    unsigned                    : 5;
    };
  } __T0CONbits_t;

extern __at(0x0FD5) volatile __T0CONbits_t T0CONbits;

#define _T0PS0                  0x01
#define _T0PS1                  0x02
#define _T0PS2                  0x04
#define _PSA                    0x08
#define _T0SE                   0x10
#define _T0CS                   0x20
#define _T08BIT                 0x40
#define _TMR0ON                 0x80

//==============================================================================

extern __at(0x0FD6) __sfr TMR0;
extern __at(0x0FD6) __sfr TMR0L;
extern __at(0x0FD7) __sfr TMR0H;

//==============================================================================
//        STATUS Bits

extern __at(0x0FD8) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned OV                   : 1;
  unsigned N                    : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0FD8) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _OV                     0x08
#define _N                      0x10

//==============================================================================

extern __at(0x0FD9) __sfr FSR2L;
extern __at(0x0FDA) __sfr FSR2H;
extern __at(0x0FDB) __sfr PLUSW2;
extern __at(0x0FDC) __sfr PREINC2;
extern __at(0x0FDD) __sfr POSTDEC2;
extern __at(0x0FDE) __sfr POSTINC2;
extern __at(0x0FDF) __sfr INDF2;
extern __at(0x0FE0) __sfr BSR;
extern __at(0x0FE1) __sfr FSR1L;
extern __at(0x0FE2) __sfr FSR1H;
extern __at(0x0FE3) __sfr PLUSW1;
extern __at(0x0FE4) __sfr PREINC1;
extern __at(0x0FE5) __sfr POSTDEC1;
extern __at(0x0FE6) __sfr POSTINC1;
extern __at(0x0FE7) __sfr INDF1;
extern __at(0x0FE8) __sfr WREG;
extern __at(0x0FE9) __sfr FSR0L;
extern __at(0x0FEA) __sfr FSR0H;
extern __at(0x0FEB) __sfr PLUSW0;
extern __at(0x0FEC) __sfr PREINC0;
extern __at(0x0FED) __sfr POSTDEC0;
extern __at(0x0FEE) __sfr POSTINC0;
extern __at(0x0FEF) __sfr INDF0;

//==============================================================================
//        INTCON3 Bits

extern __at(0x0FF0) __sfr INTCON3;

typedef union
  {
  struct
    {
    unsigned INT1IF             : 1;
    unsigned INT2IF             : 1;
    unsigned                    : 1;
    unsigned INT1IE             : 1;
    unsigned INT2IE             : 1;
    unsigned                    : 1;
    unsigned INT1IP             : 1;
    unsigned INT2IP             : 1;
    };

  struct
    {
    unsigned INT1F              : 1;
    unsigned INT2F              : 1;
    unsigned                    : 1;
    unsigned INT1E              : 1;
    unsigned INT2E              : 1;
    unsigned                    : 1;
    unsigned INT1P              : 1;
    unsigned INT2P              : 1;
    };
  } __INTCON3bits_t;

extern __at(0x0FF0) volatile __INTCON3bits_t INTCON3bits;

#define _INT1IF                 0x01
#define _INT1F                  0x01
#define _INT2IF                 0x02
#define _INT2F                  0x02
#define _INT1IE                 0x08
#define _INT1E                  0x08
#define _INT2IE                 0x10
#define _INT2E                  0x10
#define _INT1IP                 0x40
#define _INT1P                  0x40
#define _INT2IP                 0x80
#define _INT2P                  0x80

//==============================================================================


//==============================================================================
//        INTCON2 Bits

extern __at(0x0FF1) __sfr INTCON2;

typedef union
  {
  struct
    {
    unsigned IOCIP              : 1;
    unsigned                    : 1;
    unsigned TMR0IP             : 1;
    unsigned                    : 1;
    unsigned INTEDG2            : 1;
    unsigned INTEDG1            : 1;
    unsigned INTEDG0            : 1;
    unsigned NOT_RBPU           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IP               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned RBPU               : 1;
    };
  } __INTCON2bits_t;

extern __at(0x0FF1) volatile __INTCON2bits_t INTCON2bits;

#define _IOCIP                  0x01
#define _TMR0IP                 0x04
#define _T0IP                   0x04
#define _INTEDG2                0x10
#define _INTEDG1                0x20
#define _INTEDG0                0x40
#define _NOT_RBPU               0x80
#define _RBPU                   0x80

//==============================================================================


//==============================================================================
//        INTCON Bits

extern __at(0x0FF2) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INT0IF             : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INT0IE             : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE_GIEL          : 1;
    unsigned GIE_GIEH           : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned INT0F              : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned INT0E              : 1;
    unsigned T0IE               : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned GIEL               : 1;
    unsigned GIEH               : 1;
    };
  } __INTCONbits_t;

extern __at(0x0FF2) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INT0IF                 0x02
#define _INT0F                  0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INT0IE                 0x10
#define _INT0E                  0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE_GIEL              0x40
#define _PEIE                   0x40
#define _GIEL                   0x40
#define _GIE_GIEH               0x80
#define _GIE                    0x80
#define _GIEH                   0x80

//==============================================================================

extern __at(0x0FF3) __sfr PROD;
extern __at(0x0FF3) __sfr PRODL;
extern __at(0x0FF4) __sfr PRODH;
extern __at(0x0FF5) __sfr TABLAT;
extern __at(0x0FF6) __sfr TBLPTR;
extern __at(0x0FF6) __sfr TBLPTRL;
extern __at(0x0FF7) __sfr TBLPTRH;
extern __at(0x0FF8) __sfr TBLPTRU;
extern __at(0x0FF9) __sfr PC;
extern __at(0x0FF9) __sfr PCL;
extern __at(0x0FFA) __sfr PCLATH;
extern __at(0x0FFB) __sfr PCLATU;

//==============================================================================
//        STKPTR Bits

extern __at(0x0FFC) __sfr STKPTR;

typedef union
  {
  struct
    {
    unsigned SP0                : 1;
    unsigned SP1                : 1;
    unsigned SP2                : 1;
    unsigned SP3                : 1;
    unsigned SP4                : 1;
    unsigned                    : 1;
    unsigned STKUNF             : 1;
    unsigned STKFUL             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned STKOVF             : 1;
    };

  struct
    {
    unsigned SP                 : 5;
    unsigned                    : 3;
    };
  } __STKPTRbits_t;

extern __at(0x0FFC) volatile __STKPTRbits_t STKPTRbits;

#define _SP0                    0x01
#define _SP1                    0x02
#define _SP2                    0x04
#define _SP3                    0x08
#define _SP4                    0x10
#define _STKUNF                 0x40
#define _STKFUL                 0x80
#define _STKOVF                 0x80

//==============================================================================

extern __at(0x0FFD) __sfr TOS;
extern __at(0x0FFD) __sfr TOSL;
extern __at(0x0FFE) __sfr TOSH;
extern __at(0x0FFF) __sfr TOSU;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define __CONFIG1L              0x300000
#define __CONFIG1H              0x300001
#define __CONFIG2L              0x300002
#define __CONFIG2H              0x300003
#define __CONFIG3H              0x300005
#define __CONFIG4L              0x300006
#define __CONFIG5L              0x300008
#define __CONFIG5H              0x300009
#define __CONFIG6L              0x30000A
#define __CONFIG6H              0x30000B
#define __CONFIG7L              0x30000C
#define __CONFIG7H              0x30000D

//----------------------------- CONFIG1L Options -------------------------------

#define _PLLSEL_PLL4X_1L        0xFE    // 4x clock multiplier.
#define _PLLSEL_PLL3X_1L        0xFF    // 3x clock multiplier.
#define _CFGPLLEN_OFF_1L        0xFD    // PLL Disabled (firmware controlled).
#define _CFGPLLEN_ON_1L         0xFF    // PLL Enabled.
#define _CPUDIV_NOCLKDIV_1L     0xE7    // CPU uses system clock (no divide).
#define _CPUDIV_CLKDIV2_1L      0xEF    // CPU uses system clock divided by 2.
#define _CPUDIV_CLKDIV3_1L      0xF7    // CPU uses system clock divided by 3.
#define _CPUDIV_CLKDIV6_1L      0xFF    // CPU uses system clock divided by 6.
#define _LS48MHZ_SYS24X4_1L     0xDF    // System clock at 24 MHz, USB clock divider is set to 4.
#define _LS48MHZ_SYS48X8_1L     0xFF    // System clock at 48 MHz, USB clock divider is set to 8.

//----------------------------- CONFIG1H Options -------------------------------

#define _FOSC_LP_1H             0xF0    // LP oscillator.
#define _FOSC_XT_1H             0xF1    // XT oscillator.
#define _FOSC_HSH_1H            0xF2    // HS oscillator, high power 16MHz to 25MHz.
#define _FOSC_HSM_1H            0xF3    // HS oscillator, medium power 4MHz to 16MHz.
#define _FOSC_ECHCLKO_1H        0xF4    // EC oscillator, high power 16MHz to 48MHz, clock output on OSC2.
#define _FOSC_ECHIO_1H          0xF5    // EC oscillator, high power 16MHz to 48MHz.
#define _FOSC_RCCLKO_1H         0xF6    // External RC oscillator, clock output on OSC2.
#define _FOSC_RCIO_1H           0xF7    // External RC oscillator.
#define _FOSC_INTOSCIO_1H       0xF8    // Internal oscillator.
#define _FOSC_INTOSCCLKO_1H     0xF9    // Internal oscillator, clock output on OSC2.
#define _FOSC_ECMCLKO_1H        0xFA    // EC oscillator, medium power 4MHz to 16MHz, clock output on OSC2.
#define _FOSC_ECMIO_1H          0xFB    // EC oscillator, medium power 4MHz to 16MHz.
#define _FOSC_ECLCLKO_1H        0xFC    // EC oscillator, low power <4MHz, clock output on OSC2.
#define _FOSC_ECLIO_1H          0xFD    // EC oscillator, low power <4MHz.
#define _PCLKEN_OFF_1H          0xDF    // Primary oscillator shutdown firmware controlled.
#define _PCLKEN_ON_1H           0xFF    // Primary oscillator enabled.
#define _FCMEN_OFF_1H           0xBF    // Fail-Safe Clock Monitor disabled.
#define _FCMEN_ON_1H            0xFF    // Fail-Safe Clock Monitor enabled.
#define _IESO_OFF_1H            0x7F    // Oscillator Switchover mode disabled.
#define _IESO_ON_1H             0xFF    // Oscillator Switchover mode enabled.

//----------------------------- CONFIG2L Options -------------------------------

#define _nPWRTEN_ON_2L          0xFE    // Power up timer enabled.
#define _nPWRTEN_OFF_2L         0xFF    // Power up timer disabled.
#define _BOREN_OFF_2L           0xF9    // BOR disabled in hardware (SBOREN is ignored).
#define _BOREN_ON_2L            0xFB    // BOR controlled by firmware (SBOREN is enabled).
#define _BOREN_NOSLP_2L         0xFD    // BOR enabled in hardware, disabled in Sleep mode (SBOREN is ignored).
#define _BOREN_SBORDIS_2L       0xFF    // BOR enabled in hardware (SBOREN is ignored).
#define _BORV_285_2L            0xE7    // BOR set to 2.85V nominal.
#define _BORV_250_2L            0xEF    // BOR set to 2.5V nominal.
#define _BORV_220_2L            0xF7    // BOR set to 2.2V nominal.
#define _BORV_190_2L            0xFF    // BOR set to 1.9V nominal.
#define _nLPBOR_ON_2L           0xBF    // Low-Power Brown-out Reset enabled.
#define _nLPBOR_OFF_2L          0xFF    // Low-Power Brown-out Reset disabled.

//----------------------------- CONFIG2H Options -------------------------------

#define _WDTEN_OFF_2H           0xFC    // WDT disabled in hardware (SWDTEN ignored).
#define _WDTEN_NOSLP_2H         0xFD    // WDT enabled in hardware, disabled in Sleep mode (SWDTEN ignored).
#define _WDTEN_SWON_2H          0xFE    // WDT controlled by firmware (SWDTEN enabled).
#define _WDTEN_ON_2H            0xFF    // WDT enabled in hardware (SWDTEN ignored).
#define _WDTPS_1_2H             0xC3    // 1:1.
#define _WDTPS_2_2H             0xC7    // 1:2.
#define _WDTPS_4_2H             0xCB    // 1:4.
#define _WDTPS_8_2H             0xCF    // 1:8.
#define _WDTPS_16_2H            0xD3    // 1:16.
#define _WDTPS_32_2H            0xD7    // 1:32.
#define _WDTPS_64_2H            0xDB    // 1:64.
#define _WDTPS_128_2H           0xDF    // 1:128.
#define _WDTPS_256_2H           0xE3    // 1:256.
#define _WDTPS_512_2H           0xE7    // 1:512.
#define _WDTPS_1024_2H          0xEB    // 1:1024.
#define _WDTPS_2048_2H          0xEF    // 1:2048.
#define _WDTPS_4096_2H          0xF3    // 1:4096.
#define _WDTPS_8192_2H          0xF7    // 1:8192.
#define _WDTPS_16384_2H         0xFB    // 1:16384.
#define _WDTPS_32768_2H         0xFF    // 1:32768.

//----------------------------- CONFIG3H Options -------------------------------

#define _CCP2MX_RB3_3H          0xFE    // CCP2 input/output is multiplexed with RB3.
#define _CCP2MX_RC1_3H          0xFF    // CCP2 input/output is multiplexed with RC1.
#define _PBADEN_OFF_3H          0xFD    // PORTB<5:0> pins are configured as digital I/O on Reset.
#define _PBADEN_ON_3H           0xFF    // PORTB<5:0> pins are configured as analog input channels on Reset.
#define _T3CMX_RB5_3H           0xEF    // T3CKI function is on RB5.
#define _T3CMX_RC0_3H           0xFF    // T3CKI function is on RC0.
#define _SDOMX_RC7_3H           0xBF    // SDO function is on RC7.
#define _SDOMX_RB3_3H           0xFF    // SDO function is on RB3.
#define _MCLRE_OFF_3H           0x7F    // RE3 input pin enabled; external MCLR disabled.
#define _MCLRE_ON_3H            0xFF    // MCLR pin enabled; RE3 input disabled.

//----------------------------- CONFIG4L Options -------------------------------

#define _STVREN_OFF_4L          0xFE    // Stack full/underflow will not cause Reset.
#define _STVREN_ON_4L           0xFF    // Stack full/underflow will cause Reset.
#define _LVP_OFF_4L             0xFB    // Single-Supply ICSP disabled.
#define _LVP_ON_4L              0xFF    // Single-Supply ICSP enabled if MCLRE is also 1.
#define _ICPRT_OFF_4L           0xDF    // ICPORT disabled.
#define _XINST_OFF_4L           0xBF    // Instruction set extension and Indexed Addressing mode disabled.
#define _XINST_ON_4L            0xFF    // Instruction set extension and Indexed Addressing mode enabled.
#define _DEBUG_ON_4L            0x7F    // Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug.
#define _DEBUG_OFF_4L           0xFF    // Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins.

//----------------------------- CONFIG5L Options -------------------------------

#define _CP0_ON_5L              0xFE    // Block 0 is code-protected.
#define _CP0_OFF_5L             0xFF    // Block 0 is not code-protected.
#define _CP1_ON_5L              0xFD    // Block 1 is code-protected.
#define _CP1_OFF_5L             0xFF    // Block 1 is not code-protected.

//----------------------------- CONFIG5H Options -------------------------------

#define _CPB_ON_5H              0xBF    // Boot block is code-protected.
#define _CPB_OFF_5H             0xFF    // Boot block is not code-protected.
#define _CPD_ON_5H              0x7F    // Data EEPROM is code-protected.
#define _CPD_OFF_5H             0xFF    // Data EEPROM is not code-protected.

//----------------------------- CONFIG6L Options -------------------------------

#define _WRT0_ON_6L             0xFE    // Block 0 (0800-1FFFh) is write-protected.
#define _WRT0_OFF_6L            0xFF    // Block 0 (0800-1FFFh) is not write-protected.
#define _WRT1_ON_6L             0xFD    // Block 1 (2000-3FFFh) is write-protected.
#define _WRT1_OFF_6L            0xFF    // Block 1 (2000-3FFFh) is not write-protected.

//----------------------------- CONFIG6H Options -------------------------------

#define _WRTC_ON_6H             0xDF    // Configuration registers (300000-3000FFh) are write-protected.
#define _WRTC_OFF_6H            0xFF    // Configuration registers (300000-3000FFh) are not write-protected.
#define _WRTB_ON_6H             0xBF    // Boot block (0000-7FFh) is write-protected.
#define _WRTB_OFF_6H            0xFF    // Boot block (0000-7FFh) is not write-protected.
#define _WRTD_ON_6H             0x7F    // Data EEPROM is write-protected.
#define _WRTD_OFF_6H            0xFF    // Data EEPROM is not write-protected.

//----------------------------- CONFIG7L Options -------------------------------

#define _EBTR0_ON_7L            0xFE    // Block 0 is protected from table reads executed in other blocks.
#define _EBTR0_OFF_7L           0xFF    // Block 0 is not protected from table reads executed in other blocks.
#define _EBTR1_ON_7L            0xFD    // Block 1 is protected from table reads executed in other blocks.
#define _EBTR1_OFF_7L           0xFF    // Block 1 is not protected from table reads executed in other blocks.

//----------------------------- CONFIG7H Options -------------------------------

#define _EBTRB_ON_7H            0xBF    // Boot block is protected from table reads executed in other blocks.
#define _EBTRB_OFF_7H           0xFF    // Boot block is not protected from table reads executed in other blocks.

//==============================================================================

#define __DEVID1                0x3FFFFE
#define __DEVID2                0x3FFFFF

#define __IDLOC0                0x200000
#define __IDLOC1                0x200001
#define __IDLOC2                0x200002
#define __IDLOC3                0x200003
#define __IDLOC4                0x200004
#define __IDLOC5                0x200005
#define __IDLOC6                0x200006
#define __IDLOC7                0x200007

#endif // #ifndef __PIC18F24K50_H__
