/// \file
/// \ingroup tutorial_io
/// \notebook -nodraw
/// Example of script to loop on all the objects of a ROOT file directory
/// and print on Postscript all TH1 derived objects.
/// This script uses the file generated by tutorial hsimple.C
///
/// \macro_image
/// \macro_code
///
/// \author Rene Brun

void loopdir11() {
   TFile *f1 = TFile::Open("hsimple.root");
   TCanvas c1;
   c1.Print("hsimple.ps[");
   for(auto k : *f1->GetListOfKeys()) {
      TKey *key = static_cast<TKey*>(k);
      TClass *cl = gROOT->GetClass(key->GetClassName());
      if (!cl->InheritsFrom("TH1")) continue;
      TH1 *h = key->ReadObject<TH1>();
      h->Draw();
      c1.Print("hsimple.ps");
   }
   c1.Print("hsimple.ps]");
}
