/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyVariableViewSettings {
    public static final String LOADING_TIMED_OUT = "Loading timed out";
    public static final String ON_DEMAND_LINK_TEXT = "Switch to loading on demand";
    public static final String WARNING_MESSAGE = "The values of several variables couldn't be loaded  ";

    public static void showWarningMessage(@Nullable XCompositeNode node) {
        if (node == null) {
            return;
        }
        final PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        if (debuggerSettings.getValuesPolicy() == PyDebugValue.ValuesPolicy.ON_DEMAND) {
            return;
        }
        node.setMessage(WARNING_MESSAGE, AllIcons.General.BalloonWarning, SimpleTextAttributes.REGULAR_ATTRIBUTES, new XDebuggerTreeNodeHyperlink(ON_DEMAND_LINK_TEXT){
            private boolean linkClicked;
            {
                super(arg0);
                this.linkClicked = false;
            }

            public void onClick(MouseEvent event) {
                debuggerSettings.setValuesPolicy(PyDebugValue.ValuesPolicy.ON_DEMAND);
                this.linkClicked = true;
            }

            @NotNull
            public String getLinkText() {
                if (this.linkClicked) {
                    if ("" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "";
                }
                if (PyVariableViewSettings.ON_DEMAND_LINK_TEXT == null) {
                    1.$$$reportNull$$$0(1);
                }
                return PyVariableViewSettings.ON_DEMAND_LINK_TEXT;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyVariableViewSettings$1", "getLinkText"));
            }
        });
    }

    public static class PolicyAction
    extends ToggleAction {
        @NotNull
        private final String myText;
        @NotNull
        private final PyDebugValue.ValuesPolicy myPolicy;
        @NotNull
        private final VariablesPolicyGroup myActionGroup;
        private volatile boolean isEnabled;

        public PolicyAction(@NotNull String text2, @NotNull String description, @NotNull PyDebugValue.ValuesPolicy policy, @NotNull VariablesPolicyGroup actionGroup) {
            if (text2 == null) {
                PolicyAction.$$$reportNull$$$0(0);
            }
            if (description == null) {
                PolicyAction.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                PolicyAction.$$$reportNull$$$0(2);
            }
            if (actionGroup == null) {
                PolicyAction.$$$reportNull$$$0(3);
            }
            super("", description, null);
            this.myText = text2;
            this.myPolicy = policy;
            this.myActionGroup = actionGroup;
            this.isEnabled = PyDebuggerSettings.getInstance().getValuesPolicy() == policy;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(4);
            }
            super.update(e);
            this.myActionGroup.updatePolicyActions();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        @NotNull
        public PyDebugValue.ValuesPolicy getPolicy() {
            PyDebugValue.ValuesPolicy valuesPolicy = this.myPolicy;
            if (valuesPolicy == null) {
                PolicyAction.$$$reportNull$$$0(5);
            }
            return valuesPolicy;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(6);
            }
            return this.isEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                PolicyAction.$$$reportNull$$$0(7);
            }
            this.isEnabled = hide;
            if (hide) {
                PyDebuggerSettings.getInstance().setValuesPolicy(this.myPolicy);
            }
            this.myActionGroup.updatePolicyActions();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 4: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyVariableViewSettings$PolicyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$PolicyAction";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolicy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class VariablesPolicyGroup
    extends DefaultActionGroup {
        @NotNull
        private final List<PolicyAction> myValuesPolicyActions = new ArrayList<PolicyAction>();

        public VariablesPolicyGroup() {
            super("Variables Loading Policy", true);
            this.myValuesPolicyActions.add(new PolicyAction("Synchronously", "Load variable values synchronously", PyDebugValue.ValuesPolicy.SYNC, this));
            this.myValuesPolicyActions.add(new PolicyAction("Asynchronously", "Load variable values asynchronously", PyDebugValue.ValuesPolicy.ASYNC, this));
            this.myValuesPolicyActions.add(new PolicyAction("On demand", "Load variable values on demand", PyDebugValue.ValuesPolicy.ON_DEMAND, this));
            for (AnAction anAction : this.myValuesPolicyActions) {
                this.add(anAction);
            }
        }

        public void updatePolicyActions() {
            PyDebugValue.ValuesPolicy currentValuesPolicy = PyDebuggerSettings.getInstance().getValuesPolicy();
            for (PolicyAction action : this.myValuesPolicyActions) {
                action.setEnabled(currentValuesPolicy == action.getPolicy());
            }
        }
    }

    public static class SimplifiedView
    extends ToggleAction {
        private final PyDebugProcess myProcess;
        private final String myText;
        private volatile boolean mySimplifiedView = PyDebuggerSettings.getInstance().isSimplifiedView();

        public SimplifiedView(@Nullable PyDebugProcess debugProcess) {
            super("", "Disables watching classes, functions and modules objects", null);
            this.myProcess = debugProcess;
            this.myText = "Simplified Variables View";
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
            presentation.setText(this.myText);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(1);
            }
            return this.mySimplifiedView;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(2);
            }
            this.mySimplifiedView = hide;
            PyDebuggerSettings.getInstance().setSimplifiedView(hide);
            if (this.myProcess != null) {
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

