/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.ServerConfigurationBase;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudRuntimeTask;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudConnectionTask<T, SC extends ServerConfigurationBase, DC extends DeploymentConfiguration, SR extends CloudServerRuntimeInstance<DC, ?, ?>>
extends CloudRuntimeTask<T, DC, SR> {
    private final RemoteServer<SC> myServer;

    public CloudConnectionTask(Project project, String title, @Nullable RemoteServer<SC> server) {
        super(project, title);
        this.myServer = server;
    }

    @Override
    protected void run(Semaphore semaphore, AtomicReference<T> result2) {
        if (this.myServer == null) {
            semaphore.up();
            return;
        }
        ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(this.myServer);
        this.run(connection, semaphore, result2);
    }

    @Override
    protected void run(final ServerConnection<DC> connection, final Semaphore semaphore, final AtomicReference<T> result2) {
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback<DC>(){

            public void connected(@NotNull ServerRuntimeInstance<DC> serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    CloudConnectionTask.this.run((CloudServerRuntimeInstance)serverRuntimeInstance, semaphore, result2);
                }
                finally {
                    ApplicationManager.getApplication().invokeLater(() -> connection.disconnect());
                }
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                CloudConnectionTask.this.runtimeErrorOccurred(errorMessage);
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/util/CloudConnectionTask$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Override
    protected SR getServerRuntime() {
        throw new UnsupportedOperationException();
    }

    public final RemoteServer<SC> getServer() {
        return this.myServer;
    }
}

