/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.SkipSelfSearchComponent;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.ColorSchemeActions;
import com.intellij.application.options.schemes.AbstractSchemeActions;
import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.application.options.schemes.SimpleSchemesPanel;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemesPanel
extends SimpleSchemesPanel<EditorColorsScheme>
implements SkipSelfSearchComponent {
    private final ColorAndFontOptions myOptions;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private boolean myListLoaded = false;

    public SchemesPanel(ColorAndFontOptions options) {
        this(options, 8);
    }

    public SchemesPanel(ColorAndFontOptions options, int vGap) {
        super(vGap);
        this.myOptions = options;
    }

    public boolean areSchemesLoaded() {
        return this.myListLoaded;
    }

    public void resetSchemesCombo(Object source) {
        if (this != source) {
            this.setListLoaded(false);
            EditorColorsScheme selectedSchemeBackup = this.myOptions.getSelectedScheme();
            this.resetSchemes(this.myOptions.getOrderedSchemes());
            this.selectScheme(selectedSchemeBackup);
            this.setListLoaded(true);
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).schemeChanged(this);
        }
    }

    private void setListLoaded(boolean b) {
        this.myListLoaded = b;
    }

    public void addListener(ColorAndFontSettingsListener listener2) {
        this.myDispatcher.addListener((EventListener)listener2);
    }

    @Override
    protected AbstractSchemeActions<EditorColorsScheme> createSchemeActions() {
        return new ColorSchemeActions(this){

            @Override
            @NotNull
            protected ColorAndFontOptions getOptions() {
                ColorAndFontOptions colorAndFontOptions = SchemesPanel.this.myOptions;
                if (colorAndFontOptions == null) {
                    1.$$$reportNull$$$0(0);
                }
                return colorAndFontOptions;
            }

            @Override
            protected void onSchemeChanged(@Nullable EditorColorsScheme scheme2) {
                if (scheme2 != null) {
                    SchemesPanel.this.myOptions.selectScheme(scheme2.getName());
                    if (SchemesPanel.this.areSchemesLoaded()) {
                        ((ColorAndFontSettingsListener)SchemesPanel.this.myDispatcher.getMulticaster()).schemeChanged(SchemesPanel.this);
                    }
                }
            }

            @Override
            protected void renameScheme(@NotNull EditorColorsScheme scheme2, @NotNull String newName) {
                if (scheme2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (newName == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (SchemesPanel.this.myOptions.saveSchemeAs(scheme2, newName)) {
                    SchemesPanel.this.myOptions.removeScheme(scheme2);
                    SchemesPanel.this.myOptions.selectScheme(newName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scheme";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "newName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getOptions";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/application/options/colors/SchemesPanel$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "renameScheme";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Override
    @NotNull
    public SchemesModel<EditorColorsScheme> getModel() {
        ColorAndFontOptions colorAndFontOptions = this.myOptions;
        if (colorAndFontOptions == null) {
            SchemesPanel.$$$reportNull$$$0(0);
        }
        return colorAndFontOptions;
    }

    @Override
    protected boolean supportsProjectSchemes() {
        return false;
    }

    @Override
    protected boolean highlightNonDefaultSchemes() {
        return true;
    }

    @Override
    public boolean useBoldForNonRemovableSchemes() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/colors/SchemesPanel", "getModel"));
    }
}

