/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import org.protege.editor.core.PropertyUtil;
import org.protege.editor.core.ProtegeProperties;

public class LinkLabel
extends JLabel {
    private static final long serialVersionUID = -4294549567545547816L;
    private Color linkColor;
    private Color hoverColor;
    private Cursor oldCursor;
    private ActionListener linkListener;

    public LinkLabel(String text, ActionListener linkListener) {
        super(text);
        this.linkListener = linkListener;
        this.linkColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.propertycolor"), Color.GRAY);
        this.hoverColor = PropertyUtil.getColor(ProtegeProperties.getInstance().getProperty("org.protege.classcolor"), Color.GRAY);
        this.setForeground(this.linkColor);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LinkLabel.this.setHoverMode(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                LinkLabel.this.setHoverMode(false);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                LinkLabel.this.activateLink();
            }
        });
        this.setFont(this.getFont().deriveFont(1));
    }

    public void setLinkColor(Color color) {
        this.linkColor = color;
    }

    public void setHoverColor(Color color) {
        this.hoverColor = color;
    }

    private void setHoverMode(boolean b) {
        if (b && this.isEnabled()) {
            this.setForeground(this.hoverColor);
            this.oldCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else {
            this.setForeground(this.linkColor);
            if (this.oldCursor != null) {
                this.setCursor(this.oldCursor);
            }
        }
    }

    private void activateLink() {
        Point mousePosition = this.getMousePosition();
        if (this.isEnabled() && mousePosition != null && this.contains(mousePosition)) {
            this.linkListener.actionPerformed(new ActionEvent(this, 0, this.getText()));
        }
    }
}

