/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.model.parameter.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.sejda.model.input.PdfSource;
import org.sejda.model.parameter.base.AbstractPdfOutputParameters;
import org.sejda.model.parameter.base.MultiplePdfSourceTaskParameters;
import org.sejda.model.validation.constraint.NotEmpty;

public abstract class MultiplePdfSourceParameters
extends AbstractPdfOutputParameters
implements MultiplePdfSourceTaskParameters {
    @NotEmpty
    @Valid
    private final List<PdfSource<?>> sourceList = new ArrayList();

    public void addSources(Collection<PdfSource<?>> inputs) {
        this.sourceList.addAll(inputs);
    }

    @Override
    public void addSource(PdfSource<?> input) {
        this.sourceList.add(input);
    }

    public void removeAllSources() {
        this.sourceList.clear();
    }

    @Override
    public List<PdfSource<?>> getSourceList() {
        return Collections.unmodifiableList(this.sourceList);
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.sourceList).toHashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MultiplePdfSourceParameters)) {
            return false;
        }
        MultiplePdfSourceParameters parameter = (MultiplePdfSourceParameters)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append(this.sourceList, parameter.getSourceList()).isEquals();
    }
}

