/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.update;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.ConfigurableProperty;
import org.pdfsam.Pdfsam;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.update.UpdateAvailableEvent;
import org.pdfsam.update.UpdateCheckRequest;
import org.pdfsam.update.UpdateService;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
public class UpdatesController {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatesController.class);
    private Pdfsam pdfsam;
    private UpdateService service;

    @Inject
    UpdatesController(UpdateService service, Pdfsam pdfsam) {
        this.service = service;
        this.pdfsam = pdfsam;
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void checkForUpdates(UpdateCheckRequest event) {
        LOG.debug(DefaultI18nContext.getInstance().i18n("Checking for updates"));
        ((CompletableFuture)CompletableFuture.supplyAsync(this.service::getLatestVersion).thenAccept(current -> {
            if (StringUtils.isNotBlank((CharSequence)current) && !this.pdfsam.property(ConfigurableProperty.VERSION).equals(current)) {
                LOG.info(DefaultI18nContext.getInstance().i18n("PDFsam {0} is available for download", current));
                StaticStudio.eventStudio().broadcast((Object)new UpdateAvailableEvent(current));
            }
        })).whenComplete((r, e) -> {
            if (Objects.nonNull(e)) {
                LOG.warn(DefaultI18nContext.getInstance().i18n("Unable to find the latest available version."), e);
            }
        });
    }
}

