/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import java.util.function.Consumer;

class JdiEventHandler
implements Runnable {
    private final Thread thread;
    private volatile boolean connected = true;
    private boolean completed = false;
    private final VirtualMachine vm;
    private final Consumer<String> reportVMExit;

    JdiEventHandler(VirtualMachine vm, Consumer<String> reportVMExit) {
        this.vm = vm;
        this.reportVMExit = reportVMExit;
        this.thread = new Thread((Runnable)this, "event-handler");
        this.thread.setDaemon(true);
    }

    void start() {
        this.thread.start();
    }

    synchronized void shutdown() {
        this.connected = false;
        this.thread.interrupt();
        while (!this.completed) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                boolean resumeStoppedApp = false;
                EventIterator it = eventSet.eventIterator();
                while (it.hasNext()) {
                    resumeStoppedApp |= this.handleEvent(it.nextEvent());
                }
                if (!resumeStoppedApp) continue;
                eventSet.resume();
            }
            catch (InterruptedException eventSet) {
            }
            catch (VMDisconnectedException discExc) {
                this.handleDisconnectedException();
                break;
            }
        }
        JdiEventHandler jdiEventHandler = this;
        synchronized (jdiEventHandler) {
            this.completed = true;
            this.notifyAll();
        }
    }

    private boolean handleEvent(Event event) {
        this.handleExitEvent(event);
        return true;
    }

    private void handleExitEvent(Event event) {
        if (event instanceof VMDeathEvent) {
            this.reportVMExit.accept("VM Died");
        } else if (event instanceof VMDisconnectEvent) {
            this.connected = false;
            this.reportVMExit.accept("VM Disconnected");
        }
    }

    private synchronized void handleDisconnectedException() {
        EventQueue queue = this.vm.eventQueue();
        while (this.connected) {
            try {
                EventSet eventSet = queue.remove();
                EventIterator iter = eventSet.eventIterator();
                while (iter.hasNext()) {
                    this.handleExitEvent((Event)iter.next());
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InternalError internalError) {
            }
        }
    }
}

