/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;

public final class BreakpointsFromGroup
implements Set<Breakpoint> {
    private final String groupName;
    private final TestGroupProperties testProperties;

    public BreakpointsFromGroup(String groupName) {
        this.groupName = groupName;
        this.testProperties = null;
    }

    public BreakpointsFromGroup(TestGroupProperties testProperties) {
        this.groupName = null;
        this.testProperties = testProperties;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public TestGroupProperties getTestGroupProperties() {
        return this.testProperties;
    }

    private List<Breakpoint> getBreakpointsFromGroup() {
        ArrayList<Breakpoint> breakpoints;
        block3: {
            Breakpoint[] bps;
            block2: {
                breakpoints = new ArrayList<Breakpoint>();
                bps = DebuggerManager.getDebuggerManager().getBreakpoints();
                if (this.groupName == null) break block2;
                for (Breakpoint b : bps) {
                    if (!this.groupName.equals(b.getGroupName())) continue;
                    breakpoints.add(b);
                }
                break block3;
            }
            if (this.testProperties == null) break block3;
            for (Breakpoint b : bps) {
                Breakpoint.GroupProperties groupProperties = b.getGroupProperties();
                if (groupProperties == null || groupProperties.isHidden() || !this.testProperties.accept(groupProperties)) continue;
                breakpoints.add(b);
            }
        }
        return breakpoints;
    }

    @Override
    public int size() {
        return this.getBreakpointsFromGroup().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getBreakpointsFromGroup().isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.getBreakpointsFromGroup().contains(o);
    }

    @Override
    public Iterator<Breakpoint> iterator() {
        return this.getBreakpointsFromGroup().iterator();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.getBreakpointsFromGroup().containsAll(c);
    }

    @Override
    public Object[] toArray() {
        return this.getBreakpointsFromGroup().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.getBreakpointsFromGroup().toArray(a);
    }

    @Override
    public boolean add(Breakpoint e) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean addAll(Collection<? extends Breakpoint> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported.");
    }

    public static final class TestGroupProperties {
        private FileObject fo;
        private Project p;
        private String type;

        public TestGroupProperties(FileObject fo) {
            this.fo = fo;
        }

        public TestGroupProperties(Project p) {
            this.p = p;
        }

        public TestGroupProperties(String type) {
            this.type = type;
        }

        public FileObject getFileObject() {
            return this.fo;
        }

        public Project getProject() {
            return this.p;
        }

        public String getType() {
            return this.type;
        }

        boolean accept(Breakpoint.GroupProperties gp) {
            Project[] projects;
            FileObject[] files;
            if (this.fo != null && (files = gp.getFiles()) != null) {
                for (FileObject fileObject : files) {
                    if (!this.fo.equals(fileObject)) continue;
                    return true;
                }
            }
            if (this.p != null && (projects = gp.getProjects()) != null) {
                for (FileObject fileObject : projects) {
                    if (!this.p.equals(fileObject)) continue;
                    return true;
                }
            }
            return this.type != null && this.type.equals(gp.getType());
        }
    }
}

