/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.model.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.netbeans.modules.xml.schema.model.GlobalAttribute;
import org.netbeans.modules.xml.schema.model.GlobalAttributeGroup;
import org.netbeans.modules.xml.schema.model.GlobalComplexType;
import org.netbeans.modules.xml.schema.model.GlobalElement;
import org.netbeans.modules.xml.schema.model.GlobalGroup;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.GlobalType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.impl.SchemaImpl;
import org.netbeans.modules.xml.schema.model.impl.SchemaModelImpl;
import org.netbeans.modules.xml.schema.model.visitor.FindGlobalReferenceVisitor;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.netbeans.modules.xml.xam.Named;
import org.netbeans.modules.xml.xam.NamedReferenceable;
import org.openide.util.RequestProcessor;

public class GlobalComponentsIndexSupport
implements Runnable {
    private static HashSet<Class<? extends SchemaComponent>> mIndexedTypes = new HashSet();
    private static int GLOBAL_COMPONENT_INDEX_CREATE_THRESHOLD = 60;
    private static int GLOBAL_COMPONENT_INDEX_REMOVE_THRESHOLD = 50;
    private static int INDEX_RECALCULATION_DELAY = 100;
    private static RequestProcessor mIndexRecalculationRP;
    private SchemaModelImpl mSModel;
    private TreeMap<String, Object> mGlobalComponentIndex = null;
    private ComponentListener mComponentListener = null;
    private RequestProcessor.Task mIndexGenerationTask;
    private boolean mSupportIndex = false;
    private final Object lock = new Object();
    private JUnitTestSupport mTestSupport;

    public GlobalComponentsIndexSupport(SchemaModelImpl model) {
        this.mSModel = model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends NamedReferenceable> T findByNameAndType(String localName, Class<T> type) {
        Object object = this.lock;
        synchronized (object) {
            boolean indexNotAccessible;
            this.checkGlobalComponentIndexRequired();
            boolean bl = indexNotAccessible = !this.mSupportIndex || this.mGlobalComponentIndex == null || !mIndexedTypes.contains(type) || this.mSModel.isIntransaction();
            if (!indexNotAccessible) {
                NamedReferenceable result = null;
                Object cached = this.mGlobalComponentIndex.get(localName);
                if (cached != null) {
                    if (type.isInstance(cached)) {
                        result = (NamedReferenceable)type.cast(cached);
                    } else if (cached instanceof List) {
                        List compList = (List)List.class.cast(cached);
                        for (Object sComp : compList) {
                            if (!type.isInstance(sComp)) continue;
                            result = (NamedReferenceable)type.cast(sComp);
                        }
                    }
                }
                return (T)result;
            }
        }
        SchemaImpl schema = this.mSModel.getSchema();
        if (schema == null) {
            return null;
        }
        return new FindGlobalReferenceVisitor<T>().find(type, localName, schema);
    }

    private void checkGlobalComponentIndexRequired() {
        boolean indexRemoveRequired;
        int childrenCount;
        boolean indexCreateRequired;
        SchemaImpl schema = this.mSModel.getSchema();
        if (schema == null) {
            return;
        }
        boolean indexAllowed = true;
        if (this.mTestSupport != null) {
            indexAllowed = this.mTestSupport.isIndexAllowed();
        }
        boolean bl = indexCreateRequired = (childrenCount = schema.getChildrenCount()) > GLOBAL_COMPONENT_INDEX_CREATE_THRESHOLD;
        if (indexCreateRequired && !this.mSupportIndex && indexAllowed) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("Switch ON components' index for Schema model: " + this.mSModel.toString());
            }
            if (this.mComponentListener == null) {
                this.mComponentListener = new ComponentListener(){

                    public void valueChanged(ComponentEvent evt) {
                    }

                    public void childrenAdded(ComponentEvent evt) {
                        if (evt.getSource() == GlobalComponentsIndexSupport.this.mSModel.getSchema()) {
                            GlobalComponentsIndexSupport.this.initiateIndexRebuld();
                        }
                    }

                    public void childrenDeleted(ComponentEvent evt) {
                        if (evt.getSource() == GlobalComponentsIndexSupport.this.mSModel.getSchema()) {
                            GlobalComponentsIndexSupport.this.initiateIndexRebuld();
                        }
                    }
                };
                this.mSModel.addComponentListener(this.mComponentListener);
            }
            if (this.mGlobalComponentIndex == null && this.mIndexGenerationTask == null) {
                if (this.mTestSupport != null) {
                    this.mTestSupport.log("initiate new index building for Schema model: " + this.mSModel.toString());
                }
                this.buildIndex(0);
            }
            this.mSupportIndex = true;
            return;
        }
        boolean bl2 = indexRemoveRequired = childrenCount < GLOBAL_COMPONENT_INDEX_REMOVE_THRESHOLD;
        if ((!indexAllowed || indexRemoveRequired) && this.mSupportIndex) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("Switch OFF components' index for Schema model: " + this.mSModel.toString());
            }
            this.mGlobalComponentIndex = null;
            if (this.mIndexGenerationTask != null) {
                this.mIndexGenerationTask.cancel();
                this.mIndexGenerationTask = null;
            }
            if (this.mComponentListener != null) {
                this.mSModel.removeComponentListener(this.mComponentListener);
                this.mComponentListener = null;
            }
            this.mSupportIndex = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initiateIndexRebuld() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTestSupport != null) {
                this.mTestSupport.log("initiate index rebuilding for Schema model: " + this.mSModel.toString());
            }
            this.mGlobalComponentIndex = null;
            if (this.mIndexGenerationTask != null) {
                this.mIndexGenerationTask.cancel();
            }
            this.buildIndex(INDEX_RECALCULATION_DELAY);
        }
    }

    private void buildIndex(int delay) {
        this.mIndexGenerationTask = mIndexRecalculationRP.post((Runnable)this, delay, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TreeMap<String, Object> newIndex = this.buildGlobalComponentIndex();
        if (!Thread.interrupted()) {
            Object object = this.lock;
            synchronized (object) {
                this.mGlobalComponentIndex = newIndex;
                this.mIndexGenerationTask = null;
            }
        }
    }

    private TreeMap<String, Object> buildGlobalComponentIndex() {
        if (Thread.interrupted()) {
            return null;
        }
        long before = 0L;
        if (this.mTestSupport != null) {
            before = System.nanoTime();
            this.mTestSupport.log("buildComponentIndex STARTED for Schema model: " + this.mSModel.toString());
        }
        TreeMap<String, Object> resultIndex = new TreeMap<String, Object>();
        SchemaImpl schema = this.mSModel.getSchema();
        if (schema == null) {
            return null;
        }
        List globalSCompList = schema.getChildren();
        for (SchemaComponent globalSComp : globalSCompList) {
            List<SchemaComponent> valuesList;
            if (Thread.interrupted()) {
                return null;
            }
            Class<? extends SchemaComponent> componentType = globalSComp.getComponentType();
            if (!mIndexedTypes.contains(componentType)) continue;
            assert (globalSComp instanceof Named);
            String name = ((Named)Named.class.cast(globalSComp)).getName();
            if (name == null || name.length() == 0) continue;
            Object value = resultIndex.get(name);
            if (value == null) {
                resultIndex.put(name, globalSComp);
                continue;
            }
            if (value instanceof List) {
                valuesList = (List)List.class.cast(value);
                valuesList.add(globalSComp);
                continue;
            }
            valuesList = new ArrayList();
            valuesList.add((SchemaComponent)value);
            valuesList.add(globalSComp);
            resultIndex.put(name, valuesList);
        }
        if (this.mTestSupport != null) {
            long after = System.nanoTime();
            float delay = (float)(after - before) / 1000000.0f;
            this.mTestSupport.log("buildComponentIndex FINISHED for Schema model: " + this.mSModel.toString());
            this.mTestSupport.log("Index contains " + resultIndex.size() + " items. Building has taken " + new DecimalFormat("#0.00#").format(delay) + " ms");
        }
        return resultIndex;
    }

    public JUnitTestSupport getJUnitTestSupport() {
        if (this.mTestSupport == null) {
            this.mTestSupport = new JUnitTestSupport(this);
        }
        return this.mTestSupport;
    }

    static {
        mIndexedTypes.add(GlobalAttribute.class);
        mIndexedTypes.add(GlobalAttributeGroup.class);
        mIndexedTypes.add(GlobalGroup.class);
        mIndexedTypes.add(GlobalType.class);
        mIndexedTypes.add(GlobalSimpleType.class);
        mIndexedTypes.add(GlobalComplexType.class);
        mIndexedTypes.add(GlobalElement.class);
        mIndexRecalculationRP = new RequestProcessor("IndexRecalculator", 3, true);
    }

    public static class JUnitTestSupport {
        private GlobalComponentsIndexSupport mIndexSupport;
        private List<String> mMsgLog;
        private boolean mIndexAllowed = true;

        public JUnitTestSupport(GlobalComponentsIndexSupport indexSupport) {
            this.mIndexSupport = indexSupport;
            this.mMsgLog = new ArrayList<String>();
        }

        public void log(String msg) {
            this.mMsgLog.add(msg);
        }

        public String printLog() {
            ArrayList<String> logCopy = new ArrayList<String>(this.mMsgLog);
            StringBuilder sb = new StringBuilder();
            String newLine = System.getProperty("line.separator");
            for (String msg : logCopy) {
                sb.append(msg).append(newLine);
            }
            return sb.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getIndexSize() {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                TreeMap index = this.mIndexSupport.mGlobalComponentIndex;
                if (index != null) {
                    return index.size();
                }
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean indexContains(String compName) {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                TreeMap index = this.mIndexSupport.mGlobalComponentIndex;
                if (index != null) {
                    return index.containsKey(compName);
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isSupportIndex() {
            Object object = this.mIndexSupport.lock;
            synchronized (object) {
                this.mIndexSupport.checkGlobalComponentIndexRequired();
                return this.mIndexSupport.mSupportIndex;
            }
        }

        public void setIndexAllowed(boolean status) {
            this.mIndexAllowed = status;
        }

        public boolean isIndexAllowed() {
            return this.mIndexAllowed;
        }
    }
}

