/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.validator;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.validator.ValidatorSchemaFactoryRegistry;
import org.netbeans.modules.xml.wsdl.validator.spi.ValidatorSchemaFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.spi.XsdBasedValidator;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WSDLSchemaValidator
extends XsdBasedValidator {
    static final String wsdlXSDUrl = "/org/netbeans/modules/xml/wsdl/validator/resources/external/wsdl-2004-08-24.xsd";

    public String getName() {
        return "WSDLSchemaValidator";
    }

    protected Schema getSchema(Model model) {
        if (!(model instanceof WSDLModel)) {
            return null;
        }
        InputStream wsdlSchemaInputStream = WSDLSchemaValidator.class.getResourceAsStream(wsdlXSDUrl);
        StreamSource wsdlSource = new StreamSource(wsdlSchemaInputStream);
        wsdlSource.setSystemId(WSDLSchemaValidator.class.getResource(wsdlXSDUrl).toString());
        Collection<ValidatorSchemaFactory> extSchemaFactories = ValidatorSchemaFactoryRegistry.getDefault().getAllValidatorSchemaFactories();
        ArrayList<Source> isList = new ArrayList<Source>();
        isList.add(wsdlSource);
        for (ValidatorSchemaFactory factory : extSchemaFactories) {
            Source is = factory.getSchemaSource();
            if (is != null) {
                isList.add(is);
                continue;
            }
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).severe("getSchema: " + factory.getClass() + " returned null input stream for its schema");
        }
        Schema schema = this.getCompiledSchema(isList.toArray(new Source[isList.size()]), new CentralLSResourceResolver(extSchemaFactories), new SchemaErrorHandler());
        return schema;
    }

    class CentralLSResourceResolver
    implements LSResourceResolver {
        private Collection<ValidatorSchemaFactory> mExtSchemaFactories;

        CentralLSResourceResolver(Collection<ValidatorSchemaFactory> extSchemaFactories) {
            this.mExtSchemaFactories = extSchemaFactories;
        }

        @Override
        public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            ValidatorSchemaFactory fac;
            LSResourceResolver resolver;
            LSInput input = null;
            Iterator<ValidatorSchemaFactory> it = this.mExtSchemaFactories.iterator();
            while (it.hasNext() && ((resolver = (fac = it.next()).getLSResourceResolver()) == null || (input = resolver.resolveResource(type, namespaceURI, publicId, systemId, baseURI)) == null)) {
            }
            return input;
        }
    }

    class SchemaErrorHandler
    implements ErrorHandler {
        SchemaErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SchemaErrorHandler: " + exception.getMessage(), exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "SchemaErrorHandler: " + exception.getMessage(), exception);
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
        }
    }
}

