/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;

class LayoutRegion
implements LayoutConstants {
    static final int[] POINT_COUNT = new int[]{3, 4};
    static final int ALL_POINTS = Integer.MAX_VALUE;
    static final int NO_POINT = Integer.MIN_VALUE;
    static final int UNKNOWN = Integer.MIN_VALUE;
    int[][] positions = new int[2][];

    LayoutRegion() {
        this.positions[0] = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
        this.positions[1] = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE};
    }

    LayoutRegion(LayoutRegion reg) {
        this();
        if (reg != null) {
            this.set(reg);
        }
    }

    LayoutRegion(Rectangle bounds, int baselinePos) {
        this();
        this.set(bounds, baselinePos);
    }

    boolean isSet() {
        return this.isSet(0) && this.isSet(1);
    }

    boolean isSet(int dimension) {
        return this.positions[dimension][0] != Integer.MIN_VALUE && this.positions[dimension][1] != Integer.MIN_VALUE;
    }

    boolean isSet(int dimension, int alignment) {
        return LayoutRegion.isValidCoordinate(this.positions[dimension][alignment]);
    }

    int size(int dimension) {
        int trail = this.positions[dimension][1];
        int lead = this.positions[dimension][0];
        return trail != Integer.MIN_VALUE && lead != Integer.MIN_VALUE ? trail - lead : Integer.MIN_VALUE;
    }

    void set(Rectangle bounds, int baselinePos) {
        int[] horiz = this.positions[0];
        horiz[0] = bounds.x;
        horiz[1] = bounds.x + bounds.width;
        horiz[2] = bounds.x + bounds.width / 2;
        int[] vert = this.positions[1];
        vert[0] = bounds.y;
        vert[1] = bounds.y + bounds.height;
        vert[2] = bounds.y + bounds.height / 2;
        vert[3] = baselinePos;
    }

    Rectangle toRectangle(Rectangle bounds) {
        int[] horiz = this.positions[0];
        bounds.x = horiz[0];
        bounds.width = horiz[1] - bounds.x;
        int[] vert = this.positions[1];
        bounds.y = vert[0];
        bounds.height = vert[1] - bounds.y;
        return bounds;
    }

    void set(LayoutRegion reg) {
        for (int i = 0; i < 2; ++i) {
            this.set(i, reg);
        }
    }

    void set(int dimension, LayoutRegion reg) {
        int[] pos = this.positions[dimension];
        int[] setPos = reg.positions[dimension];
        System.arraycopy(setPos, 0, pos, 0, pos.length);
    }

    void set(int dimension, int leading, int trailing) {
        int[] pos = this.positions[dimension];
        if (pos[0] != leading || pos[1] != trailing) {
            pos[0] = leading;
            pos[1] = trailing;
            int n = pos[2] = leading != Integer.MIN_VALUE && trailing != Integer.MIN_VALUE ? (leading + trailing) / 2 : Integer.MIN_VALUE;
            if (dimension == 1) {
                pos[3] = Integer.MIN_VALUE;
            }
        }
    }

    void setPos(int dimension, int alignment, int value) {
        int[] pos = this.positions[dimension];
        pos[alignment] = value;
        if (pos[0] != Integer.MIN_VALUE && pos[1] != Integer.MIN_VALUE) {
            pos[2] = (pos[0] + pos[1]) / 2;
        }
    }

    void reset() {
        for (int i = 0; i < 2; ++i) {
            int[] pos = this.positions[i];
            for (int j = 0; j < pos.length; ++j) {
                pos[j] = Integer.MIN_VALUE;
            }
        }
    }

    void reshape(int[] points, int[] moves) {
        for (int i = 0; i < 2; ++i) {
            this.reshape(i, points != null ? points[i] : Integer.MAX_VALUE, moves[i]);
        }
    }

    void reshape(int dimension, int align, int move) {
        int[] pos = this.positions[dimension];
        if (align == Integer.MAX_VALUE) {
            for (int j = 0; j < pos.length; ++j) {
                if (pos[j] == Integer.MIN_VALUE) continue;
                int n = j;
                pos[n] = pos[n] + move;
            }
        } else if (align != Integer.MIN_VALUE) {
            assert (align == 0 || align == 1);
            if (pos[align] != Integer.MIN_VALUE) {
                int n = align;
                pos[n] = pos[n] + move;
                if (pos[0] != Integer.MIN_VALUE && pos[1] != Integer.MIN_VALUE) {
                    if (pos[0] > pos[1]) {
                        pos[align] = pos[align ^ 1];
                    }
                    pos[2] = (pos[0] + pos[1]) / 2;
                }
                if (dimension == 1 && move != 0) {
                    pos[3] = Integer.MIN_VALUE;
                }
            }
        }
    }

    void expand(LayoutRegion reg) {
        for (int i = 0; i < 2; ++i) {
            this.expand(reg, i);
        }
    }

    void expand(LayoutRegion reg, int dimension) {
        int[] pos = this.positions[dimension];
        int[] exPos = reg.positions[dimension];
        if (exPos[0] != Integer.MIN_VALUE && (pos[0] == Integer.MIN_VALUE || exPos[0] < pos[0])) {
            pos[0] = exPos[0];
        }
        if (exPos[1] != Integer.MIN_VALUE && (pos[1] == Integer.MIN_VALUE || exPos[1] > pos[1])) {
            pos[1] = exPos[1];
        }
        if (pos[0] != Integer.MIN_VALUE && pos[1] != Integer.MIN_VALUE) {
            pos[2] = (pos[0] + pos[1]) / 2;
        }
    }

    static boolean isValidCoordinate(int pos) {
        return pos > Short.MIN_VALUE && pos < Short.MAX_VALUE;
    }

    static int distance(LayoutRegion r1, LayoutRegion r2, int dimension, int align1, int align2) {
        int pos1 = r1.positions[dimension][align1];
        int pos2 = r2.positions[dimension][align2];
        return pos1 != Integer.MIN_VALUE && pos2 != Integer.MIN_VALUE ? pos2 - pos1 : Integer.MIN_VALUE;
    }

    static int minDistance(LayoutRegion r1, LayoutRegion r2, int dimension) {
        int[] pos1 = r1.positions[dimension];
        int[] pos2 = r2.positions[dimension];
        int min = Integer.MIN_VALUE;
        int sign = 1;
        for (int i = 0; i < pos1.length; ++i) {
            int s;
            if (pos1[i] == Integer.MIN_VALUE || pos2[i] == Integer.MIN_VALUE) continue;
            int dst = pos2[i] - pos1[i];
            if (dst < 0) {
                dst = -dst;
                s = -1;
            } else {
                s = 1;
            }
            if (min != Integer.MIN_VALUE && dst >= min) continue;
            min = dst;
            sign = s;
        }
        return min * sign;
    }

    static int nonOverlapDistance(LayoutRegion r1, LayoutRegion r2, int dimension) {
        int[] pos2 = r2.positions[dimension];
        int[] pos1 = r1.positions[dimension];
        int dst = pos2[0] - pos1[1];
        if (dst >= 0) {
            return dst;
        }
        dst = pos2[1] - pos1[0];
        if (dst <= 0) {
            return dst;
        }
        return 0;
    }

    static boolean pointInside(LayoutRegion contained, int alignment, LayoutRegion container, int dimension) {
        int[] pos = container.positions[dimension];
        int point = contained.positions[dimension][alignment];
        assert (point != Integer.MIN_VALUE && pos[0] != Integer.MIN_VALUE && pos[1] != Integer.MIN_VALUE);
        if (alignment == 0) {
            return point >= pos[0] && point < pos[1];
        }
        return point > pos[0] && point <= pos[1];
    }

    static boolean overlap(LayoutRegion r1, LayoutRegion r2, int dimension, int margin) {
        boolean defined;
        int[] pos1 = r1.positions[dimension];
        int[] pos2 = r2.positions[dimension];
        int p2L = pos2[0];
        int p2T = pos2[1];
        boolean bl = defined = pos1[0] != Integer.MIN_VALUE && pos1[1] != Integer.MIN_VALUE && p2L != Integer.MIN_VALUE && p2T != Integer.MIN_VALUE;
        assert (defined);
        if (!defined) {
            return false;
        }
        int p1L = pos1[0] - margin;
        int p1T = pos1[1] + margin;
        return p1T > p2L && p1L < p2T || p1L == p2L && (p1L == p1T || p2L == p2T);
    }

    static boolean overlap(LayoutRegion r1, LayoutRegion r2) {
        return LayoutRegion.overlap(r1, r2, 0, 0) && LayoutRegion.overlap(r1, r2, 1, 0);
    }

    static boolean sameSpace(LayoutRegion r1, LayoutRegion r2) {
        return LayoutRegion.sameSpace(r1, r2, 0) && LayoutRegion.sameSpace(r1, r2, 1);
    }

    static boolean sameSpace(LayoutRegion r1, LayoutRegion r2, int dimension) {
        return r1.positions[dimension][0] == r2.positions[dimension][0] && r1.positions[dimension][1] == r2.positions[dimension][1];
    }
}

