/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.api.sql;

import java.util.Arrays;

public final class SQLKeywords {
    static final String[] SQL99_RESERVED = new String[]{"ABSOLUTE", "ACTION", "ADD", "ADMIN", "AFTER", "AGGREGATE", "ALIAS", "ALL", "ALLOCATE", "ALTER", "AND", "ANY", "ARE", "ARRAY", "AS", "ASC", "ASSERTION", "AT", "AUTHORIZATION", "BEFORE", "BEGIN", "BINARY", "BIT", "BLOB", "BOOLEAN", "BOTH", "BREADTH", "BY", "CALL", "CASCADE", "CASCADED", "CASE", "CAST", "CATALOG", "CHAR", "CHARACTER", "CHECK", "CLASS", "CLOB", "CLOSE", "COLLATE", "COLLATION", "COLUMN", "COMMIT", "COMPLETION", "CONDITION", "CONNECT", "CONNECTION", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CORRESPONDING", "CREATE", "CROSS", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATALINK", "DATE", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DELETE", "DEPTH", "DEREF", "DESC", "DESCRIBE", "DESCRIPTOR", "DESTROY", "DESTRUCTOR", "DETERMINISTIC", "DIAGNOSTICS", "DICTIONARY", "DISCONNECT", "DISTINCT", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "EACH", "ELSE", "ELSEIF", "END", "END-EXEC", "EQUALS", "ESCAPE", "EVERY", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXIT", "EXPAND", "EXPANDING", "EXTERNAL", "FALSE", "FETCH", "FIRST", "FLOAT", "FOR", "FOREIGN", "FOUND", "FREE", "FROM", "FULL", "FUNCTION", "GENERAL", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GROUP", "GROUPING", "HANDLER", "HASH", "HAVING", "HOST", "HOUR", "IDENTITY", "IF", "IGNORE", "IMMEDIATE", "IN", "INDICATOR", "INITIALIZE", "INITIALLY", "INNER", "INOUT", "INPUT", "INSERT", "INT", "INTEGER", "INTERSECT", "INTERVAL", "INTO", "IS", "ISOLATION", "ITERATE", "JOIN", "KEY", "LANGUAGE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAVE", "LEFT", "LESS", "LEVEL", "LIKE", "LIMIT", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOOP", "MATCH", "MEETS", "MINUTE", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NO", "NONE", "NORMALIZE", "NOT", "NULL", "NUMERIC", "OBJECT", "OF", "OFF", "OLD", "ON", "ONLY", "OPEN", "OPERATION", "OPTION", "OR", "ORDER", "ORDINALITY", "OUT", "OUTER", "OUTPUT", "PAD", "PARAMETER", "PARAMETERS", "PARTIAL", "PATH", "PERIOD", "POSTFIX", "PRECEDES", "PRECISION", "PREFIX", "PREORDER", "PREPARE", "PRESERVE", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURE", "PUBLIC", "READ", "READS", "REAL", "RECURSIVE", "REDO", "REF", "REFERENCES", "REFERENCING", "RELATIVE", "REPEAT", "RESIGNAL", "RESTRICT", "RESULT", "RETURN", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND", "SECTION", "SELECT", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SIGNAL", "SIZE", "SMALLINT", "SOME", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "START", "STATE", "STATEMENT", "STATIC", "STRUCTURE", "SYSTEM_USER", "TABLE", "TEMPORARY", "TERMINATE", "THAN", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TO", "TRAILING", "TRANSACTION", "TRANSLATION", "TREAT", "TRIGGER", "TRUE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARIABLE", "VARYING", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WITH", "WITHOUT", "WORK", "WRITE", "YEAR", "ZONE"};
    static final String[] SQL99_NON_RESERVED = new String[]{"ABS", "ADA", "ASENSITIVE", "ASSIGNMENT", "ASYMMETRIC", "ATOMIC", "AVG", "BETWEEN", "BITVAR", "BIT_LENGTH", "BLOCKED", "CARDINALITY", "CATALOG_NAME", "CHAIN", "CHARACTER_LENGTH", "CHARACTER_SET_CATALOG", "CHARACTER_SET_NAME", "CHARACTER_SET_SCHEMA", "CHAR_LENGTH", "CHECKED", "CLASS_ORIGIN", "COALESCE", "COBOL", "COLLATION_CATALOG", "COLLATION_NAME", "COLLATION_SCHEMA", "COLUMN_NAME", "COMMAND_FUNCTION", "COMMAND_FUNCTION_CODE", "COMMITTED", "CONCATENATE", "CONDITION_NUMBER", "CONNECTION_NAME", "CONSTRAINT_CATALOG", "CONSTRAINT_NAME", "CONSTRAINT_SCHEMA", "CONTAINS", "CONTROL", "CONVERT", "COUNT", "CURSOR_NAME", "DATABASE", "DATETIME_INTERVAL_CODE", "DATETIME_INTERVAL_PRECISION", "DB", "DELIMITER", "DISPATCH", "DLCOMMENT", "DLFILESIZE", "DLFILESIZEEXACT", "DLLINKTYPE", "DLURLCOMPLETE", "DLURLPATH", "DLURLPATHONLY", "DLURLSCHEMA", "DLURLSERVER", "DLVALUE", "DYNAMIC_FUNCTION", "DYNAMIC_FUNCTION_CODE", "EXISTING", "EXISTS", "EXTRACT", "FILE", "FINAL", "FORTRAN", "GENERATED", "HOLD", "INFIX", "INSENSITIVE", "INSTANTIABLE", "INTEGRITY", "KEY_MEMBER", "KEY_TYPE", "LENGTH", "LINK", "LOWER", "MAX", "MEDIUMINT", "MESSAGE_LENGTH", "MESSAGE_OCTET_LENGTH", "MESSAGE_TEXT", "METHOD", "MIN", "MOD", "MORE", "MUMPS", "NAME", "NULLABLE", "NULLIF", "NUMBER", "OCTET_LENGTH", "OPTIONS", "OVERLAPS", "OVERLAY", "OVERRIDING", "PARAMETER_MODE", "PARAMETER_NAME", "PARAMETER_ORDINAL_POSITION", "PARAMETER_SPECIFIC_CATALOG", "PARAMETER_SPECIFIC_NAME", "PARAMETER_SPECIFIC_SCHEMA", "PASCAL", "PERMISSION", "PLI", "POSITION", "RECOVERY", "REPEATABLE", "REPLACE", "RESTORE", "RETURNED_LENGTH", "RETURNED_OCTET_LENGTH", "RETURNED_SQLSTATE", "ROUTINE_CATALOG", "ROUTINE_NAME", "ROUTINE_SCHEMA", "ROW_COUNT", "ROW_TYPE_CATALOG", "ROW_TYPE_NAME", "ROW_TYPE_SCHEMA", "SCALE", "SCHEMA_NAME", "SELECTIVE", "SELF", "SENSITIVE", "SERIALIZABLE", "SERVER_NAME", "SIMILAR", "SIMPLE", "SOURCE", "SPECIFIC_NAME", "STRUCTURE", "STYLE", "SUBCLASS_ORIGIN", "SUBLIST", "SUBSTRING", "SUM", "SYMMETRIC", "SYSTEM", "TABLE_NAME", "TRANSACTIONS_COMMITTED", "TRANSACTIONS_ROLLED_BACK", "TRANSACTION_ACTIVE", "TRANSFORM", "TRANSLATE", "TRIGGER_CATALOG", "TRIGGER_NAME", "TRIGGER_SCHEMA", "TRIM", "TYPE", "UNCOMMITTED", "UNLINK", "UNNAMED", "UPPER", "USER_DEFINED_TYPE_CATALOG", "USER_DEFINED_TYPE_NAME", "USER_DEFINED_TYPE_SCHEMA", "YES"};

    private SQLKeywords() {
    }

    public static boolean isSQL99ReservedKeyword(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("The identifier cannot be null");
        }
        return Arrays.binarySearch(SQL99_RESERVED, identifier.toUpperCase()) >= 0;
    }

    public static boolean isSQL99NonReservedKeyword(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("The identifier cannot be null");
        }
        return Arrays.binarySearch(SQL99_NON_RESERVED, identifier.toUpperCase()) >= 0;
    }

    public static boolean isSQL99Keyword(String identifier) {
        return SQLKeywords.isSQL99ReservedKeyword(identifier) || SQLKeywords.isSQL99NonReservedKeyword(identifier);
    }

    public static boolean isSQL99Keyword(String identifier, boolean upperOnly) {
        if (identifier == null) {
            throw new NullPointerException("The identifier cannot be null");
        }
        if (upperOnly) {
            return Arrays.binarySearch(SQL99_RESERVED, identifier) >= 0 || Arrays.binarySearch(SQL99_NON_RESERVED, identifier) >= 0;
        }
        return SQLKeywords.isSQL99ReservedKeyword(identifier) || SQLKeywords.isSQL99NonReservedKeyword(identifier);
    }
}

