/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.filer;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOException;
import java.io.Writer;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileObject;

final class FormattingJavaFileObject
extends ForwardingJavaFileObject<JavaFileObject> {
    private static final int DEFAULT_FILE_SIZE = 40000;
    private final Formatter formatter;

    FormattingJavaFileObject(JavaFileObject delegate, Formatter formatter) {
        super((JavaFileObject)Preconditions.checkNotNull((Object)delegate));
        this.formatter = (Formatter)Preconditions.checkNotNull((Object)formatter);
    }

    @Override
    public Writer openWriter() throws IOException {
        final StringBuilder stringBuilder = new StringBuilder(40000);
        return new Writer(){

            @Override
            public void write(char[] chars, int start, int end) throws IOException {
                stringBuilder.append(chars, start, end - start);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                try {
                    FormattingJavaFileObject.this.formatter.formatSource(CharSource.wrap((CharSequence)stringBuilder), new CharSink(){

                        public Writer openStream() throws IOException {
                            return ((JavaFileObject)FormattingJavaFileObject.this.fileObject).openWriter();
                        }
                    });
                }
                catch (FormatterException e) {
                    throw new IOException("Error formatting " + FormattingJavaFileObject.this.getName(), e);
                }
            }
        };
    }
}

