/*
 * Decompiled with CFR 0.152.
 */
package ome.jxrlib;

import java.nio.ByteBuffer;
import ome.jxrlib.GUID;
import ome.jxrlib.JXRJNI;
import ome.jxrlib.Resolution;

class ImageDecoder {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected ImageDecoder(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(ImageDecoder obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                JXRJNI.delete_ImageDecoder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void initialize() {
        JXRJNI.ImageDecoder_initialize(this.swigCPtr, this);
    }

    public long getFrameCount() {
        return JXRJNI.ImageDecoder_getFrameCount(this.swigCPtr, this);
    }

    public void selectFrame(long frameNum) {
        JXRJNI.ImageDecoder_selectFrame(this.swigCPtr, this, frameNum);
    }

    public GUID getGUIDPixFormat() {
        return new GUID(JXRJNI.ImageDecoder_getGUIDPixFormat(this.swigCPtr, this), true);
    }

    public boolean getBlackWhite() {
        return JXRJNI.ImageDecoder_getBlackWhite(this.swigCPtr, this);
    }

    public long getWidth() {
        return JXRJNI.ImageDecoder_getWidth(this.swigCPtr, this);
    }

    public long getHeight() {
        return JXRJNI.ImageDecoder_getHeight(this.swigCPtr, this);
    }

    public long getBytesPerPixel() {
        return JXRJNI.ImageDecoder_getBytesPerPixel(this.swigCPtr, this);
    }

    public Resolution getResolution() {
        return new Resolution(JXRJNI.ImageDecoder_getResolution(this.swigCPtr, this), true);
    }

    public void getRawBytes(ByteBuffer NIOBUFFER) {
        assert (NIOBUFFER.isDirect()) : "Buffer must be allocated direct.";
        JXRJNI.ImageDecoder_getRawBytes(this.swigCPtr, this, NIOBUFFER);
    }

    public ImageDecoder() {
        this(JXRJNI.new_ImageDecoder(), true);
    }
}

