/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.simple;

import javajs.util.P3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AmpacReader
extends AtomSetCollectionReader {
    private int ac;
    private int freqAtom0 = -1;
    private float[] partialCharges;
    private P3[] atomPositions;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("CARTESIAN COORDINATES") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("NET ATOMIC CHARGES") >= 0) {
            this.readPartialCharges();
            return true;
        }
        if (this.line.indexOf("VIBRATIONAL FREQUENCIES") >= 0) {
            this.readFrequencies();
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        boolean bl;
        boolean bl2 = bl = this.freqAtom0 >= 0;
        if (bl) {
            this.atomPositions = new P3[this.ac];
        } else {
            this.asc.newAtomSet();
        }
        this.rd();
        this.ac = 0;
        while (this.rd() != null) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 5) break;
            if (bl) {
                this.atomPositions[this.ac] = P3.new3(this.parseFloatStr(stringArray[2]), this.parseFloatStr(stringArray[3]), this.parseFloatStr(stringArray[4]));
            } else {
                this.addAtomXYZSymName(stringArray, 2, stringArray[1], null);
            }
            ++this.ac;
        }
        if (bl) {
            this.setPositions();
        }
    }

    private void setPositions() {
        int n = this.asc.ac;
        Atom[] atomArray = this.asc.atoms;
        int n2 = this.freqAtom0;
        while (n2 < n) {
            atomArray[n2].setT(this.atomPositions[n2 % this.ac]);
            atomArray[n2].partialCharge = this.partialCharges[n2 % this.ac];
            ++n2;
        }
    }

    private void readPartialCharges() throws Exception {
        this.rd();
        this.partialCharges = new float[this.ac];
        int n = 0;
        while (n < this.ac) {
            String[] stringArray;
            if (this.rd() == null || (stringArray = this.getTokens()).length < 4) break;
            this.partialCharges[n] = this.parseFloatStr(stringArray[2]);
            ++n;
        }
    }

    private void readFrequencies() throws Exception {
        while (this.rd() != null && this.line.indexOf("FREQ  :") < 0) {
        }
        while (this.line != null && this.line.indexOf("FREQ  :") >= 0) {
            String[] stringArray = this.getTokens();
            while (this.rd() != null && this.line.indexOf("IR I") < 0) {
            }
            int n = this.asc.ac;
            if (this.vibrationNumber == 0) {
                this.freqAtom0 = n;
            }
            int n2 = stringArray.length - 2;
            boolean[] blArray = new boolean[n2];
            int n3 = 0;
            while (n3 < n2) {
                boolean bl = blArray[n3] = !this.doGetVibration(++this.vibrationNumber);
                if (!blArray[n3]) {
                    this.asc.cloneLastAtomSet();
                    this.asc.setAtomSetName(String.valueOf(stringArray[n3 + 2]) + " cm^-1");
                    this.asc.setAtomSetModelProperty("Frequency", String.valueOf(stringArray[n3 + 2]) + " cm^-1");
                    this.asc.setAtomSetModelProperty(".PATH", "Frequencies");
                }
                ++n3;
            }
            this.fillFrequencyData(n, this.ac, this.ac, blArray, false, 8, 9, null, 0, null);
            this.rd();
            this.rd();
        }
    }
}

