/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.MessagePackReader;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.cif.MMCifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.script.SV;
import org.jmol.util.Logger;

public class MMTFReader
extends MMCifReader {
    private boolean haveStructure;
    private String pdbID;
    private Map<String, Object> map;
    private int fileAtomCount;
    private int opCount = 0;
    private int[] groupModels;
    private int[] groupMap;
    private int[] groupDSSP;
    private int[] atomGroup;
    private String[] labelAsymList;
    private Atom[] atomMap;
    private Object[] entities;
    private int groupCount;
    private int ac0;
    private BS[] bsStructures;
    private int lastGroup;

    @Override
    protected void addHeader() {
    }

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.isBinary = true;
        this.isMMCIF = true;
        this.iHaveFractionalCoordinates = false;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void processBinaryDocument() throws Exception {
        String string2;
        boolean bl = !this.isCourseGrained && !this.checkFilterKey("NODOUBLE");
        this.isDSSP1 = !this.checkFilterKey("DSSP2");
        boolean bl2 = false;
        this.applySymmetryToBonds = true;
        this.map = new MessagePackReader(this.binaryDoc, true).readMap();
        this.entities = (Object[])this.map.get("entityList");
        if (Logger.debugging) {
            for (String string2 : this.map.keySet()) {
                Logger.info(string2);
            }
        }
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        Logger.info("MMTF version " + this.map.get("mmtfVersion"));
        Logger.info("MMTF Producer " + this.map.get("mmtfProducer"));
        string2 = (String)this.map.get("title");
        if (string2 != null) {
            this.appendLoadNote(string2);
        }
        this.pdbID = (String)this.map.get("structureId");
        if (this.pdbID == null) {
            this.pdbID = (String)this.map.get("pdbId");
        }
        this.fileAtomCount = (Integer)this.map.get("numAtoms");
        int n = (Integer)this.map.get("numBonds");
        this.groupCount = (Integer)this.map.get("numGroups");
        this.groupModels = new int[this.groupCount];
        this.groupDSSP = new int[this.groupCount];
        this.groupMap = new int[this.groupCount];
        int n2 = (Integer)this.map.get("numModels");
        this.appendLoadNote("id=" + this.pdbID + " numAtoms=" + this.fileAtomCount + " numBonds=" + n + " numGroups=" + this.groupCount + " numModels=" + n2);
        this.getMMTFAtoms(bl);
        if (!this.isCourseGrained) {
            int[] nArray = (int[])this.decode("bondOrderList");
            int[] nArray2 = (int[])this.decode("bondAtomList");
            this.addMMTFBonds(nArray, nArray2, 0, bl, true);
            if (this.isDSSP1 || bl2) {
                this.getStructure();
            }
        }
        this.setMMTFSymmetry();
        this.getMMTFBioAssembly();
        this.setModelPDB(true);
        if (Logger.debuggingHigh) {
            Logger.info(SV.getVariable(this.map).asString());
        }
    }

    @Override
    public void applySymmetryAndSetTrajectory() throws Exception {
        this.ac0 = this.ac;
        super.applySymmetryAndSetTrajectory();
        if (this.haveStructure) {
            this.addStructureSymmetry();
        }
    }

    private void getMMTFAtoms(boolean bl) throws Exception {
        int[] nArray = (int[])this.map.get("chainsPerModel");
        int[] nArray2 = (int[])this.map.get("groupsPerChain");
        this.labelAsymList = (String[])this.decode("chainIdList");
        String[] stringArray = (String[])this.decode("chainNameList");
        int[] nArray3 = (int[])this.decode("groupTypeList");
        int[] nArray4 = (int[])this.decode("groupIdList");
        Object[] objectArray = (Object[])this.map.get("groupList");
        char[] cArray = (char[])this.decode("insCodeList");
        int[] nArray5 = (int[])this.decode("atomIdList");
        boolean bl2 = nArray5 != null;
        char[] cArray2 = (char[])this.decode("altLocList");
        float[] fArray = (float[])this.decode("occupancyList");
        float[] fArray2 = (float[])this.decode("xCoordList");
        float[] fArray3 = (float[])this.decode("yCoordList");
        float[] fArray4 = (float[])this.decode("zCoordList");
        float[] fArray5 = (float[])this.decode("bFactorList");
        String[] stringArray2 = this.useAuthorChainID ? stringArray : this.labelAsymList;
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        char c = '\u0000';
        this.atomMap = new Atom[this.fileAtomCount];
        this.atomGroup = new int[this.fileAtomCount];
        int n9 = 0;
        int n10 = -1;
        while (n9 < this.groupCount) {
            if (++n4 >= n5) {
                string = stringArray2[n6];
                string2 = stringArray[n6];
                string3 = this.labelAsymList[n6];
                n5 = nArray2[n6++];
                n4 = 0;
                if (++n2 >= n3) {
                    this.groupModels[n9] = ++n;
                    n3 = nArray[n];
                    n2 = 0;
                    this.setModelPDB(true);
                    this.incrementModel(n + 1);
                    this.asc.setCurrentModelInfo("pdbID", this.pdbID);
                    this.nAtoms0 = this.asc.ac;
                    if (this.done) {
                        return;
                    }
                }
            }
            Map map = (Map)objectArray[nArray3[n9]];
            String[] stringArray3 = (String[])map.get("atomNameList");
            int n11 = stringArray3.length;
            if (this.skipping) {
                n8 += n11;
            } else {
                int n12;
                Object object;
                int n13 = n8;
                if (cArray != null) {
                    c = cArray[n9];
                }
                n7 = nArray4[n9];
                String string4 = (String)map.get("groupName");
                boolean bl3 = this.vwr.getJBR().isHetero(string4);
                if (bl3) {
                    object = "" + map.get("chemCompType");
                    if (this.htHetero == null || !this.htHetero.containsKey(string4)) {
                        if (this.entities != null && ((String)object).equals("NON-POLYMER")) {
                            n12 = this.entities.length;
                            block1: while (--n12 >= 0) {
                                Map map2 = (Map)this.entities[n12];
                                int[] nArray6 = (int[])map2.get("chainIndexList");
                                int n14 = nArray6.length;
                                while (--n14 >= 0) {
                                    if (nArray6[n14] != n2) continue;
                                    object = "a component of the entity \"" + map2.get("description") + "\"";
                                    break block1;
                                }
                            }
                        }
                        this.addHetero(string4, (String)object, false, true);
                    }
                }
                object = (String[])map.get("elementList");
                n12 = 0;
                int n15 = 0;
                int n16 = 0;
                while (n15 < n11) {
                    Atom atom = new Atom();
                    atom.isHetero = bl3;
                    if (c != '\u0000') {
                        atom.insertionCode = c;
                    }
                    this.setAtomCoordXYZ(atom, fArray2[n8], fArray3[n8], fArray4[n8]);
                    atom.elementSymbol = object[n16];
                    atom.atomName = stringArray3[n16++];
                    if (n7 >= 0) {
                        atom.sequenceNumber = n7;
                        this.maxSerial = Math.max(this.maxSerial, atom.sequenceNumber);
                    }
                    atom.group3 = string4;
                    this.setChainID(atom, string);
                    if (fArray5 != null) {
                        atom.bfactor = fArray5[n8];
                    }
                    if (cArray2 != null) {
                        atom.altLoc = cArray2[n8];
                    }
                    if (fArray != null) {
                        atom.foccupancy = fArray[n8];
                    }
                    if (bl2) {
                        atom.atomSerial = nArray5[n8];
                    }
                    if (this.filterAtom(atom, -1) && this.processSubclassAtom(atom, string3, string2)) {
                        if (n12 == 0) {
                            ++n10;
                            n12 = 1;
                        }
                        if (bl2) {
                            this.asc.addAtomWithMappedSerialNumber(atom);
                        } else {
                            this.asc.addAtom(atom);
                        }
                        this.atomMap[n8] = atom;
                        this.atomGroup[this.ac] = n9;
                        this.groupMap[n9] = this.lastGroup = n10;
                        ++this.ac;
                    }
                    ++n15;
                    ++n8;
                }
                if (!this.isCourseGrained) {
                    int[] nArray7 = (int[])map.get("bondOrderList");
                    int[] nArray8 = (int[])map.get("bondAtomList");
                    this.addMMTFBonds(nArray7, nArray8, n13, bl, false);
                }
            }
            ++n9;
        }
        this.asc.setCurrentModelInfo("pdbID", this.pdbID);
    }

    private void addMMTFBonds(int[] nArray, int[] nArray2, int n, boolean bl, boolean bl2) {
        if (nArray2 == null) {
            return;
        }
        bl &= nArray != null;
        int n2 = 0;
        int n3 = 0;
        int n4 = nArray2.length / 2;
        while (n2 < n4) {
            Atom atom = this.atomMap[nArray2[n3++] + n];
            Atom atom2 = this.atomMap[nArray2[n3++] + n];
            if (atom != null && atom2 != null) {
                Bond bond = new Bond(atom.index, atom2.index, bl ? nArray[n2] : 1);
                this.asc.addBond(bond);
                if (Logger.debugging && bl2) {
                    Logger.info("inter-group (" + (atom.atomSetIndex + 1) + "." + atom.index + "/" + (atom2.atomSetIndex + 1) + "." + atom2.index + ") bond " + atom.group3 + atom.sequenceNumber + "." + atom.atomName + " - " + atom2.group3 + atom2.sequenceNumber + "." + atom2.atomName + " " + bond.order);
                }
            }
            ++n2;
        }
    }

    private void setMMTFSymmetry() {
        this.setSpaceGroupName((String)this.map.get("spaceGroup"));
        float[] fArray = (float[])this.map.get("unitCell");
        if (fArray != null) {
            int n = 0;
            while (n < 6) {
                this.setUnitCellItem(n, fArray[n]);
                ++n;
            }
        }
    }

    private void getMMTFBioAssembly() {
        Object[] objectArray = (Object[])this.map.get("bioAssemblyList");
        if (objectArray == null) {
            return;
        }
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new Lst();
        }
        int n = objectArray.length;
        while (--n >= 0) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            this.vBiomolecules.addLast(hashtable);
            int n2 = n + 1;
            this.checkFilterAssembly("" + n2, hashtable);
            hashtable.put("name", "biomolecule " + n2);
            hashtable.put("molecule", n2);
            Lst<String> lst = new Lst<String>();
            Lst<String> lst2 = new Lst<String>();
            hashtable.put("biomts", new Lst());
            hashtable.put("chains", new Lst());
            hashtable.put("assemblies", lst);
            hashtable.put("operators", lst2);
            Map map = (Map)objectArray[n];
            Object[] objectArray2 = (Object[])map.get("transformList");
            SB sB = new SB();
            int n3 = 0;
            int n4 = objectArray2.length;
            while (n3 < n4) {
                Map map2 = (Map)objectArray2[n3];
                sB.setLength(0);
                int[] nArray = (int[])map2.get("chainIndexList");
                int n5 = 0;
                int n6 = nArray.length;
                while (n5 < n6) {
                    sB.append("$").append(this.labelAsymList[nArray[n5]]);
                    ++n5;
                }
                lst.addLast(sB.append("$").toString());
                String string = "" + ++this.opCount;
                this.addMatrix(string, M4.newA16((float[])map2.get("matrix")), false);
                lst2.addLast(string);
                ++n3;
            }
        }
    }

    private void getStructure() {
        int[] nArray = (int[])this.decode("secStructList");
        if (Logger.debugging) {
            Logger.info(PT.toJSON("secStructList", nArray));
        }
        BS[] bSArray = new BS[7];
        bSArray[0] = new BS();
        bSArray[2] = new BS();
        bSArray[3] = new BS();
        bSArray[4] = new BS();
        bSArray[6] = new BS();
        this.bsStructures = bSArray;
        int n = -1;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            switch (n3) {
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: {
                    int n4 = this.groupMap[n2];
                    this.bsStructures[n3].set(n4);
                    this.groupDSSP[n4] = n3 + 1;
                    n = n2;
                }
            }
            ++n2;
        }
        int n5 = n2 = this.isDSSP1 ? this.asc.iSet : this.groupModels[n];
        if (n >= 0) {
            this.haveStructure = true;
            this.asc.addStructure(new Structure(n2, null, null, null, 0, 0, this.bsStructures));
        }
    }

    private void addStructureSymmetry() {
        if (this.asc.ac == 0) {
            return;
        }
        Atom[] atomArray = this.asc.atoms;
        BS bS = this.asc.bsAtoms;
        int n = this.lastGroup;
        int n2 = -1;
        int n3 = this.ac0;
        int n4 = this.asc.ac;
        while (n3 < n4) {
            if (bS == null || bS.get(n3)) {
                int n5;
                Atom atom = atomArray[n3];
                int n6 = this.atomGroup[atom.atomSite];
                if (n6 != n2) {
                    n2 = n6;
                    ++n;
                }
                if ((n5 = this.groupDSSP[n6]) > 0) {
                    this.bsStructures[n5 - 1].set(n);
                }
            }
            ++n3;
        }
    }

    private Object decode(String string) {
        return MessagePackReader.decode((byte[])this.map.get(string));
    }
}

