/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.nodes.parser;

import jadx.core.dex.attributes.IAttributeNode;
import jadx.core.dex.attributes.annotations.Annotation;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignatureParser {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureParser.class);
    private static final char STOP_CHAR = '\u0000';
    private final String sign;
    private final int end;
    private int pos;
    private int mark;

    public SignatureParser(String signature) {
        this.sign = signature;
        this.end = this.sign.length();
        this.pos = -1;
        this.mark = 0;
    }

    public static SignatureParser fromNode(IAttributeNode node) {
        Annotation a = node.getAnnotation("dalvik.annotation.Signature");
        if (a == null) {
            return null;
        }
        return new SignatureParser(SignatureParser.mergeSignature((List)a.getDefaultValue()));
    }

    private char next() {
        ++this.pos;
        if (this.pos >= this.end) {
            return '\u0000';
        }
        return this.sign.charAt(this.pos);
    }

    private boolean lookAhead(char ch) {
        int next = this.pos + 1;
        return next < this.end && this.sign.charAt(next) == ch;
    }

    private void mark() {
        this.mark = this.pos;
    }

    private String slice() {
        if (this.mark >= this.pos) {
            return "";
        }
        return this.sign.substring(this.mark, this.pos);
    }

    private String inclusiveSlice() {
        if (this.mark >= this.pos) {
            return "";
        }
        return this.sign.substring(this.mark, this.pos + 1);
    }

    private boolean forwardTo(char lastChar) {
        char ch;
        int startPos = this.pos;
        while ((ch = this.next()) != '\u0000') {
            if (ch != lastChar) continue;
            return true;
        }
        this.pos = startPos;
        return false;
    }

    private void consume(char exp) {
        char c = this.next();
        if (exp != c) {
            throw new JadxRuntimeException("Consume wrong char: '" + c + "' != '" + exp + "', sign: " + this.debugString());
        }
    }

    private boolean tryConsume(char exp) {
        if (this.lookAhead(exp)) {
            this.next();
            return true;
        }
        return false;
    }

    private String consumeUntil(char lastChar) {
        this.mark();
        return this.forwardTo(lastChar) ? this.slice() : null;
    }

    public ArgType consumeType() {
        char ch = this.next();
        this.mark();
        switch (ch) {
            case 'L': {
                ArgType obj = this.consumeObjectType(false);
                if (obj == null) break;
                return obj;
            }
            case 'T': {
                this.next();
                this.mark();
                if (!this.forwardTo(';')) break;
                return ArgType.genericType(this.slice());
            }
            case '[': {
                return ArgType.array(this.consumeType());
            }
            case '\u0000': {
                return null;
            }
            default: {
                ArgType type = ArgType.parse(ch);
                if (type == null) break;
                return type;
            }
        }
        throw new JadxRuntimeException("Can't parse type: " + this.debugString());
    }

    private ArgType consumeObjectType(boolean incompleteType) {
        char ch;
        this.mark();
        do {
            if ((ch = this.next()) != '\u0000') continue;
            return null;
        } while (ch != '<' && ch != ';');
        if (ch == ';') {
            String obj = incompleteType ? this.slice().replace('/', '.') : this.inclusiveSlice();
            return ArgType.object(obj);
        }
        String obj = this.slice();
        if (!incompleteType) {
            obj = obj + ";";
        }
        ArgType[] genArr = this.consumeGenericArgs();
        this.consume('>');
        ArgType genericType = ArgType.generic(obj, genArr);
        if (this.lookAhead('.')) {
            this.consume('.');
            this.next();
            ArgType inner = this.consumeObjectType(true);
            if (inner == null) {
                throw new JadxRuntimeException("No inner type found: " + this.debugString());
            }
            return ArgType.genericInner(genericType, inner.getObject(), inner.getGenericTypes());
        }
        this.consume(';');
        return genericType;
    }

    private ArgType[] consumeGenericArgs() {
        ArgType type;
        LinkedList<ArgType> list = new LinkedList<ArgType>();
        do {
            if (this.lookAhead('*')) {
                this.next();
                type = ArgType.wildcard();
            } else if (this.lookAhead('+')) {
                this.next();
                type = ArgType.wildcard(this.consumeType(), 1);
            } else if (this.lookAhead('-')) {
                this.next();
                type = ArgType.wildcard(this.consumeType(), -1);
            } else {
                type = this.consumeType();
            }
            if (type == null) continue;
            list.add(type);
        } while (type != null && !this.lookAhead('>'));
        return list.toArray(new ArgType[list.size()]);
    }

    public Map<ArgType, List<ArgType>> consumeGenericMap() {
        if (!this.lookAhead('<')) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ArgType, List<ArgType>> map = new LinkedHashMap<ArgType, List<ArgType>>(2);
        this.consume('<');
        while (!this.lookAhead('>') && this.next() != '\u0000') {
            String id = this.consumeUntil(':');
            if (id == null) {
                LOG.error("Can't parse generic map: {}", (Object)this.sign);
                return Collections.emptyMap();
            }
            this.tryConsume(':');
            List<ArgType> types = this.consumeExtendsTypesList();
            map.put(ArgType.genericType(id), types);
        }
        this.consume('>');
        return map;
    }

    private List<ArgType> consumeExtendsTypesList() {
        boolean next;
        List<ArgType> types = Collections.emptyList();
        do {
            ArgType argType;
            if (!(argType = this.consumeType()).equals(ArgType.OBJECT)) {
                if (types.isEmpty()) {
                    types = new LinkedList();
                }
                types.add(argType);
            }
            if (!(next = this.lookAhead(':'))) continue;
            this.consume(':');
        } while (next);
        return types;
    }

    public List<ArgType> consumeMethodArgs() {
        this.consume('(');
        if (this.lookAhead(')')) {
            this.consume(')');
            return Collections.emptyList();
        }
        LinkedList<ArgType> args = new LinkedList<ArgType>();
        do {
            args.add(this.consumeType());
        } while (!this.lookAhead(')'));
        this.consume(')');
        return args;
    }

    private static String mergeSignature(List<String> list) {
        if (list.size() == 1) {
            return list.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append(s);
        }
        return sb.toString();
    }

    private String debugString() {
        if (this.pos >= this.sign.length()) {
            return this.sign;
        }
        return this.sign + " at position " + this.pos + " ('" + this.sign.charAt(this.pos) + "')";
    }

    public String toString() {
        if (this.pos == -1) {
            return this.sign;
        }
        return this.sign.substring(0, this.mark) + '{' + this.sign.substring(this.mark, this.pos) + '}' + this.sign.substring(this.pos);
    }
}

