/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifdef __cplusplus
extern "C" {
#endif


#ifndef _SORT_H_
#define _SORT_H_

#ifndef _CARAT_TYPEDEF_H_
#include"typedef.h"
#endif

#ifdef __STDC__
/*-------------------------------------------------------------*\
| FILE: compare.c 
\*-------------------------------------------------------------*/
extern int mat_comp(matrix_TYP *m1, matrix_TYP *m2);
extern int mat_col_comp(matrix_TYP *m1, matrix_TYP *m2);
extern int lower_triangular_mat_comp(matrix_TYP *m1,matrix_TYP *m2);
extern int vec_comp(int *v1, int *v2, int dim);
extern int pointer_mat_comp(int **m1, int **m2, int rows, int cols);
extern int pointer_lower_triangular_mat_comp(int **m1,int **m2, int n, int m);

/*-------------------------------------------------------------*\
| FILE: quicksort.c 
\*-------------------------------------------------------------*/
extern void mat_quicksort(matrix_TYP **M, int inf, int sup, int (*comp)());
extern void vec_quicksort(int **v, int inf, int sup, int dim, int (*comp)());
extern void pointer_mat_quicksort(int ***v, int inf, int sup, int rows,
     int cols, int (*comp)());

/*-------------------------------------------------------------*\
| FILE: search.c 
\*-------------------------------------------------------------*/
extern int mat_search(matrix_TYP *M, matrix_TYP **List, int List_no,
     int (*comp)());
extern int vec_search(matrix_TYP *M, matrix_TYP **List, int List_no,
     int dim, int (*comp)());
extern int pointer_mat_search(matrix_TYP **M, matrix_TYP ***List, int List_no,
     int rows, int cols, int (*comp)());

#else
/*-------------------------------------------------------------*\
| FILE: compare.c 
\*-------------------------------------------------------------*/
extern int mat_comp();
extern int mat_col_comp();
extern int lower_triangular_mat_comp();
extern int vec_comp();
extern int pointer_mat_comp();
extern int pointer_lower_triangular_mat_comp();

/*-------------------------------------------------------------*\
| FILE: quicksort.c 
\*-------------------------------------------------------------*/
extern void mat_quicksort();
extern void vec_quicksort();
extern void pointer_mat_quicksort();

/*-------------------------------------------------------------*\
| FILE: search.c 
\*-------------------------------------------------------------*/
extern int mat_search();
extern int vec_search();
extern int pointer_mat_search();

#endif
#endif


#ifdef __cplusplus
}
#endif


