define(["datetime","connectionManager","globalize","appRouter","itemHelper","indicators","material-icons","css!./mediainfo.css","programStyles","emby-linkbutton"],function(datetime,connectionManager,globalize,appRouter,itemHelper,indicators){"use strict";function getHumanReadableRuntime(ticks){try{var days=Math.trunc(ticks/864e9),hours=Math.trunc(ticks%864e9/36e9),mins=Math.trunc(ticks%36e9/6e8),parts=[];return days&&parts.push(days+"d"),hours&&parts.push(hours+"h"),mins&&parts.push(mins+"m"),parts.length?parts.join(" "):datetime.getDisplayRunningTime(ticks)}catch(err){return datetime.getDisplayRunningTime(ticks)}}function getTimerIndicator(item){var status;if("SeriesTimer"===item.Type)return'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE062;</i>';if(item.TimerId||item.SeriesTimerId)status=item.Status||"Cancelled";else{if("Timer"!==item.Type)return"";status=item.Status}return item.SeriesTimerId?"Cancelled"!==status?'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE062;</i>':'<i class="md-icon mediaInfoItem mediaInfoIconItem">&#xE062;</i>':'<i class="md-icon mediaInfoItem mediaInfoIconItem mediaInfoTimerIcon">&#xE061;</i>'}function getProgramInfoHtml(item,options){var text,date,html="",miscInfo=[];if(item.StartDate&&!1!==options.programTime)try{text="",date=datetime.parseISO8601Date(item.StartDate),!1!==options.startDate&&(text+=datetime.toLocaleDateString(date,{weekday:"short",month:"short",day:"numeric"})),text+=" "+datetime.getDisplayTime(date),item.EndDate&&(date=datetime.parseISO8601Date(item.EndDate),text+=" &ndash; "+datetime.getDisplayTime(date)),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.StartDate)}if(item.ChannelNumber&&miscInfo.push("CH "+item.ChannelNumber),item.ChannelName&&(options.interactive&&item.ChannelId?miscInfo.push({html:'<a is="emby-linkbutton" class="button-flat mediaInfoItem" href="'+appRouter.getRouteUrl({ServerId:item.ServerId,Type:"TvChannel",Name:item.ChannelName,Id:item.ChannelId})+'">'+item.ChannelName+"</a>"}):miscInfo.push(item.ChannelName)),!1!==options.timerIndicator){var timerHtml=getTimerIndicator(item);timerHtml&&miscInfo.push({html:timerHtml})}return html+=miscInfo.map(function(m){return getMediaInfoItem(m)}).join("")}function getMediaInfoHtml(item,options){var html="",miscInfo=[];options=options||{};var text,date,count,showFolderRuntime="MusicAlbum"===item.Type||"MusicArtist"===item.MediaType||"Playlist"===item.MediaType||"MusicGenre"===item.MediaType;if(showFolderRuntime&&(count=item.SongCount||item.ChildCount,count&&miscInfo.push(globalize.translate("sharedcomponents#TrackCount",count)),item.RunTimeTicks&&miscInfo.push(getHumanReadableRuntime(item.RunTimeTicks))),("Episode"===item.Type||"Photo"===item.MediaType)&&!1!==options.originalAirDate&&item.PremiereDate)try{date=datetime.parseISO8601Date(item.PremiereDate),text=datetime.toLocaleDateString(date),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}if("SeriesTimer"===item.Type&&(item.RecordAnyTime?miscInfo.push(globalize.translate("sharedcomponents#Anytime")):miscInfo.push(datetime.getDisplayTime(item.StartDate)),item.RecordAnyChannel?miscInfo.push(globalize.translate("sharedcomponents#AllChannels")):miscInfo.push(item.ChannelName||globalize.translate("sharedcomponents#OneChannel"))),item.StartDate&&"Program"!==item.Type&&"SeriesTimer"!==item.Type)try{date=datetime.parseISO8601Date(item.StartDate),text=datetime.toLocaleDateString(date),miscInfo.push(text),"Recording"!==item.Type&&(text=datetime.getDisplayTime(date),miscInfo.push(text))}catch(e){console.log("Error parsing date: "+item.StartDate)}if(!1!==options.year&&item.ProductionYear&&"Series"===item.Type)if("Continuing"===item.Status)miscInfo.push(globalize.translate("sharedcomponents#SeriesYearToPresent",item.ProductionYear));else if(item.ProductionYear){if(text=item.ProductionYear,item.EndDate)try{var endYear=datetime.parseISO8601Date(item.EndDate).getFullYear();endYear!==item.ProductionYear&&(text+=" &ndash; "+datetime.parseISO8601Date(item.EndDate).getFullYear())}catch(e){console.log("Error parsing date: "+item.EndDate)}miscInfo.push(text)}if("Program"===item.Type){if(!1!==options.programIndicator){connectionManager.getApiClient(item.ServerId);item.IsLive?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem liveTvProgram">'+globalize.translate("sharedcomponents#Live")+"</div>"}):item.IsPremiere?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem premiereTvProgram">'+globalize.translate("sharedcomponents#Premiere")+"</div>"}):item.IsNew||item.IsSeries&&!item.IsRepeat&&!connectionManager.getApiClient(item.ServerId).isMinServerVersion("3.6.0.0")?miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem newTvProgram">'+globalize.translate("sharedcomponents#AttributeNew")+"</div>"}):item.IsRepeat&&miscInfo.push({html:'<div class="mediaInfoProgramAttribute mediaInfoItem repeatTvProgram">'+globalize.translate("sharedcomponents#Repeat")+"</div>"})}if((item.IsSeries||item.EpisodeTitle)&&!1!==options.episodeTitle)(text=itemHelper.getDisplayName(item,{includeIndexNumber:options.episodeTitleIndexNumber}))&&miscInfo.push(text);else if(item.IsMovie&&item.ProductionYear&&!1!==options.originalAirDate)miscInfo.push(item.ProductionYear);else if(item.PremiereDate&&!1!==options.originalAirDate)try{date=datetime.parseISO8601Date(item.PremiereDate),text=globalize.translate("sharedcomponents#OriginalAirDateValue",datetime.toLocaleDateString(date)),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}else item.ProductionYear&&miscInfo.push(item.ProductionYear)}if(!1!==options.year&&"Series"!==item.Type&&"Episode"!==item.Type&&"Person"!==item.Type&&"Photo"!==item.MediaType&&"Program"!==item.Type&&"Season"!==item.Type)if(item.ProductionYear)miscInfo.push(item.ProductionYear);else if(item.PremiereDate)try{text=datetime.parseISO8601Date(item.PremiereDate).getFullYear(),miscInfo.push(text)}catch(e){console.log("Error parsing date: "+item.PremiereDate)}if(item.RunTimeTicks&&"Series"!==item.Type&&"Program"!==item.Type&&!showFolderRuntime&&!1!==options.runtime&&("Audio"===item.Type?miscInfo.push(datetime.getDisplayRunningTime(item.RunTimeTicks)):miscInfo.push(getHumanReadableRuntime(item.RunTimeTicks))),item.OfficialRating&&"Season"!==item.Type&&"Episode"!==item.Type&&miscInfo.push({text:item.OfficialRating,cssClass:"mediaInfoOfficialRating"}),item.Video3DFormat&&miscInfo.push("3D"),"Photo"===item.MediaType&&item.Width&&item.Height&&miscInfo.push(item.Width+"x"+item.Height),!1!==options.container&&"Audio"===item.Type&&item.Container&&miscInfo.push(item.Container),html+=miscInfo.map(function(m){return getMediaInfoItem(m)}).join(""),html+=getStarIconsHtml(item),item.HasSubtitles&&!1!==options.subtitles&&(html+='<div class="mediaInfoItem mediaInfoText closedCaptionMediaInfoText">CC</div>'),item.CriticRating&&!1!==options.criticRating&&(item.CriticRating>=60?html+='<div class="mediaInfoItem mediaInfoCriticRating mediaInfoCriticRatingFresh">'+item.CriticRating+"%</div>":html+='<div class="mediaInfoItem mediaInfoCriticRating mediaInfoCriticRatingRotten">'+item.CriticRating+"%</div>"),!1!==options.endsAt){var endsAt=getEndsAt(item);endsAt&&(html+=getMediaInfoItem(endsAt,"endsAt"))}return html+=indicators.getMissingIndicator(item)}function getEndsAt(item){if("Video"===item.MediaType&&item.RunTimeTicks&&!item.StartDate){var endDate=(new Date).getTime()+item.RunTimeTicks/1e4;endDate=new Date(endDate);var displayTime=datetime.getDisplayTime(endDate);return globalize.translate("sharedcomponents#EndsAtValue",displayTime)}return null}function getEndsAtFromPosition(runtimeTicks,positionTicks,includeText){var endDate=(new Date).getTime()+(runtimeTicks-(positionTicks||0))/1e4;endDate=new Date(endDate);var displayTime=datetime.getDisplayTime(endDate);return!1===includeText?displayTime:globalize.translate("sharedcomponents#EndsAtValue",displayTime)}function getMediaInfoItem(m,cssClass){cssClass=cssClass?cssClass+" mediaInfoItem":"mediaInfoItem";var mediaInfoText=m;if("string"!=typeof m&&"number"!=typeof m){if(m.html)return m.html;mediaInfoText=m.text,cssClass+=" "+m.cssClass}return'<div class="'+cssClass+'">'+mediaInfoText+"</div>"}function getStarIconsHtml(item){var html="",rating=item.CommunityRating;return rating&&(html+='<div class="starRatingContainer mediaInfoItem">',html+='<i class="md-icon starIcon">&#xE838;</i>',html+=rating,html+="</div>"),html}function dynamicEndTime(elem,item){var interval=setInterval(function(){if(!document.body.contains(elem))return void clearInterval(interval);elem.innerHTML=getEndsAt(item)},6e4)}function fillPrimaryMediaInfo(elem,item,options){var html=getPrimaryMediaInfoHtml(item,options);elem.innerHTML=html,afterFill(elem,item,options)}function fillSecondaryMediaInfo(elem,item,options){var html=getSecondaryMediaInfoHtml(item,options);elem.innerHTML=html,afterFill(elem,item,options)}function afterFill(elem,item,options){if(!1!==options.endsAt){var endsAtElem=elem.querySelector(".endsAt");endsAtElem&&dynamicEndTime(endsAtElem,item)}var lnkChannel=elem.querySelector(".lnkChannel");lnkChannel&&lnkChannel.addEventListener("click",onChannelLinkClick)}function onChannelLinkClick(e){var channelId=this.getAttribute("data-id"),serverId=this.getAttribute("data-serverid");return appRouter.showItem(channelId,serverId),e.preventDefault(),!1}function getPrimaryMediaInfoHtml(item,options){return options=options||{},null==options.interactive&&(options.interactive=!1),getMediaInfoHtml(item,options)}function getSecondaryMediaInfoHtml(item,options){return options=options||{},null==options.interactive&&(options.interactive=!1),"Program"===item.Type?getProgramInfoHtml(item,options):""}function getResolutionText(i){var width=i.Width,height=i.Height;if(width&&height){if(width>=3800||height>=2e3)return"4K";if(width>=2500||height>=1400)return i.IsInterlaced?"1440i":"1440P";if(width>=1800||height>=1e3)return i.IsInterlaced?"1080i":"1080P";if(width>=1200||height>=700)return i.IsInterlaced?"720i":"720P";if(width>=700||height>=400)return i.IsInterlaced?"480i":"480P"}return null}function getAudioStreamForDisplay(item){if(!item.MediaSources)return null;var mediaSource=item.MediaSources[0];return mediaSource?(mediaSource.MediaStreams||[]).filter(function(i){return"Audio"===i.Type&&(i.Index===mediaSource.DefaultAudioStreamIndex||null==mediaSource.DefaultAudioStreamIndex)})[0]:null}function getMediaInfoStats(item,options){options=options||{};var list=[],mediaSource=(item.MediaSources||[])[0]||{},videoStream=(mediaSource.MediaStreams||[]).filter(function(i){return"Video"===i.Type})[0]||{},audioStream=getAudioStreamForDisplay(item)||{};"Dvd"!==item.VideoType&&"dvd"!==item.Container||list.push({type:"mediainfo",text:"Dvd"}),"BluRay"!==item.VideoType&&"bluray"!==item.Container||list.push({type:"mediainfo",text:"BluRay"});var resolutionText=getResolutionText(videoStream);resolutionText&&list.push({type:"mediainfo",text:resolutionText}),videoStream.Codec&&list.push({type:"mediainfo",text:videoStream.Codec});var channelText,channels=audioStream.Channels;8===channels?channelText="7.1":7===channels?channelText="6.1":6===channels?channelText="5.1":2===channels&&(channelText="2.0"),channelText&&list.push({type:"mediainfo",text:channelText});var audioCodec=(audioStream.Codec||"").toLowerCase();if("dca"!==audioCodec&&"dts"!==audioCodec||!audioStream.Profile?audioStream.Codec&&list.push({type:"mediainfo",text:audioStream.Codec}):list.push({type:"mediainfo",text:audioStream.Profile}),item.DateCreated&&itemHelper.enableDateAddedDisplay(item)){var dateCreated=datetime.parseISO8601Date(item.DateCreated);list.push({type:"added",text:globalize.translate("sharedcomponents#AddedOnValue",datetime.toLocaleDateString(dateCreated)+" "+datetime.getDisplayTime(dateCreated))})}return list}return{getMediaInfoHtml:getPrimaryMediaInfoHtml,fill:fillPrimaryMediaInfo,getEndsAt:getEndsAt,getEndsAtFromPosition:getEndsAtFromPosition,getPrimaryMediaInfoHtml:getPrimaryMediaInfoHtml,getSecondaryMediaInfoHtml:getSecondaryMediaInfoHtml,fillPrimaryMediaInfo:fillPrimaryMediaInfo,fillSecondaryMediaInfo:fillSecondaryMediaInfo,getMediaInfoStats:getMediaInfoStats,getResolutionText:getResolutionText}});